/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.converter.db;

import com.e1c.langtool.internal.converter.db.ConvertedValues;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mapdb.Serializer;

public class ConvertedValuesSerializer
implements Serializer<ConvertedValues>,
Serializable {
    private static final long serialVersionUID = 5583378648922363181L;

    public ConvertedValues deserialize(DataInput in, int available) throws IOException {
        int total = in.readInt();
        HashMap<String, String> result = new HashMap<String, String>(total);
        int i = 0;
        while (i < total) {
            String key = in.readUTF();
            String value = in.readUTF();
            result.put(key, value);
            ++i;
        }
        return new ConvertedValues(result);
    }

    public void serialize(DataOutput out, ConvertedValues data) throws IOException {
        Map<String, String> values = data.getValues();
        out.writeInt(values.size());
        for (Map.Entry<String, String> entry : values.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeUTF(entry.getValue());
        }
    }

    public int fixedSize() {
        return -1;
    }
}

