/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.converter.db;

import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.internal.converter.ConverterPlugin;
import com.e1c.langtool.internal.converter.db.ConvertedValues;
import com.e1c.langtool.internal.converter.db.ResourceIndexConverterStorage;
import com.e1c.langtool.internal.converter.db.TargetKeyStorage;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ProjectConverterStorage {
    private static final String DB_FILE_NAME = "converted-data.db";
    private static final String DB_FOLDER = "converter";
    private static final String DB_FILE_NAME_INDEX = "index.db";
    private static final ConvertedValues EMPTY_VALUES = new ConvertedValues();
    private static final String EMPTY_TARGET_KEYS = "";
    private final IProject project;
    private final TargetKeyStorage storage;
    private final ResourceIndexConverterStorage indexStorage;
    private final Map<IPath, ConvertedValues> recordingQueue = new ConcurrentHashMap<IPath, ConvertedValues>();

    public ProjectConverterStorage(IProject project) {
        this.project = project;
        this.storage = new TargetKeyStorage(ProjectConverterStorage.getStorageFile(project));
        this.indexStorage = new ResourceIndexConverterStorage(ProjectConverterStorage.getStorageFileIndex(project));
    }

    public boolean isEmpty() {
        return this.indexStorage.isEmpty();
    }

    public boolean valuesExists(IPath path) {
        if (this.indexStorage.getResourceId(path) == -1L) {
            return false;
        }
        return this.indexStorage.getValues(this.indexStorage.getResourceId(path)) != null;
    }

    public ConvertedValues getValues(IPath path) {
        long id = this.indexStorage.getResourceIdOrNew(path);
        ConvertedValues values = this.storage.getValues(id);
        if (values == null) {
            return EMPTY_VALUES;
        }
        return values;
    }

    public ConvertedValues putValues(IPath path) {
        long id = this.indexStorage.getResourceIdOrNew(path);
        ConvertedValues values = this.recordingQueue.get(path);
        if (values != null) {
            this.storage.putValues(id, values);
            this.recordingQueue.remove(path);
        } else {
            values = new ConvertedValues();
        }
        return values;
    }

    public ConvertedValues collectValues(IPath path, ConvertedValues values) {
        return this.recordingQueue.merge(path, values, ConvertedValues::new);
    }

    public ConvertedValues removeValues(IPath path) {
        this.recordingQueue.remove(path);
        long id = this.indexStorage.getResourceIdOrNew(path);
        return this.storage.removeValues(id);
    }

    public String getTargetKey(IPath path) {
        long id = this.indexStorage.getResourceIdOrNew(path);
        String key = this.storage.getTargetKey(id);
        if (key == null) {
            return EMPTY_TARGET_KEYS;
        }
        return key;
    }

    public String putTargetKey(IPath path, String targetKey) {
        long id = this.indexStorage.getResourceIdOrNew(path);
        return this.storage.putTargetKey(id, targetKey);
    }

    public String removeTargetKey(IPath path) {
        this.recordingQueue.remove(path);
        long id = this.indexStorage.getResourceIdOrNew(path);
        return this.storage.removeTargetKey(id);
    }

    public void open() {
        this.indexStorage.open();
    }

    public void close() {
        this.storage.close();
        this.indexStorage.close();
    }

    public boolean delete() {
        this.storage.delete();
        this.indexStorage.delete();
        this.recordingQueue.clear();
        File file = ProjectConverterStorage.getStorageFile(this.project);
        if (file.exists()) {
            TranslationUtils.cleanUpMabDbFiles((File)file);
        }
        return true;
    }

    private static File getStorageFileIndex(IProject project) {
        return ProjectConverterStorage.getStorageFile(project, DB_FILE_NAME_INDEX);
    }

    private static File getStorageFile(IProject project) {
        return ProjectConverterStorage.getStorageFile(project, DB_FILE_NAME);
    }

    private static File getStorageFile(IProject project, String name) {
        IPath path = Platform.getStateLocation((Bundle)ConverterPlugin.getDefault().getBundle());
        IPath folder = path.append(DB_FOLDER).append(project.getName());
        return folder.append(name).toFile();
    }
}

