/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.chart.dendrogram;

import com._1c.g5.v8.dt.chart.model.Chart;
import com._1c.g5.v8.dt.dendrogram.model.Dendrogram;
import com._1c.g5.v8.dt.dendrogram.model.DendrogramDimensionValue;
import com._1c.g5.v8.dt.dendrogram.model.DendrogramElements;
import com._1c.g5.v8.dt.dendrogram.model.DendrogramLinkValue;
import com._1c.g5.v8.dt.dendrogram.model.DendrogramLinks;
import com._1c.g5.v8.dt.dendrogram.model.DendrogramPackage;
import com.e1c.langtool.IBasicProcessor;
import java.util.ArrayDeque;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.EcoreUtil2;

public abstract class DendrogramProcessor
implements IBasicProcessor {
    private final Collection<EObject> allObjects = new ArrayDeque<EObject>();
    private final EObject object;
    private boolean processChildObjects = true;
    protected IProgressMonitor monitor;

    public DendrogramProcessor(EObject object) {
        this.object = object;
    }

    public boolean isCanceled() {
        return this.monitor == null ? false : this.monitor.isCanceled();
    }

    public boolean isProcessChildObjects() {
        return this.processChildObjects;
    }

    public void setProcessChildObjects(boolean processChildObjects) {
        this.processChildObjects = processChildObjects;
    }

    public void process(IProgressMonitor monitor) {
        this.monitor = monitor;
        if (DendrogramProcessor.isSupported(this.object)) {
            this.allObjects.add(this.object);
        }
        this.doProcessInternal(this.allObjects);
    }

    protected static boolean isSupported(EObject obj) {
        Dendrogram parent;
        EPackage objectPackage = obj.eClass().getEPackage();
        if (objectPackage.equals(DendrogramPackage.eINSTANCE)) {
            return true;
        }
        return obj instanceof Chart && (parent = (Dendrogram)EcoreUtil2.getContainerOfType((EObject)obj, Dendrogram.class)) != null;
    }

    protected abstract <T extends EObject> void doProcess(T var1, Class<T> var2);

    private void doProcessInternal(Collection<? extends EObject> objects) {
        for (EObject eObject : objects) {
            if (this.isCanceled()) {
                return;
            }
            this.doProcessInternal(eObject);
        }
    }

    private void doProcessInternal(EObject obj) {
        if (this.isCanceled()) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof Dendrogram) {
            this.doProcessInternal((Dendrogram)obj);
        } else if (obj instanceof DendrogramElements) {
            this.doProcessInternal((DendrogramElements)obj);
        } else if (obj instanceof Chart) {
            this.doProcessInternal((Chart)obj);
        } else if (obj instanceof DendrogramLinks) {
            this.doProcessInternal((DendrogramLinks)obj);
        } else if (obj instanceof DendrogramLinkValue) {
            this.doProcessInternal((DendrogramLinkValue)obj);
        } else if (obj instanceof DendrogramDimensionValue) {
            this.doProcessInternal((DendrogramDimensionValue)obj);
        }
    }

    private void doProcessInternal(Dendrogram obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Dendrogram.class);
        this.doProcessInternal(obj.getChart());
        this.doProcessInternal(obj.getElements());
        this.doProcessInternal(obj.getLinks());
    }

    private void doProcessInternal(DendrogramElements obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, DendrogramElements.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getValue());
    }

    private void doProcessInternal(Chart obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Chart.class);
    }

    private void doProcessInternal(DendrogramLinks obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, DendrogramLinks.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getValue());
    }

    private void doProcessInternal(DendrogramDimensionValue obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, DendrogramDimensionValue.class);
    }

    private void doProcessInternal(DendrogramLinkValue obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, DendrogramLinkValue.class);
    }
}

