/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.history.prefs;

import com.e1c.langtool.internal.history.HistoryPlugin;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.graphics.RGB;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class HistoryTransPrefs {
    public static final String MAX_TRANSLATIONS_KEY = "maxTranslations";
    public static final int DEFAULT_MAX_TRANSLATIONS = 20;
    public static final String SCOPE_FULL_MATCH_COLOR = "scopeColor0";
    public static final String SCOPE_FULL_MATCH_IN_ALL_RESOURCES_COLOR = "scopeColor1";
    public static final String SCOPE_FULL_MATCH_IN_ALL_FEATURE_NAMES_COLOR = "scopeColor2";
    public static final String SCOPE_FULL_MATCH_IN_OPPOSITE_CONTEXT_COLOR = "scopeColor3";
    public static final String SCOPE_FT_WITH_CONTEXT_COLOR = "scopeColor4";
    public static final String SCOPE_FT_IN_ALL_RESOURCES_COLOR = "scopeColor5";
    public static final String SCOPE_FT_EVERYWHERE_COLOR = "scopeColor6";
    public static final String SCOPE_FULL_MATCH_ENABLED = "scopeEnabled0";
    public static final String SCOPE_FULL_MATCH_IN_ALL_RESOURCES_ENABLED = "scopeEnabled1";
    public static final String SCOPE_FULL_MATCH_IN_ALL_FEATURE_NAMES_ENABLED = "scopeEnabled2";
    public static final String SCOPE_FULL_MATCH_IN_OPPOSITE_CONTEXT_ENABLED = "scopeEnabled3";
    public static final String SCOPE_FT_WITH_CONTEXT_ENABLED = "scopeEnabled4";
    public static final String SCOPE_FT_IN_ALL_RESOURCES_ENABLED = "scopeEnabled5";
    public static final String SCOPE_FT_EVERYWHERE_ENABLED = "scopeEnabled6";
    public static final String SCOPE_ORDER = "scopeOrder";
    private static final Map<String, String> SCOPE_COLOR_MAP = ImmutableMap.builder().put((Object)"scope_0", (Object)"scopeColor0").put((Object)"scope_1", (Object)"scopeColor1").put((Object)"scope_2", (Object)"scopeColor2").put((Object)"scope_3", (Object)"scopeColor3").put((Object)"scope_5", (Object)"scopeColor4").put((Object)"scope_6", (Object)"scopeColor5").put((Object)"scope_7", (Object)"scopeColor6").build();
    private static final Map<String, String> SCOPE_ENABLED_MAP = ImmutableMap.builder().put((Object)"scope_0", (Object)"scopeEnabled0").put((Object)"scope_1", (Object)"scopeEnabled1").put((Object)"scope_2", (Object)"scopeEnabled2").put((Object)"scope_3", (Object)"scopeEnabled3").put((Object)"scope_5", (Object)"scopeEnabled4").put((Object)"scope_6", (Object)"scopeEnabled5").put((Object)"scope_7", (Object)"scopeEnabled6").build();
    private static final List<String> DEFAULT_SCOPE_IDS = Arrays.asList("scope_0", "scope_1", "scope_2", "scope_3", "scope_5", "scope_6", "scope_7");
    private static final IEclipsePreferences PREFS = HistoryPlugin.getDefault().getPreferences();

    public static int getMaxTranslations() {
        return Integer.valueOf(HistoryTransPrefs.getValue(MAX_TRANSLATIONS_KEY, String.valueOf(20)));
    }

    public static void setMaxTranslations(int maxNum) {
        if (maxNum < 1) {
            throw new IllegalArgumentException("The max number of translations returning by scope provider must be positive");
        }
        PREFS.putInt(MAX_TRANSLATIONS_KEY, maxNum);
        HistoryTransPrefs.flush();
    }

    public static Optional<String> getColorPrefKeyByScopeId(String scopeId) {
        return Optional.ofNullable(SCOPE_COLOR_MAP.get(scopeId));
    }

    public static Optional<String> getEnabledPrefKeyByScopeId(String scopeId) {
        return Optional.ofNullable(SCOPE_ENABLED_MAP.get(scopeId));
    }

    public static List<String> getDefaultScopeIds() {
        return DEFAULT_SCOPE_IDS;
    }

    public static List<String> getScopeIds() {
        String prefVal = HistoryTransPrefs.getValue(SCOPE_ORDER, "");
        return Arrays.asList(prefVal.split(","));
    }

    public static void setScopeIds(List<String> scopeIds) {
        String prefVal = String.join((CharSequence)",", scopeIds);
        PREFS.put(SCOPE_ORDER, prefVal);
        HistoryTransPrefs.flush();
    }

    public static Optional<Boolean> isScopeEnabled(String scopeEnabledPredKey) {
        return Optional.ofNullable(Boolean.valueOf(HistoryTransPrefs.getValue(scopeEnabledPredKey, null)));
    }

    public static void setScopeEnabled(String scopeEnabledPrefKey, boolean isEnabled) {
        PREFS.putBoolean(scopeEnabledPrefKey, isEnabled);
    }

    public static void setScopeEnabledByScopeId(String scopeId, boolean isEnabled) {
        HistoryTransPrefs.getEnabledPrefKeyByScopeId(scopeId).ifPresent(prefKey -> HistoryTransPrefs.setScopeEnabled(prefKey, isEnabled));
    }

    public static Optional<Boolean> getScopeEnabledByScopeId(String scopeId) {
        Optional<String> prefKey = HistoryTransPrefs.getEnabledPrefKeyByScopeId(scopeId);
        if (!prefKey.isPresent()) {
            return Optional.empty();
        }
        return HistoryTransPrefs.isScopeEnabled(prefKey.get());
    }

    public static Optional<RGB> getScopeColor(String scopeColorPrefKey) {
        String hex = HistoryTransPrefs.getValue(scopeColorPrefKey, null);
        return Optional.ofNullable(HistoryTransPrefs.hexToRGB(hex));
    }

    public static void setScopeColor(String scopeColorPrefKey, RGB rgb) {
        PREFS.put(scopeColorPrefKey, HistoryTransPrefs.rgbToHex(rgb));
        HistoryTransPrefs.flush();
    }

    public static Optional<RGB> getScopeColorByScopeId(String scopeId) {
        Optional<String> prefKey = HistoryTransPrefs.getColorPrefKeyByScopeId(scopeId);
        if (!prefKey.isPresent()) {
            return Optional.empty();
        }
        return HistoryTransPrefs.getScopeColor(prefKey.get());
    }

    public static void setScopeColorByScopeId(String scopeId, RGB color) {
        HistoryTransPrefs.getColorPrefKeyByScopeId(scopeId).ifPresent(prefKey -> HistoryTransPrefs.setScopeColor(prefKey, color));
    }

    public static void clearAll() {
        try {
            PREFS.clear();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getValue(String key, String defaultValue) {
        IEclipsePreferences[] prefs = new IEclipsePreferences[]{HistoryPlugin.getDefault().getPreferences(), DefaultScope.INSTANCE.getNode("com.e1c.langtool.history")};
        return Platform.getPreferencesService().get(key, defaultValue, (Preferences[])prefs);
    }

    private static void flush() {
        try {
            PREFS.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    private static RGB hexToRGB(String hex) {
        int r = Integer.valueOf(hex.substring(1, 3), 16);
        int g = Integer.valueOf(hex.substring(3, 5), 16);
        int b = Integer.valueOf(hex.substring(5, 7), 16);
        return new RGB(r, g, b);
    }

    private static String rgbToHex(RGB rgb) {
        return String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
    }

    private HistoryTransPrefs() {
        throw new IllegalStateException("Utitlity class");
    }
}

