/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.history.scope;

import com.e1c.langtool.history.scope.IQueryScope;
import com.e1c.langtool.history.scope.IQueryScopeRules;
import java.io.Serializable;

public final class QueryScope
implements IQueryScope,
Serializable {
    private static final long serialVersionUID = 5741057464188666597L;
    private final String scopeId;
    private final IQueryScopeRules rules;
    private final IQueryScope.IScopeDetails details;

    private QueryScope(Builder builder) {
        this.scopeId = builder.scopeId;
        this.rules = new QueryScopeRules(builder);
        this.details = new ScopeDetails(builder);
    }

    @Override
    public String getScopeId() {
        return this.scopeId;
    }

    @Override
    public IQueryScopeRules getRules() {
        return this.rules;
    }

    @Override
    public IQueryScope.IScopeDetails getDetails() {
        return this.details;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.scopeId == null ? 0 : this.scopeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryScope other = (QueryScope)obj;
        return !(this.scopeId == null ? other.scopeId != null : !this.scopeId.equals(other.scopeId));
    }

    public static final class Builder {
        private final String scopeId;
        private String scopeName = "";
        private String description = "";
        private IQueryScopeRules.CompareRule language = IQueryScopeRules.CompareRule.SKIP;
        private IQueryScopeRules.CompareRule storageId = IQueryScopeRules.CompareRule.SKIP;
        private IQueryScopeRules.CompareRule owner = IQueryScopeRules.CompareRule.SKIP;
        private IQueryScopeRules.CompareRule featureKey = IQueryScopeRules.CompareRule.SKIP;
        private IQueryScopeRules.CompareRule featureName = IQueryScopeRules.CompareRule.SKIP;
        private IQueryScopeRules.CompareRule value = IQueryScopeRules.CompareRule.SKIP;
        private IQueryScopeRules.CompareRule project = IQueryScopeRules.CompareRule.SKIP;
        private IQueryScopeRules.CompareRule context = IQueryScopeRules.CompareRule.SKIP;
        private IQueryScopeRules.SearchType searchType = IQueryScopeRules.SearchType.FULL_TEXT;

        public Builder(String scopeId) {
            this.scopeId = scopeId;
            if (this.scopeId == null) {
                throw new IllegalArgumentException("Scope id must not be null.");
            }
        }

        public Builder scopeName(String name) {
            this.scopeName = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder language(IQueryScopeRules.CompareRule language) {
            this.language = language;
            return this;
        }

        public Builder storageId(IQueryScopeRules.CompareRule storageId) {
            this.storageId = storageId;
            return this;
        }

        public Builder resourceId(IQueryScopeRules.CompareRule owner) {
            this.owner = owner;
            return this;
        }

        public Builder featureKey(IQueryScopeRules.CompareRule featureKey) {
            this.featureKey = featureKey;
            return this;
        }

        public Builder featureName(IQueryScopeRules.CompareRule featureName) {
            this.featureName = featureName;
            return this;
        }

        public Builder value(IQueryScopeRules.CompareRule value) {
            this.value = value;
            return this;
        }

        public Builder project(IQueryScopeRules.CompareRule project) {
            this.project = project;
            return this;
        }

        public Builder context(IQueryScopeRules.CompareRule context) {
            this.context = context;
            return this;
        }

        public Builder searchType(IQueryScopeRules.SearchType searchType) {
            this.searchType = searchType;
            return this;
        }

        public Builder language() {
            this.language = IQueryScopeRules.CompareRule.EQUAL;
            return this;
        }

        public Builder storage() {
            this.storageId = IQueryScopeRules.CompareRule.EQUAL;
            return this;
        }

        public Builder resourceId() {
            this.owner = IQueryScopeRules.CompareRule.EQUAL;
            return this;
        }

        public Builder featureKey() {
            this.featureKey = IQueryScopeRules.CompareRule.EQUAL;
            return this;
        }

        public Builder featureName() {
            this.featureName = IQueryScopeRules.CompareRule.EQUAL;
            return this;
        }

        public Builder project() {
            this.project = IQueryScopeRules.CompareRule.EQUAL;
            return this;
        }

        public Builder context() {
            this.context = IQueryScopeRules.CompareRule.EQUAL;
            return this;
        }

        public Builder value() {
            this.value = IQueryScopeRules.CompareRule.EQUAL;
            return this;
        }

        public Builder notLanguage() {
            this.language = IQueryScopeRules.CompareRule.NOT_EQUAL;
            return this;
        }

        public Builder notStorage() {
            this.storageId = IQueryScopeRules.CompareRule.NOT_EQUAL;
            return this;
        }

        public Builder notResourceId() {
            this.owner = IQueryScopeRules.CompareRule.NOT_EQUAL;
            return this;
        }

        public Builder notFeatureKey() {
            this.featureKey = IQueryScopeRules.CompareRule.NOT_EQUAL;
            return this;
        }

        public Builder notFeatureName() {
            this.featureName = IQueryScopeRules.CompareRule.NOT_EQUAL;
            return this;
        }

        public Builder notProject() {
            this.project = IQueryScopeRules.CompareRule.NOT_EQUAL;
            return this;
        }

        public Builder notContext() {
            this.context = IQueryScopeRules.CompareRule.NOT_EQUAL;
            return this;
        }

        public Builder notValue() {
            this.value = IQueryScopeRules.CompareRule.NOT_EQUAL;
            return this;
        }

        public Builder valueSearchType(IQueryScopeRules.SearchType val) {
            this.searchType = val;
            return this;
        }

        public QueryScope build() {
            return new QueryScope(this);
        }
    }

    private static final class QueryScopeRules
    implements IQueryScopeRules,
    Serializable {
        private static final long serialVersionUID = -3729366200538941444L;
        private final IQueryScopeRules.CompareRule language;
        private final IQueryScopeRules.CompareRule storageId;
        private final IQueryScopeRules.CompareRule resourceId;
        private final IQueryScopeRules.CompareRule featureKey;
        private final IQueryScopeRules.CompareRule featureName;
        private final IQueryScopeRules.CompareRule value;
        private final IQueryScopeRules.CompareRule project;
        private final IQueryScopeRules.CompareRule context;
        private final IQueryScopeRules.SearchType searchType;

        private QueryScopeRules(Builder builder) {
            this.language = builder.language;
            this.storageId = builder.storageId;
            this.resourceId = builder.owner;
            this.featureKey = builder.featureKey;
            this.featureName = builder.featureName;
            this.value = builder.value;
            this.project = builder.project;
            this.context = builder.context;
            this.searchType = builder.searchType;
        }

        @Override
        public IQueryScopeRules.SearchType getValueSearchType() {
            return this.searchType;
        }

        @Override
        public IQueryScopeRules.CompareRule getLanguage() {
            return this.language;
        }

        @Override
        public IQueryScopeRules.CompareRule getStorageId() {
            return this.storageId;
        }

        @Override
        public IQueryScopeRules.CompareRule getResourceId() {
            return this.resourceId;
        }

        @Override
        public IQueryScopeRules.CompareRule getFeatureKey() {
            return this.featureKey;
        }

        @Override
        public IQueryScopeRules.CompareRule getFeatureName() {
            return this.featureName;
        }

        @Override
        public IQueryScopeRules.CompareRule getValue() {
            return this.value;
        }

        @Override
        public IQueryScopeRules.CompareRule getContext() {
            return this.context;
        }

        @Override
        public IQueryScopeRules.CompareRule getProject() {
            return this.project;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
            result = 31 * result + (this.featureKey == null ? 0 : this.featureKey.hashCode());
            result = 31 * result + (this.featureName == null ? 0 : this.featureName.hashCode());
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            result = 31 * result + (this.resourceId == null ? 0 : this.resourceId.hashCode());
            result = 31 * result + (this.searchType == null ? 0 : this.searchType.hashCode());
            result = 31 * result + (this.storageId == null ? 0 : this.storageId.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueryScopeRules other = (QueryScopeRules)obj;
            if (this.context != other.context) {
                return false;
            }
            if (this.featureKey != other.featureKey) {
                return false;
            }
            if (this.featureName != other.featureName) {
                return false;
            }
            if (this.language != other.language) {
                return false;
            }
            if (this.project != other.project) {
                return false;
            }
            if (this.resourceId != other.resourceId) {
                return false;
            }
            if (this.searchType != other.searchType) {
                return false;
            }
            if (this.storageId != other.storageId) {
                return false;
            }
            return this.value == other.value;
        }
    }

    public static final class ScopeDetails
    implements IQueryScope.IScopeDetails,
    Serializable {
        private static final long serialVersionUID = -7547307254923274307L;
        private final String name;
        private final String description;

        private ScopeDetails(Builder builder) {
            this.name = builder.scopeName;
            this.description = builder.description;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScopeDetails other = (ScopeDetails)obj;
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

