/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.participant;

import com.e1c.langtool.builder.ITranslationBuilderParticipant;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.history.db.Context;
import com.e1c.langtool.history.db.IProjectTranslation;
import com.e1c.langtool.history.db.ProjectTranslation;
import com.e1c.langtool.internal.history.participant.ITranslationCollectingService;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;

public class TranslationCollectingService
implements ITranslationCollectingService {
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    @Inject
    private ITranslationStorageManager storageManager;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;

    @Override
    public Collection<IProjectTranslation> collect(ITranslationBuilderParticipant.IBuildContext context) {
        IProject project = context.getSource().getProject();
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
        List storageIds = this.storageSettingsManager.getReadStorageIds(project);
        return storageIds.stream().flatMap(storageId -> this.getTranslations(context, (StorageID)storageId, translatingProject).stream()).collect(Collectors.toSet());
    }

    private List<IProjectTranslation> getTranslations(ITranslationBuilderParticipant.IBuildContext context, StorageID storageId, ITranslatingProject translatingProject) {
        IProject project = translatingProject.getProject();
        ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(project, storageId);
        if (storage == null) {
            return Collections.emptyList();
        }
        List interfaceLangs = translatingProject.getInterfaceLanguages();
        List modelLangs = translatingProject.getModelLanguages();
        ArrayList<IProjectTranslation> res = new ArrayList<IProjectTranslation>();
        context.getContent().stream().filter(fv -> !StringUtils.isBlank((String)fv.getContextKey().getValue())).forEach(fv -> {
            List langs = fv.getContextKey().getFeatureSettings().isInterface() ? interfaceLangs : modelLangs;
            for (TranslateLanguage lang : langs) {
                String translatedValue = storage.getTranslation(fv, lang);
                if (StringUtils.isBlank((String)translatedValue)) continue;
                res.add(this.createTranslation((FeatureValue)fv, translatedValue, lang.getLanguageCode(), project, storage.getId()));
            }
        });
        return res;
    }

    private IProjectTranslation createTranslation(FeatureValue fv, String trans, String lang, IProject project, StorageID id) {
        return new ProjectTranslation.Builder(fv.getContextKey().getValue(), trans, lang).resourceId(fv.getContextKey().getResourceId().toString()).featureKey(fv.getContextKey().getFeatureKey().toString()).featureName(fv.getContextKey().getFeatureSettings().getName()).context(Context.valueOf((boolean)fv.getContextKey().getFeatureSettings().isInterface())).projectName(project.getName()).storageId(id.toString()).build();
    }
}

