/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.prefs;

import com.e1c.langtool.history.prefs.HistoryTransPrefs;
import java.util.List;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final String HIGHEST_SCOPE_COLOR = "#A4FF99";
    private static final String HIGHER_SCOPE_COLOR = "#D2FFCC";
    private static final String HIGH_SCOPE_COLOR = "#EFFFCC";
    private static final String PRE_HIGH_SCOPE_COLOR = "#FFFFE2";
    private static final String LOW_SCOPE_COLOR = "#FFF0F0";
    private static final String LOWER_SCOPE_COLOR = "#FFDEDE";
    private static final String LOWEST_SCOPE_COLOR = "#FFCCCC";

    public void initializeDefaultPreferences() {
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode("com.e1c.langtool.history");
        List<String> scopeIds = HistoryTransPrefs.getDefaultScopeIds();
        prefs.put("scopeOrder", String.join((CharSequence)",", scopeIds));
        this.initScopeColor(prefs);
        scopeIds.forEach(scopeId -> HistoryTransPrefs.getEnabledPrefKeyByScopeId(scopeId).ifPresent(prefKey -> prefs.putBoolean(prefKey, true)));
    }

    private void initScopeColor(IEclipsePreferences prefs) {
        prefs.put("scopeColor0", HIGHEST_SCOPE_COLOR);
        prefs.put("scopeColor1", HIGHER_SCOPE_COLOR);
        prefs.put("scopeColor2", HIGH_SCOPE_COLOR);
        prefs.put("scopeColor3", PRE_HIGH_SCOPE_COLOR);
        prefs.put("scopeColor4", LOW_SCOPE_COLOR);
        prefs.put("scopeColor5", LOWER_SCOPE_COLOR);
        prefs.put("scopeColor6", LOWEST_SCOPE_COLOR);
    }
}

