/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.provider;

import com.e1c.langtool.history.db.IProjectTranslation;
import com.e1c.langtool.history.db.IProjectTranslationStorage;
import com.e1c.langtool.history.db.pagination.IPage;
import com.e1c.langtool.history.db.pagination.IPageLoader;
import com.e1c.langtool.history.db.pagination.IPageable;
import com.e1c.langtool.history.db.pagination.PageIterator;
import com.e1c.langtool.history.db.pagination.PageRequest;
import com.e1c.langtool.history.db.query.Criteries;
import com.e1c.langtool.history.db.query.ExpressionBuilder;
import com.e1c.langtool.history.db.query.IExpression;
import com.e1c.langtool.history.prefs.HistoryTransPrefs;
import com.e1c.langtool.history.provider.IHistoryTranslationProvider;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class BaseTranslationProvider {
    private IProjectTranslationStorage projectTranslationStorage;

    public BaseTranslationProvider(IProjectTranslationStorage storage) {
        this.projectTranslationStorage = storage;
    }

    public List<IHistoryTranslationProvider.ITranslationResult> translate(IExpression baseQuery, IExpression searchQuery) {
        List groups = this.projectTranslationStorage.getGroupedTranslations(searchQuery);
        return groups.stream().map(group -> {
            IExpression q = ExpressionBuilder.and((IExpression)Criteries.translationEqual((String)group.getValue()), (IExpression)baseQuery);
            return new TranslationResult(this.projectTranslationStorage, q, group.getCount(), group.getValue());
        }).collect(Collectors.toList());
    }

    public int getMaxResultsNumber() {
        return HistoryTransPrefs.getMaxTranslations();
    }

    private static class PageLoader
    implements IPageLoader<IProjectTranslation> {
        private final IProjectTranslationStorage translationService;
        private final IExpression query;

        public PageLoader(IProjectTranslationStorage translationService, IExpression query) {
            this.translationService = translationService;
            this.query = query;
        }

        public IPage<IProjectTranslation> load(IPageable pageable) {
            return this.translationService.getTranslations(this.query, pageable);
        }
    }

    public static class TranslationResult
    implements IHistoryTranslationProvider.ITranslationResult {
        private static final int DEFAULT_PAGE_SIZE = 5;
        private IProjectTranslationStorage translationService;
        private final IExpression query;
        private final long totalSize;
        private final String value;

        public TranslationResult(IProjectTranslationStorage translationService, IExpression query, long totalSize, String value) {
            this.translationService = translationService;
            this.query = query;
            this.totalSize = totalSize;
            this.value = value;
        }

        @Override
        public Iterator<IPage<IProjectTranslation>> iterator(int pageSize) {
            return new PageIterator((IPageLoader)new PageLoader(this.translationService, this.query), (IPageable)PageRequest.first((int)pageSize), this.totalSize);
        }

        @Override
        public Iterator<IPage<IProjectTranslation>> iterator() {
            return new PageIterator((IPageLoader)new PageLoader(this.translationService, this.query), (IPageable)PageRequest.first((int)5), this.totalSize);
        }

        @Override
        public long totalCount() {
            return this.totalSize;
        }

        @Override
        public String value() {
            return this.value;
        }
    }
}

