/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.scope;

import com.e1c.langtool.history.db.Context;
import com.e1c.langtool.history.db.query.Criteries;
import com.e1c.langtool.history.db.query.ExpressionBuilder;
import com.e1c.langtool.history.db.query.ICriteria;
import com.e1c.langtool.history.db.query.IExpression;
import com.e1c.langtool.history.scope.IQueryScope;
import com.e1c.langtool.history.scope.IQueryScopeRules;
import com.e1c.langtool.history.scope.IScopedQueryAdapter;
import com.e1c.langtool.internal.history.query.IProjectTranslatingQuery;
import java.util.function.BiConsumer;

public class ScopedQueryAdapter
implements IScopedQueryAdapter {
    @Override
    public boolean isAdaptable(IProjectTranslatingQuery query, IQueryScope scope) {
        IQueryScopeRules rules = scope.getRules();
        if (this.checkRule(rules.getValue()) && query.getValue() == null) {
            return false;
        }
        if (this.checkRule(rules.getProject()) && query.getProjectPath() == null) {
            return false;
        }
        if (this.checkRule(rules.getLanguage()) && query.getLanguage() == null) {
            return false;
        }
        if (this.checkRule(rules.getContext()) && query.getContext() == null) {
            return false;
        }
        if (this.checkRule(rules.getFeatureKey()) && query.getFeatureKey() == null) {
            return false;
        }
        if (this.checkRule(rules.getFeatureName()) && query.getFeatureName() == null) {
            return false;
        }
        if (this.checkRule(rules.getStorageId()) && query.getStorageId() == null) {
            return false;
        }
        return !this.checkRule(rules.getResourceId()) || query.getOwner() != null;
    }

    @Override
    public IExpression adapt(IProjectTranslatingQuery query, IQueryScope scope) {
        ICriteria criteria2;
        ExpressionBuilder builder = ExpressionBuilder.where((IExpression)Criteries.featureKeyLike((String)"%%"));
        BiConsumer<IQueryScopeRules.CompareRule, ICriteria> scopeConsumer = (compareRule, criteria) -> {
            if (compareRule == IQueryScopeRules.CompareRule.EQUAL) {
                builder.and((IExpression)criteria);
            } else if (compareRule == IQueryScopeRules.CompareRule.NOT_EQUAL) {
                builder.andNot((IExpression)criteria);
            }
        };
        IQueryScopeRules rules = scope.getRules();
        if (query.getProjectPath() != null) {
            criteria2 = Criteries.projectEqual((String)query.getProjectPath());
            scopeConsumer.accept(rules.getProject(), criteria2);
        }
        if (query.getLanguage() != null) {
            criteria2 = Criteries.langEqual((String)query.getLanguage());
            scopeConsumer.accept(rules.getLanguage(), criteria2);
        }
        if (query.getContext() != null) {
            Context context = query.getContext() == IProjectTranslatingQuery.ContextType.INTERFACE ? Context.INTERFACE : Context.MODEL;
            ICriteria criteria3 = Criteries.contextEqual((Context)context);
            scopeConsumer.accept(rules.getContext(), criteria3);
        }
        if (query.getFeatureKey() != null) {
            criteria2 = Criteries.featureKeyEqual((String)query.getFeatureKey());
            scopeConsumer.accept(rules.getFeatureKey(), criteria2);
        }
        if (query.getFeatureName() != null) {
            criteria2 = Criteries.featureNameEqual((String)query.getFeatureName());
            scopeConsumer.accept(rules.getFeatureName(), criteria2);
        }
        if (query.getStorageId() != null) {
            criteria2 = Criteries.storageIdEqual((String)query.getStorageId());
            scopeConsumer.accept(rules.getStorageId(), criteria2);
        }
        if (query.getOwner() != null) {
            criteria2 = Criteries.ownerEqual((String)query.getOwner());
            scopeConsumer.accept(rules.getResourceId(), criteria2);
        }
        return builder.build();
    }

    private boolean checkRule(IQueryScopeRules.CompareRule rule) {
        return rule != IQueryScopeRules.CompareRule.SKIP;
    }
}

