/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.scope;

import com.e1c.langtool.history.db.IProjectTranslation;
import com.e1c.langtool.history.db.IProjectTranslationStorage;
import com.e1c.langtool.history.db.pagination.IPage;
import com.e1c.langtool.history.db.query.Criteries;
import com.e1c.langtool.history.db.query.ExpressionBuilder;
import com.e1c.langtool.history.db.query.ICriteria;
import com.e1c.langtool.history.db.query.IExpression;
import com.e1c.langtool.history.prefs.HistoryTransPrefs;
import com.e1c.langtool.history.provider.IHistoryTranslationProvider;
import com.e1c.langtool.history.provider.IScopedTranslationProvider;
import com.e1c.langtool.history.scope.DefaultQueryScopes;
import com.e1c.langtool.history.scope.IQueryScope;
import com.e1c.langtool.history.scope.IQueryScopeRules;
import com.e1c.langtool.history.scope.IScopedQueryAdapter;
import com.e1c.langtool.internal.history.provider.BaseTranslationProvider;
import com.e1c.langtool.internal.history.query.ProjectTranslatingQuery;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ScopedTranslationProvider
extends BaseTranslationProvider
implements IScopedTranslationProvider {
    @Inject
    private IScopedQueryAdapter queryAdapter;

    @Inject
    public ScopedTranslationProvider(IProjectTranslationStorage service) {
        super(service);
    }

    @Override
    public List<IScopedTranslationProvider.IScopedTranslationResult> translate(IContextTranslationQuery contextQuery) {
        ProjectTranslatingQuery query = ProjectTranslatingQuery.fromContextQuery(contextQuery);
        ArrayList<IScopedTranslationProvider.IScopedTranslationResult> result = new ArrayList<IScopedTranslationProvider.IScopedTranslationResult>();
        int maxResultsNumber = this.getMaxResultsNumber();
        Map<String, IQueryScope> defaultScopes = DefaultQueryScopes.getDefaultScopeMap();
        for (String scopeId : HistoryTransPrefs.getScopeIds()) {
            IQueryScope scope = defaultScopes.get(scopeId);
            boolean isEnabled = false;
            if (scope != null) {
                isEnabled = HistoryTransPrefs.getScopeEnabledByScopeId(scope.getScopeId()).orElse(true);
            }
            if (scope != null && isEnabled && this.queryAdapter.isAdaptable(query, scope)) {
                IExpression baseQuery = this.queryAdapter.adapt(query, scope);
                IExpression searchQuery = this.createSearchQuery(query.getValue(), baseQuery, scope);
                List<IHistoryTranslationProvider.ITranslationResult> subRes = this.translate(baseQuery, searchQuery);
                this.updateResult(result, subRes, scope.getScopeId());
            }
            if (result.size() >= maxResultsNumber) break;
        }
        return result;
    }

    private IExpression createSearchQuery(String value, IExpression baseQuery, IQueryScope scope) {
        IExpression searchQuery;
        if (scope.getRules().getValueSearchType() == IQueryScopeRules.SearchType.EQUAL) {
            ICriteria criteria = Criteries.valueEqual((String)value);
            searchQuery = ExpressionBuilder.and((IExpression)criteria, (IExpression)baseQuery);
        } else if (scope.getRules().getValueSearchType() == IQueryScopeRules.SearchType.FULL_TEXT) {
            ICriteria criteria = Criteries.valueLike((String)value);
            searchQuery = ExpressionBuilder.and((IExpression)criteria, (IExpression)baseQuery);
        } else if (scope.getRules().getValueSearchType() == IQueryScopeRules.SearchType.CONTEXT_INDEPENDENT_EQUAL) {
            ICriteria criteria = Criteries.valueLikeInAnyCase((String)value);
            searchQuery = ExpressionBuilder.and((IExpression)criteria, (IExpression)baseQuery);
        } else {
            ICriteria criteria = Criteries.valueEqual((String)value);
            searchQuery = ExpressionBuilder.where((IExpression)baseQuery).andNot((IExpression)criteria).build();
        }
        return searchQuery;
    }

    private void updateResult(List<IScopedTranslationProvider.IScopedTranslationResult> result, List<IHistoryTranslationProvider.ITranslationResult> subResult, String scope) {
        if (!result.isEmpty()) {
            IHistoryTranslationProvider.ITranslationResult lastResult = (IHistoryTranslationProvider.ITranslationResult)Iterables.getLast(result);
            subResult = subResult.stream().filter(transRes -> !transRes.value().equals(lastResult.value()) || transRes.totalCount() != lastResult.totalCount()).collect(Collectors.toList());
        }
        subResult.forEach(transRes -> {
            boolean bl = result.add(new ScopedTranslationResult((IHistoryTranslationProvider.ITranslationResult)transRes, scope));
        });
    }

    public static final class EnabledQueryScope {
        private final IQueryScope scope;
        private final boolean enabled;

        public EnabledQueryScope(IQueryScope scope, boolean enabled) {
            this.scope = scope;
            this.enabled = enabled;
        }

        public IQueryScope getScope() {
            return this.scope;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.enabled ? 1231 : 1237);
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnabledQueryScope other = (EnabledQueryScope)obj;
            if (this.enabled != other.enabled) {
                return false;
            }
            return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
        }
    }

    private static class ScopedTranslationResult
    implements IScopedTranslationProvider.IScopedTranslationResult {
        private final IHistoryTranslationProvider.ITranslationResult result;
        private final String scope;

        public ScopedTranslationResult(IHistoryTranslationProvider.ITranslationResult result, String scope) {
            this.result = result;
            this.scope = scope;
        }

        @Override
        public long totalCount() {
            return this.result.totalCount();
        }

        @Override
        public String value() {
            return this.result.value();
        }

        @Override
        public Iterator<IPage<IProjectTranslation>> iterator() {
            return this.result.iterator();
        }

        @Override
        public Iterator<IPage<IProjectTranslation>> iterator(int pageSize) {
            return this.result.iterator(pageSize);
        }

        @Override
        public String getScopeId() {
            return this.scope;
        }
    }
}

