/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bp.scheme;

import com._1c.g5.v8.dt.bp.scheme.model.Case;
import com._1c.g5.v8.dt.bp.scheme.model.EventHandler;
import com._1c.g5.v8.dt.bp.scheme.model.GraphicalScheme;
import com._1c.g5.v8.dt.bp.scheme.model.GraphicalSchemeActivity;
import com._1c.g5.v8.dt.bp.scheme.model.GraphicalSchemeCondition;
import com._1c.g5.v8.dt.bp.scheme.model.GraphicalSchemeConnection;
import com._1c.g5.v8.dt.bp.scheme.model.GraphicalSchemeDecoration;
import com._1c.g5.v8.dt.bp.scheme.model.GraphicalSchemeFigure;
import com._1c.g5.v8.dt.bp.scheme.model.GraphicalSchemeItem;
import com._1c.g5.v8.dt.bp.scheme.model.GraphicalSchemeSubProcess;
import com._1c.g5.v8.dt.bp.scheme.model.GraphicalSchemeSwitch;
import com._1c.g5.v8.dt.bp.scheme.model.ModelPackage;
import com.e1c.langtool.IBasicProcessor;
import java.util.ArrayDeque;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public abstract class SchemeProcessor
implements IBasicProcessor {
    private final Collection<EObject> allObjects = new ArrayDeque<EObject>();
    protected final EObject object;
    private boolean processChildObjects = true;
    protected IProgressMonitor monitor;

    public SchemeProcessor(EObject object) {
        this.object = object;
    }

    public boolean isCanceled() {
        return this.monitor == null ? false : this.monitor.isCanceled();
    }

    public boolean isProcessChildObjects() {
        return this.processChildObjects;
    }

    public void setProcessChildObjects(boolean processChildObjects) {
        this.processChildObjects = processChildObjects;
    }

    public void process(IProgressMonitor monitor) {
        this.monitor = monitor;
        if (SchemeProcessor.isSupported(this.object)) {
            this.allObjects.add(this.object);
        }
        this.doProcessInternal(this.allObjects);
    }

    protected static boolean isSupported(EObject obj) {
        EPackage objectPackage = obj.eClass().getEPackage();
        return objectPackage.equals(ModelPackage.eINSTANCE);
    }

    protected abstract <T extends EObject> void doProcess(T var1, Class<T> var2);

    private void doProcessInternal(Collection<? extends EObject> objects) {
        for (EObject eObject : objects) {
            if (this.isCanceled()) {
                return;
            }
            this.doProcessInternal(eObject);
        }
    }

    private void doProcessInternal(EObject obj) {
        if (this.isCanceled()) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof GraphicalScheme) {
            this.doProcessInternal((GraphicalScheme)obj);
        } else if (obj instanceof GraphicalSchemeConnection) {
            this.doProcessInternal((GraphicalSchemeConnection)obj);
        } else if (obj instanceof GraphicalSchemeActivity) {
            this.doProcessInternal((GraphicalSchemeActivity)obj);
        } else if (obj instanceof GraphicalSchemeCondition) {
            this.doProcessInternal((GraphicalSchemeCondition)obj);
        } else if (obj instanceof GraphicalSchemeDecoration) {
            this.doProcessInternal((GraphicalSchemeDecoration)obj);
        } else if (obj instanceof GraphicalSchemeSubProcess) {
            this.doProcessInternal((GraphicalSchemeSubProcess)obj);
        } else if (obj instanceof GraphicalSchemeSwitch) {
            this.doProcessInternal((GraphicalSchemeSwitch)obj);
        } else if (obj instanceof GraphicalSchemeFigure) {
            this.doProcessInternal((GraphicalSchemeFigure)obj);
        } else if (obj instanceof GraphicalSchemeItem) {
            this.doProcessInternal((GraphicalSchemeItem)obj);
        } else if (obj instanceof EventHandler) {
            this.doProcessInternal((EventHandler)obj);
        } else if (obj instanceof Case) {
            this.doProcessInternal((Case)obj);
        }
    }

    private void doProcessInternal(GraphicalScheme obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, GraphicalScheme.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getItems());
    }

    private void doProcessInternal(GraphicalSchemeItem obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, GraphicalSchemeItem.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getEventHandlers());
    }

    private void doProcessInternal(GraphicalSchemeConnection obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, GraphicalSchemeConnection.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getEventHandlers());
    }

    private void doProcessInternal(GraphicalSchemeFigure obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, GraphicalSchemeFigure.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getEventHandlers());
    }

    private void doProcessInternal(GraphicalSchemeActivity obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, GraphicalSchemeActivity.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getEventHandlers());
    }

    private void doProcessInternal(GraphicalSchemeCondition obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, GraphicalSchemeCondition.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getEventHandlers());
    }

    private void doProcessInternal(GraphicalSchemeDecoration obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, GraphicalSchemeDecoration.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getEventHandlers());
    }

    private void doProcessInternal(GraphicalSchemeSubProcess obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, GraphicalSchemeSubProcess.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getEventHandlers());
    }

    private void doProcessInternal(GraphicalSchemeSwitch obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, GraphicalSchemeSwitch.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getEventHandlers());
        this.doProcessInternal((Collection<? extends EObject>)obj.getCases());
    }

    private void doProcessInternal(EventHandler obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, EventHandler.class);
    }

    private void doProcessInternal(Case obj) {
        this.doProcess(obj, Case.class);
    }
}

