/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.external.sync;

import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IExternalObjectProject;
import com._1c.g5.v8.dt.core.platform.IExternalObjectProjectManager;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.metadata.mdclass.ExternalDataProcessor;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassFactory;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.platform.version.IRuntimeVersionSupport;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.v8.dt.external.ITranslatedExternalObjectProject;
import com.e1c.langtool.v8.dt.external.ITranslatingExternalObjectProject;
import com.e1c.langtool.v8.dt.external.translator.ExternalProjectTranslationProvider;
import com.e1c.langtool.v8.dt.internal.external.ExtPlugin;
import com.e1c.langtool.v8.dt.platform.ITranslateV8Project;
import com.e1c.langtool.v8.dt.platform.ITranslatedConfigurationProject;
import com.e1c.langtool.v8.dt.platform.ITranslatingConfigurationProject;
import com.e1c.langtool.v8.dt.sync.AbstractBmSyncSession;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.time.Duration;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ExternalObjectSyncSession
extends AbstractBmSyncSession {
    @Inject
    private IExternalObjectProjectManager externalObjectProjectManager;
    @Inject
    private IRuntimeVersionSupport runtimeVersionSupport;
    private final Object lock = new Object();
    private final ITranslatedExternalObjectProject translatedExternalObject;
    private IProjectTranslationProvider translationProvider;
    private Object sourceConfigHandle;
    private Object targetSourceConfigHandle;

    public ExternalObjectSyncSession(ITranslatedProject translatedProject) {
        super(translatedProject);
        Assert.isLegal((boolean)(translatedProject instanceof ITranslatedExternalObjectProject));
        this.translatedExternalObject = (ITranslatedExternalObjectProject)translatedProject;
    }

    public IStatus createProject(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!this.translatedExternalObject.getSourceProject().isTranslating()) {
            return Status.CANCEL_STATUS;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        IProject project = this.translatedExternalObject.getProject();
        if (project == null || !project.exists()) {
            IV8Project v8SourceProject = ((ITranslateV8Project)this.translatedExternalObject.getSourceProject()).getV8Project();
            if (!(v8SourceProject instanceof IExternalObjectProject) || ((IExternalObjectProject)v8SourceProject).getExternalObjects().isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            try {
                MdObject source = (MdObject)((IExternalObjectProject)v8SourceProject).getExternalObjects().iterator().next();
                Object mdObject = source instanceof ExternalDataProcessor ? MdClassFactory.eINSTANCE.createExternalDataProcessor() : MdClassFactory.eINSTANCE.createExternalReport();
                mdObject.setName(source.getName());
                mdObject.setUuid(source.getUuid());
                ITranslatingProject sourceProject = this.translatedExternalObject.getSourceProject();
                Version version = this.runtimeVersionSupport.getRuntimeVersion(sourceProject.getProject());
                IProject baseProject = null;
                if (this.translatedExternalObject.getTranslatedConfigurationProject() != null) {
                    baseProject = this.translatedExternalObject.getTranslatedConfigurationProject().getProject();
                }
                project = this.externalObjectProjectManager.create(this.translatedExternalObject.getProjectName(), version, (MdObject)mdObject, baseProject, (IProgressMonitor)subMonitor.newChild(1));
                IExternalObjectProject externalProject = (IExternalObjectProject)this.translatedExternalObject.getV8Project();
                this.externalObjectProjectManager.setScriptVariant(externalProject, this.translatedExternalObject.getScriptVariant(), (IProgressMonitor)subMonitor.newChild(1));
                this.externalObjectProjectManager.setLanguages(externalProject, EcoreUtil.copyAll((Collection)this.translatedExternalObject.getLanguages()), (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (Exception e) {
                return ExtPlugin.createErrorStatus(e.getMessage(), e);
            }
        }
        if (!project.isOpen()) {
            try {
                project.open((IProgressMonitor)subMonitor);
            }
            catch (Exception e) {
                return ExtPlugin.createErrorStatus(e.getMessage(), e);
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProjectTranslationProvider getTranslationProvider() {
        IProjectTranslationProvider local = this.translationProvider;
        if (local == null) {
            Object object = this.lock;
            synchronized (object) {
                local = this.translationProvider;
                if (local == null) {
                    local = this.translationProvider = ExternalProjectTranslationProvider.create(this.translatedExternalObject);
                }
            }
        }
        return this.translationProvider;
    }

    public void beginSyncOperation() {
        super.beginSyncOperation();
        this.beginSourceConfigProjectOperation();
        this.beginTargetSourceConfigProjectOperation();
    }

    public void endSyncOperation() {
        super.endSyncOperation();
        this.endSourceConfigProjectOperation();
        this.endTargetSourceConfigProjectOperation();
    }

    private void beginSourceConfigProjectOperation() {
        ITranslatingExternalObjectProject project;
        ITranslatingConfigurationProject configProject;
        ITranslatingProject sourceProject = this.translatedExternalObject.getSourceProject();
        if (sourceProject instanceof ITranslatingExternalObjectProject && (configProject = (project = (ITranslatingExternalObjectProject)sourceProject).getTranslatingConfigurationProject()) != null && configProject.getProject() != null && configProject.getProject().isAccessible()) {
            IProject sourceConfigProject = configProject.getProject();
            this.waitUntilStarted(sourceConfigProject, Duration.ofMinutes(5L));
            IDtProject sourceDtProject = this.dtProjectManager.getDtProject(sourceConfigProject);
            this.sourceConfigHandle = this.workspaceOrchestrator.beginBackgroundOperation("synchronize-source-config-Project", (Collection)Lists.newArrayList((Object[])new IDtProject[]{sourceDtProject}), ProjectPipelineJob.BUILD);
        }
    }

    private void endSourceConfigProjectOperation() {
        if (this.sourceConfigHandle == null) {
            return;
        }
        try {
            this.workspaceOrchestrator.endOperation(this.sourceConfigHandle);
        }
        catch (Exception e) {
            ExtPlugin.logError(e);
        }
    }

    private void beginTargetSourceConfigProjectOperation() {
        ITranslatedConfigurationProject translatedSourceProject = this.translatedExternalObject.getTranslatedConfigurationProject();
        if (translatedSourceProject != null && translatedSourceProject.getProject() != null && translatedSourceProject.getProject().isAccessible()) {
            IProject sourceConfigProject = translatedSourceProject.getProject();
            this.waitUntilStarted(sourceConfigProject, Duration.ofMinutes(5L));
            IDtProject sourceDtProject = this.dtProjectManager.getDtProject(sourceConfigProject);
            this.targetSourceConfigHandle = this.workspaceOrchestrator.beginBackgroundOperation("synchronize-target-source-config-Project", (Collection)Lists.newArrayList((Object[])new IDtProject[]{sourceDtProject}), ProjectPipelineJob.BUILD);
        }
    }

    private void endTargetSourceConfigProjectOperation() {
        if (this.targetSourceConfigHandle == null) {
            return;
        }
        try {
            this.workspaceOrchestrator.endOperation(this.targetSourceConfigHandle);
        }
        catch (Exception e) {
            ExtPlugin.logError(e);
        }
    }
}

