/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.commands;

import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.common.ui.part.EObjectEditorInput;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupport;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupportProvider;
import com._1c.g5.v8.dt.core.filesystem.IQualifiedNameFilePathConverter;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.lcore.ui.editor.PathXtextReadonlyEditorInput;
import com._1c.g5.v8.dt.ui.editor.IGotoSelection;
import com.e1c.g5.dt.core.api.naming.INamingService;
import com.e1c.g5.dt.core.api.platform.BmOperationContext;
import com.e1c.langtool.platform.ITranslateProject;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatedProjectManager;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.v8.dt.bsl.ModuleCachedLoader;
import com.e1c.langtool.v8.dt.bsl.translator.ModuleTextEditor;
import com.e1c.langtool.v8.dt.extension.ITranslatedExtensionProject;
import com.e1c.langtool.v8.dt.extension.translator.ExtensionProjectTranslationProvider;
import com.e1c.langtool.v8.dt.external.ITranslatedExternalObjectProject;
import com.e1c.langtool.v8.dt.external.translator.ExternalProjectTranslationProvider;
import com.e1c.langtool.v8.dt.internal.bsl.ui.BslPlugin;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.Messages;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.SideBySideEditor;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.SideBySideEditorInput;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.SideBySideEditorInputExtension;
import com.e1c.langtool.v8.dt.platform.ITranslatedV8Project;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.V8ObjectID;
import com.e1c.langtool.v8.dt.translator.V8ObjectIdProvider;
import com.google.inject.Inject;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public abstract class CompareBslTranslationAbstractHandler
extends AbstractHandler {
    @Inject
    private V8ObjectIdProvider objectIdProvider;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private ITranslatedProjectManager translatedProjectManager;
    @Inject
    protected IQualifiedNameFilePathConverter qualifiedNameFilePathConverter;
    @Inject
    private IProjectFileSystemSupportProvider projectFileSystemSupportProvider;
    @Inject
    private IBmModelManager bmModelManager;
    @Inject
    private INamingService namingService;
    @Inject
    private ModuleCachedLoader moduleCachedLoader;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Module module;
        IEditorPart activeEditor;
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        this.doPreprocessEvent(event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object item : structuredSelection) {
                this.doProcessItem(workbenchWindow, item);
            }
        } else if (selection instanceof ITextSelection && (activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event)) != null && (module = CompareBslTranslationAbstractHandler.getEditorBslModule(activeEditor)) != null) {
            this.doProcessItem(workbenchWindow, module);
        }
        return null;
    }

    protected abstract void doPreprocessEvent(ExecutionEvent var1);

    protected abstract void doProcessItem(IWorkbenchWindow var1, Object var2);

    protected void openSideBySideEditor(IWorkbenchWindow workbenchWindow, EObject object, ISelection selection) {
        IEditorInput input;
        ITranslatedProject translatedProject;
        V8ObjectID selectedModuleId = this.objectIdProvider.getId(object);
        if (selectedModuleId == null) {
            BslPlugin.logError("Failed to determine object id for object " + String.valueOf(object));
            return;
        }
        IProject project = this.resourceLookup.getProject(object);
        HashSet<ITranslateProject> linkedProjects = new HashSet<ITranslateProject>();
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
        if (translatingProject != null && translatingProject.isTranslating()) {
            linkedProjects.addAll(translatingProject.getTranslatedProjects());
        }
        if ((translatedProject = this.translatedProjectManager.getProject(project)) != null && translatedProject.isTranslated()) {
            linkedProjects.add((ITranslateProject)translatedProject.getSourceProject());
        }
        ITranslateProject counterpartProject = null;
        if (linkedProjects.isEmpty()) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)Messages.SideBySideEditor_NoLinkedProjectsFound_Title, (String)MessageFormat.format(Messages.SideBySideEditor_NoLinkedProjectsFound_Message, project.getName()));
        } else {
            counterpartProject = linkedProjects.size() == 1 ? (ITranslateProject)linkedProjects.iterator().next() : CompareBslTranslationAbstractHandler.selectProject(workbenchWindow.getShell(), linkedProjects);
        }
        if (counterpartProject != null && (input = this.createEditorInput(translatingProject, object, selectedModuleId, counterpartProject)) != null) {
            try {
                boolean isCurrentLeft = translatingProject != null && translatingProject.isTranslating();
                IEditorPart part = workbenchWindow.getActivePage().openEditor(input, "com.e1c.langtool.v8.dt.bsl.ui.sidebysideeditor.SideBySideBslEditor", true, 3);
                if (part instanceof SideBySideEditor && selection != null) {
                    IEditorPart current;
                    SideBySideEditor editor = (SideBySideEditor)part;
                    IEditorPart iEditorPart = current = isCurrentLeft ? editor.getLeftEditor() : editor.getRightEditor();
                    if (current instanceof IGotoSelection) {
                        ((IGotoSelection)current).gotoSelection(selection);
                    } else if (current instanceof AbstractTextEditor) {
                        ((AbstractTextEditor)current).getSelectionProvider().setSelection(selection);
                    }
                }
            }
            catch (PartInitException e) {
                BslPlugin.logError(e);
            }
        }
    }

    private IEditorInput createEditorInput(ITranslatingProject translatingProject, final EObject object, V8ObjectID selectedModuleId, final ITranslateProject counterpartProject) {
        EObject slaveObject;
        EObject masterObject;
        EObject counterpartObject = null;
        if (counterpartProject.getProject() != null && counterpartProject.getProject().isAccessible()) {
            counterpartObject = this.objectIdProvider.getObjectOrProxy(counterpartProject.getProject(), selectedModuleId);
        }
        if (counterpartObject == null && translatingProject != null && translatingProject.isTranslating() && counterpartProject instanceof ITranslatedV8Project) {
            URI uri = EcoreUtil.getURI((EObject)object);
            final URI newUri = uri.trimFragment().trimSegments(1).appendSegment(uri.trimFileExtension().segment(uri.segmentCount() - 1) + "_translated").appendFileExtension(uri.fileExtension());
            IEditorInput left = this.getBslEditorInput(object);
            IStorage storage = new IStorage(){
                private InputStream in;
                private IPath fullPath;

                public <T> T getAdapter(Class<T> adapter) {
                    return null;
                }

                public boolean isReadOnly() {
                    return true;
                }

                public String getName() {
                    return MessageFormat.format(Messages.CompareBslTranslationAbstractHandler__N__Translated_preview, counterpartProject.getProject().getName());
                }

                public IPath getFullPath() {
                    if (this.fullPath == null) {
                        this.fullPath = new Path(newUri.toPlatformString(true));
                    }
                    return this.fullPath;
                }

                public InputStream getContents() throws CoreException {
                    if (this.in == null) {
                        this.in = this.createInputStream();
                    }
                    return this.in;
                }

                private InputStream createInputStream() {
                    IFile file = CompareBslTranslationAbstractHandler.this.resourceLookup.getPlatformResource(object);
                    Module module = CompareBslTranslationAbstractHandler.this.moduleCachedLoader.getModule(file, CancelIndicator.NullImpl);
                    IDtProject project = CompareBslTranslationAbstractHandler.this.resourceLookup.getDtProject((EObject)module);
                    String translated = (String)CompareBslTranslationAbstractHandler.this.bmModelManager.executeReadOnlyTask(project, transaction -> {
                        Object translationProvider = null;
                        translationProvider = counterpartProject instanceof ITranslatedExtensionProject ? ExtensionProjectTranslationProvider.create((ITranslatedV8Project)((ITranslatedV8Project)counterpartProject)) : (counterpartProject instanceof ITranslatedExternalObjectProject ? ExternalProjectTranslationProvider.create((ITranslatedV8Project)((ITranslatedV8Project)counterpartProject)) : ProjectTranslationProvider.create((ITranslatedV8Project)((ITranslatedV8Project)counterpartProject)));
                        BmOperationContext context = new BmOperationContext(CompareBslTranslationAbstractHandler.this.namingService, CompareBslTranslationAbstractHandler.this.bmModelManager, transaction);
                        ModuleTextEditor editor = new ModuleTextEditor(module, (IProjectTranslationProvider)translationProvider, context);
                        editor.process((IProgressMonitor)new NullProgressMonitor());
                        String result = editor.getProcessedText();
                        translationProvider.dispose();
                        return result;
                    });
                    return new LazyStringInputStream(translated, StandardCharsets.UTF_8);
                }
            };
            PathXtextReadonlyEditorInput right = new PathXtextReadonlyEditorInput(storage);
            return new SideBySideEditorInputExtension(left, (IEditorInput)right);
        }
        if (counterpartObject == null) {
            return null;
        }
        if (translatingProject != null && translatingProject.isTranslating()) {
            masterObject = object;
            slaveObject = counterpartObject;
        } else {
            masterObject = counterpartObject;
            slaveObject = object;
        }
        SideBySideEditorInput input = new SideBySideEditorInput(masterObject, slaveObject);
        return input;
    }

    private IEditorInput getBslEditorInput(EObject object) {
        IProjectFileSystemSupport projectFileSystemSupport;
        IFile file;
        IProject project = this.resourceLookup.getProject(object);
        if (project != null && (file = (projectFileSystemSupport = this.projectFileSystemSupportProvider.getProjectFileSystemSupport(project)).getFile(object)) != null) {
            return new FileEditorInput(file);
        }
        return new EObjectEditorInput(object, null);
    }

    private static ITranslateProject selectProject(Shell shell, Set<ITranslateProject> projects) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ITranslateProject) {
                    ITranslateProject project = (ITranslateProject)element;
                    return project.getProject().getName();
                }
                return "";
            }
        });
        dialog.setElements(projects.toArray());
        dialog.setTitle(Messages.SideBySideEditor_ProjectSelectionDialog_Title);
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (ITranslateProject)dialog.getFirstResult();
        }
        return null;
    }

    private static XtextEditor getEditor(IWorkbenchPart part) {
        String extension;
        IResource resource;
        XtextEditor xtextEditor = part instanceof XtextEditor ? (XtextEditor)part : (XtextEditor)part.getAdapter(XtextEditor.class);
        if (xtextEditor != null && (resource = (IResource)xtextEditor.getEditorInput().getAdapter(IResource.class)) != null && (extension = resource.getFileExtension()) != null && "bsl".equalsIgnoreCase(extension)) {
            return xtextEditor;
        }
        return null;
    }

    private static Module getEditorBslModule(IEditorPart editor) {
        XtextEditor xtextEditor = CompareBslTranslationAbstractHandler.getEditor((IWorkbenchPart)editor);
        if (xtextEditor != null) {
            return (Module)xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<EObject, XtextResource>(){

                public EObject exec(XtextResource resource) throws Exception {
                    if (resource != null && !resource.getContents().isEmpty()) {
                        return (EObject)resource.getContents().get(0);
                    }
                    return null;
                }
            });
        }
        return null;
    }

    static /* synthetic */ INamingService access$0(CompareBslTranslationAbstractHandler compareBslTranslationAbstractHandler) {
        return compareBslTranslationAbstractHandler.namingService;
    }

    static /* synthetic */ IBmModelManager access$1(CompareBslTranslationAbstractHandler compareBslTranslationAbstractHandler) {
        return compareBslTranslationAbstractHandler.bmModelManager;
    }
}

