/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.editorupdater;

import com._1c.g5.v8.dt.bsl.ui.editor.BslXtextDocumentProvider;
import com.e1c.langtool.v8.dt.bsl.i18n.cache.BslContentCacheManager;
import com.e1c.langtool.v8.dt.bsl.i18n.cache.IBslCacheInvalidationListener;
import com.e1c.langtool.v8.dt.internal.bsl.ui.BslPlugin;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class EditorUpdateManager
implements IBslCacheInvalidationListener,
IWorkbenchListener {
    private static final int SCHEDULE_DELAY = 100;
    private static final boolean DEBUG = BslPlugin.getDefault().isDebugging();
    private static volatile EditorUpdateManager INSTANCE = null;
    private final ConcurrentMap<IFile, Integer> openedFiles = new ConcurrentHashMap<IFile, Integer>();
    private final ConcurrentMap<BslXtextDocumentProvider, Set<IFile>> partToFileMapping = new ConcurrentHashMap<BslXtextDocumentProvider, Set<IFile>>();
    private final NavigableSet<IFile> fileUpdateSet = new ConcurrentSkipListSet<IFile>(Comparator.comparing(file -> file.getFullPath().toPortableString()));
    private final BslFileTouchJob fileTouchJob = new BslFileTouchJob(this.fileUpdateSet);
    private final BslContentCacheManager bslContentCacheManager = (BslContentCacheManager)BslPlugin.getDefault().getInjector().getInstance(BslContentCacheManager.class);

    public EditorUpdateManager() {
        this.bslContentCacheManager.addListener((IBslCacheInvalidationListener)this);
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWorkbenchListener((IWorkbenchListener)this);
    }

    public void fileEditorOpened(BslXtextDocumentProvider provider, IFile file) {
        if (DEBUG) {
            BslPlugin.logInfo("EditorUpdateManager::fileEditorOpened()");
            BslPlugin.logInfo("Provider: " + String.valueOf(provider));
            BslPlugin.logInfo("File:           " + String.valueOf(file));
        }
        Set filesSet = this.partToFileMapping.computeIfAbsent(provider, unusedReference -> new ConcurrentSkipListSet<IFile>(Comparator.comparing(comparedFile -> comparedFile.getFullPath().toPortableString())));
        filesSet.add(file);
        this.openedFiles.compute(file, (unusedFile, counter) -> {
            int result;
            int n = result = counter == null ? 1 : counter + 1;
            if (DEBUG) {
                BslPlugin.logInfo(String.format("File counter updated: %d -> %d", counter, result));
            }
            return result;
        });
    }

    public void partClosed(BslXtextDocumentProvider provider) {
        Set filesSet;
        if (DEBUG) {
            BslPlugin.logInfo("EditorUpdateManager::partClosed()");
            BslPlugin.logInfo("Provider reference: " + String.valueOf(provider));
        }
        if ((filesSet = (Set)this.partToFileMapping.remove(provider)) != null) {
            for (IFile file : filesSet) {
                this.openedFiles.compute(file, (unusedFile, counter) -> {
                    Integer result;
                    Integer n = result = counter == null || counter < 2 ? null : Integer.valueOf(counter - 1);
                    if (DEBUG) {
                        BslPlugin.logInfo(String.format("File counter updated: %d -> %d", counter, result));
                    }
                    return result;
                });
            }
        }
    }

    public void invalidated(IFile file) {
        if (DEBUG) {
            BslPlugin.logInfo("Invalidating file " + String.valueOf(file));
        }
        this.openedFiles.computeIfPresent(file, (openedFile, fileCounter) -> {
            this.fileUpdateSet.add((IFile)openedFile);
            this.fileTouchJob.schedule(100L);
            return fileCounter;
        });
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        if (DEBUG) {
            BslPlugin.logInfo("EditorUpdatingManager.IWorkbenchListener::preShutdown()");
        }
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
        if (DEBUG) {
            BslPlugin.logInfo("EditorUpdatingManager.IWorkbenchListener::postShutdown()");
        }
        this.bslContentCacheManager.removeListener((IBslCacheInvalidationListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EditorUpdateManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<EditorUpdateManager> clazz = EditorUpdateManager.class;
        synchronized (EditorUpdateManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new EditorUpdateManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static class BslFileTouchJob
    extends Job {
        private final NavigableSet<IFile> files;

        public BslFileTouchJob(NavigableSet<IFile> files) {
            super("Touch BSL file");
            this.setPriority(20);
            this.files = files;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ResourcesPlugin.getWorkspace().run(runnableMonitor -> {
                    Iterator<IFile> iterator = this.files.iterator();
                    while (iterator.hasNext()) {
                        IFile file = iterator.next();
                        iterator.remove();
                        if (DEBUG) {
                            BslPlugin.logInfo("Touching file " + String.valueOf(file));
                        }
                        file.setLocalTimeStamp(System.currentTimeMillis());
                        file.touch(runnableMonitor);
                    }
                }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, monitor);
            }
            catch (CoreException e) {
                BslPlugin.logError(e);
                return BslPlugin.createErrorStatus(e.getMessage(), e);
            }
            return Status.OK_STATUS;
        }
    }
}

