/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.i18n.extension;

import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.ui.editor.BslDocumentProviderSaveDocumentExtensionContext;
import com._1c.g5.v8.dt.bsl.ui.editor.BslXtextDocument;
import com._1c.g5.v8.dt.bsl.ui.editor.BslXtextDocumentProvider;
import com._1c.g5.v8.dt.bsl.ui.editor.IBslDocumentProviderExtension;
import com._1c.g5.v8.dt.bsl.ui.editor.IBslDocumentProviderExtensionManager;
import com._1c.g5.v8.dt.common.Pair;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.cleaner.BslNStrCleanupVisitor;
import com.e1c.langtool.v8.dt.bsl.i18n.cache.BslContentCacheManager;
import com.e1c.langtool.v8.dt.bsl.i18n.loader.IBslLoadingPreprocessor;
import com.e1c.langtool.v8.dt.documentprocessingsettings.IDocumentProcessingSettingsManager;
import com.e1c.langtool.v8.dt.internal.bsl.ui.BslPlugin;
import com.e1c.langtool.v8.dt.internal.bsl.ui.editorupdater.EditorUpdateManager;
import com.e1c.langtool.v8.dt.xtext.ParseTreeVisitor;
import com.e1c.langtool.v8.dt.xtext.XtextUtils;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

@LifecycleService(name="BslContentWriterExtension")
@Singleton
public class BslContentWriterExtension
implements IBslDocumentProviderExtension {
    private static final boolean DEBUG = BslPlugin.getDefault().isDebugging();
    private static final Set<String> IGNORE_STACK_CALLER_CLASS = ImmutableSet.of((Object)"org.eclipse.compare.CompareEditorInput", (Object)"com.e1c.langtool.v8.dt.sync.AbstractExternalPropertySynchronizer");
    private final ITranslatingProjectManager translatingProjectManager;
    private final ITranslationStorageManager storageManager;
    private final ITranslationFeatureKeyProvider translationKeyProvider;
    private final IStorageSettingsManager storageSettingsManager;
    private final IDocumentProcessingSettingsManager aspectSettingsManager;
    private final IBslDocumentProviderExtensionManager bslDocumentProviderExtensionManager;
    private final IBslLoadingPreprocessor bslLoadingPreprocessor;
    private final IStringLiteralTypeComputer typeComputer;
    private final BslContentCacheManager bslContentCacheManager;
    private final BslPreferences bslPreferences;
    private boolean initialized = false;

    @Inject
    public BslContentWriterExtension(ITranslatingProjectManager translatingProjectManager, ITranslationStorageManager storageManager, ITranslationFeatureKeyProvider translationKeyProvider, IStorageSettingsManager storageSettingsManager, IDocumentProcessingSettingsManager aspectSettingsManager, IBslDocumentProviderExtensionManager bslDocumentProviderExtensionManager, IBslLoadingPreprocessor bslLoadingPreprocessor, IStringLiteralTypeComputer typeComputer, BslContentCacheManager bslContentCacheManager, BslPreferences bslPreferences) {
        this.translatingProjectManager = translatingProjectManager;
        this.storageManager = storageManager;
        this.translationKeyProvider = translationKeyProvider;
        this.storageSettingsManager = storageSettingsManager;
        this.aspectSettingsManager = aspectSettingsManager;
        this.bslDocumentProviderExtensionManager = bslDocumentProviderExtensionManager;
        this.bslLoadingPreprocessor = bslLoadingPreprocessor;
        this.typeComputer = typeComputer;
        this.bslContentCacheManager = bslContentCacheManager;
        this.bslPreferences = bslPreferences;
    }

    public void afterSaveDocument(BslDocumentProviderSaveDocumentExtensionContext context, IProgressMonitor monitor, Object element, boolean overwrite) {
        SaveDocumentContext saveDocumentContext = (SaveDocumentContext)context.getClientContext();
        for (Map.Entry<TranslateLanguage, Map<ContextTranslationKey, String>> translation : saveDocumentContext.translations.entrySet()) {
            TranslateLanguage language = translation.getKey();
            for (Map.Entry<ContextTranslationKey, String> entry : translation.getValue().entrySet()) {
                saveDocumentContext.storage.setTranslation(entry.getKey(), language, entry.getValue(), true);
            }
        }
    }

    public void beforeSaveDocument(BslDocumentProviderSaveDocumentExtensionContext context, IProgressMonitor monitor, Object element, boolean overwrite) {
        BslXtextDocument sourceBslDocument;
        IFile file;
        ITranslationStorageProvider.ContextStorage currentStorage = null;
        IDocument document = context.getDocument();
        final HashMap<TranslateLanguage, Map<ContextTranslationKey, String>> translations = new HashMap<TranslateLanguage, Map<ContextTranslationKey, String>>();
        if (document instanceof BslXtextDocument && this.aspectSettingsManager.isDocumentSaveProcessingEnabled() && (file = (IFile)(sourceBslDocument = (BslXtextDocument)document).getAdapter(IFile.class)) != null) {
            Pair result;
            ITranslatingProject translatingProject;
            StorageID storageId;
            IProject project = file.getProject();
            ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(project, storageId = this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId());
            if (storage instanceof ITranslationStorageProvider.ContextStorage) {
                currentStorage = (ITranslationStorageProvider.ContextStorage)storage;
            }
            if (currentStorage != null && (translatingProject = this.translatingProjectManager.getProject(project)) != null && translatingProject.isTranslating() && (result = (Pair)sourceBslDocument.readOnlyDataModel((IUnitOfWork)new IUnitOfWork<Pair<MultiTextEdit, IDocument>, XtextResource>(){

                public Pair<MultiTextEdit, IDocument> exec(XtextResource resource) throws Exception {
                    EObject result;
                    EList contents = resource.getContents();
                    if (contents != null && !contents.isEmpty() && (result = (EObject)contents.get(0)) instanceof Module) {
                        Module module = (Module)result;
                        ICompositeNode rootNode = NodeModelUtils.getNode((EObject)module);
                        String originalText = rootNode.getText();
                        Document cleanedDocument = new Document(originalText);
                        MultiTextEdit multiTextEdit = new MultiTextEdit();
                        BslNStrCleanupVisitor localizedBslGenerator = new BslNStrCleanupVisitor(multiTextEdit, file, translatingProject.getDefaultLanguage().getLanguageCode(), (Collection)translatingProject.getInterfaceLanguages(), false, translations, BslContentWriterExtension.this.translationKeyProvider, BslContentWriterExtension.this.typeComputer, BslContentWriterExtension.this.bslPreferences);
                        XtextUtils.walkParseTree((INode)rootNode, (ParseTreeVisitor)localizedBslGenerator);
                        return Pair.newPair((Object)multiTextEdit, (Object)cleanedDocument);
                    }
                    return null;
                }
            })) != null) {
                try {
                    IDocument cleanedDocument = (IDocument)result.second;
                    String originalText = cleanedDocument.get();
                    ((MultiTextEdit)result.first).apply(cleanedDocument);
                    String processedText = cleanedDocument.get();
                    if (processedText != null && !processedText.equals(originalText)) {
                        document = cleanedDocument;
                        this.bslContentCacheManager.put(file, processedText);
                    }
                }
                catch (BadLocationException | MalformedTreeException e) {
                    BslPlugin.logError(e);
                }
            }
        }
        context.setDocument(document);
        context.setClientContext((Object)new SaveDocumentContext(translations, currentStorage));
    }

    @LifecycleParticipant(phase=LifecyclePhase.LINKING)
    public void link() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.bslDocumentProviderExtensionManager.setProviderExtension((IBslDocumentProviderExtension)this);
    }

    public void onConnect(BslXtextDocumentProvider provider, IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            IFile file = fileEditorInput.getFile();
            if (DEBUG) {
                BslPlugin.logInfo("AbstractTextEditor::doSetInput()");
                BslPlugin.logInfo("Provider: " + String.valueOf(provider));
                BslPlugin.logInfo("File:           " + String.valueOf(file));
            }
            EditorUpdateManager.getInstance().fileEditorOpened(provider, file);
        }
    }

    public void onDisconnect(BslXtextDocumentProvider provider, IEditorInput editorInput) {
        if (DEBUG) {
            BslPlugin.logInfo("Closing part...");
        }
        EditorUpdateManager.getInstance().partClosed(provider);
    }

    public InputStream replaceStreamOnDocumentLoad(IFile file, InputStream originalStream) {
        InputStream resultStream = null;
        if (this.bslLoadingPreprocessor.isFileCanBeProcessed(file)) {
            StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
            Optional callerClass = walker.walk(s -> s.limit(50L).map(StackWalker.StackFrame::getClassName).filter(IGNORE_STACK_CALLER_CLASS::contains).findFirst());
            if (callerClass.isPresent()) {
                return originalStream;
            }
            resultStream = this.bslLoadingPreprocessor.processFile(file, false, originalStream);
        } else {
            resultStream = originalStream;
        }
        return resultStream;
    }

    private static class SaveDocumentContext {
        public Map<TranslateLanguage, Map<ContextTranslationKey, String>> translations = new HashMap<TranslateLanguage, Map<ContextTranslationKey, String>>();
        public final ITranslationStorageProvider.ContextStorage storage;

        public SaveDocumentContext(Map<TranslateLanguage, Map<ContextTranslationKey, String>> translations, ITranslationStorageProvider.ContextStorage storage) {
            this.translations = translations;
            this.storage = storage;
        }
    }
}

