/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.quickfix;

import com._1c.g5.v8.dt.bsl.documentation.comment.BslCommentUtils;
import com._1c.g5.v8.dt.bsl.documentation.comment.BslDocumentationComment;
import com._1c.g5.v8.dt.bsl.documentation.comment.BslMultiLineCommentDocumentationProvider;
import com._1c.g5.v8.dt.bsl.documentation.comment.DescriptionPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.IDescriptionPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TextPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TypeSection;
import com._1c.g5.v8.dt.bsl.model.FormalParam;
import com._1c.g5.v8.dt.bsl.model.Function;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.resource.TypesComputer;
import com._1c.g5.v8.dt.bsl.ui.quickfix.AbstractExternalQuickfixProvider;
import com._1c.g5.v8.dt.bsl.util.BslUtil;
import com._1c.g5.v8.dt.bsl.validation.BslPreferences;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.mcore.util.McoreUtil;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.bsl.comment.BslDocCommentSerializer;
import com.e1c.langtool.v8.dt.bsl.validation.FunctionReturnTypes;
import com.e1c.langtool.v8.dt.internal.bsl.ui.quickfix.Messages;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class FunctionReturnTypesQuickfixProvider
extends AbstractExternalQuickfixProvider {
    private static final Set<String> TYPES_NEED_PROPERTIES = Set.of(String.join((CharSequence)",", FunctionReturnTypes.DEFAULT_TYPES_NEED_PROPERTIES).toLowerCase().split(","));
    private static final Set<String> TYPES_NEED_CONTAINING = Set.of(String.join((CharSequence)",", FunctionReturnTypes.DEFAULT_TYPES_NEED_CONTAINING).toLowerCase().split(","));
    @Inject
    protected IResourceLookup resourceLookup;
    @Inject
    private IV8ProjectManager v8projectManager;
    private final TypesComputer typesComputer;
    private final BslMultiLineCommentDocumentationProvider commentProvider;
    @Inject
    private BslPreferences bslPreferences;

    public FunctionReturnTypesQuickfixProvider() {
        IResourceServiceProvider rsp = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.bsl"));
        this.typesComputer = (TypesComputer)rsp.get(TypesComputer.class);
        this.commentProvider = (BslMultiLineCommentDocumentationProvider)rsp.get(BslMultiLineCommentDocumentationProvider.class);
    }

    @Fix(value="function-return-types")
    public void generateDocComment(Issue issue, IssueResolutionAcceptor acceptor) {
        String label = Messages.FunctionReturnTypesQuickfixProvider_label;
        String description = Messages.FunctionReturnTypesQuickfixProvider_description;
        acceptor.accept(issue, label, description, null, (IModification)new AbstractExternalQuickfixProvider.ExternalQuickfixModification(issue, Function.class, func -> this.createDocCommentReplace((Function)func)));
    }

    private TextEdit createDocCommentReplace(Function func) {
        boolean oldFormat = this.isOldCommentFormat((EObject)func);
        boolean isRu = BslUtil.isRussian((EObject)func, (IV8ProjectManager)this.v8projectManager);
        BslDocumentationComment comment = BslCommentUtils.parseTemplateComment((Method)func, (boolean)oldFormat, (BslMultiLineCommentDocumentationProvider)this.commentProvider);
        this.appedFunctionDescription(comment, func);
        this.appedFunctionParameters(comment, func, isRu);
        this.appedFunctionReturnValue(comment, func, isRu);
        BslDocCommentSerializer serializer = new BslDocCommentSerializer();
        serializer.setIgnoreLineNumbers(true);
        String content = serializer.serialize(comment, isRu, oldFormat);
        List lines = this.commentProvider.getDocumentationNodes((EObject)func);
        if (lines.isEmpty()) {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)func);
            return new InsertEdit(node.getOffset(), content + System.lineSeparator());
        }
        int offset = ((INode)lines.get(0)).getOffset();
        INode last = (INode)lines.get(lines.size() - 1);
        int length = last.getEndOffset() - offset;
        return new ReplaceEdit(offset, length, content + System.lineSeparator());
    }

    private void appedFunctionDescription(BslDocumentationComment comment, Function func) {
        if (comment.getDescription() == null) {
            comment.setDescription(new BslDocumentationComment.Description((IDescriptionPart)comment));
        }
        if (comment.getDescription().getParts().isEmpty()) {
            Object text = StringUtils.nameToText((String)func.getName());
            text = StringUtils.capitalize((String)text) + ".";
            TextPart descr = new TextPart((IDescriptionPart)comment.getDescription(), -1, (String)text);
            comment.getDescription().getParts().add(descr);
        }
    }

    private void appedFunctionParameters(BslDocumentationComment comment, Function func, boolean isRu) {
        if (func.getFormalParams().isEmpty()) {
            if (comment.getParametersSection() != null) {
                comment.setParametersSection(null);
            }
        } else {
            TypeSection.FieldDefinition field;
            if (comment.getParametersSection() == null) {
                comment.setParametersSection(new BslDocumentationComment.ParametersSection((IDescriptionPart)comment, -1));
            }
            BslDocumentationComment.ParametersSection section = comment.getParametersSection();
            for (FormalParam param : func.getFormalParams()) {
                TypeSection typeSection;
                field = section.getParameterByName(param.getName());
                if (field == null) {
                    field = new TypeSection.FieldDefinition((IDescriptionPart)section, param.getName());
                    field.setLineNumber(-1);
                    section.getParameterDefinitions().add(field);
                }
                if (field.getTypeSections().isEmpty()) {
                    field.getTypeSections().add(new TypeSection((IDescriptionPart)field, -1));
                }
                if ((typeSection = (TypeSection)field.getTypeSections().get(0)).getTypeDefinitions().isEmpty()) {
                    List computeTypes = this.typesComputer.computeTypes((EObject)param, func.environments());
                    descr = StringUtils.nameToText((String)param.getName());
                    descr = StringUtils.capitalize((String)descr);
                    typeSection.fill(computeTypes, " " + descr, isRu, (EObject)func);
                } else if (typeSection.getDescription().getParts().isEmpty()) {
                    String text = StringUtils.nameToText((String)param.getName());
                    text = StringUtils.capitalize((String)text);
                    descr = new TextPart((IDescriptionPart)typeSection.getDescription(), -1, text);
                    typeSection.getDescription().getParts().add(descr);
                }
                this.appendContainingTypeAndProperties(typeSection, isRu);
            }
            for (FormalParam param : func.getFormalParams()) {
                int target;
                field = section.getParameterByName(param.getName());
                int source = func.getFormalParams().indexOf((Object)param);
                if (source == (target = section.getParameterDefinitions().indexOf(field))) continue;
                section.getParameterDefinitions().remove(target);
                section.getParameterDefinitions().add(source, field);
            }
        }
    }

    private void appedFunctionReturnValue(BslDocumentationComment comment, Function func, boolean isRu) {
        TypeSection typeSection;
        BslDocumentationComment.ReturnSection section = comment.getReturnSection();
        if (section == null) {
            section = new BslDocumentationComment.ReturnSection((IDescriptionPart)comment, -1);
            comment.setReturnSection(section);
        }
        if (section.getReturnTypes().isEmpty()) {
            section.getReturnTypes().add(new TypeSection((IDescriptionPart)section, -1));
        }
        String descr = StringUtils.nameToText((String)func.getName());
        descr = StringUtils.capitalize((String)descr);
        if (section.getDescription().getParts().size() == 1 && section.getDescription().getParts().get(0) instanceof TextPart) {
            descr = ((TextPart)section.getDescription().getParts().get(0)).getText();
        }
        if ((typeSection = (TypeSection)section.getReturnTypes().get(0)).getDescription().getParts().size() == 1 && typeSection.getDescription().getParts().get(0) instanceof TextPart) {
            descr = ((TextPart)typeSection.getDescription().getParts().get(0)).getText();
        }
        if (typeSection.getTypeDefinitions().isEmpty()) {
            List computeTypes = this.typesComputer.computeTypes((EObject)func, func.environments());
            if (computeTypes.isEmpty()) {
                typeSection.getTypeDefinitions().add(new TypeSection.TypeDefinition((IDescriptionPart)typeSection, isRu ? "?\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439?" : "?Unknown?"));
                typeSection.getDescription().addPart((DescriptionPart)new TextPart((IDescriptionPart)typeSection.getDescription(), -1, descr));
            } else {
                typeSection.fill(computeTypes, " " + descr, isRu, (EObject)func);
            }
        } else if (typeSection.getDescription().getParts().isEmpty()) {
            TypeSection.TypeDefinition typeDef = (TypeSection.TypeDefinition)typeSection.getTypeDefinitions().get(0);
            String typeName = typeDef.getTypeName();
            if (typeName != null && typeSection.getTypeDefinitions().size() == 1 && typeDef.getFieldDefinitionExtension().isEmpty() && TYPES_NEED_PROPERTIES.contains(typeName.toLowerCase())) {
                List computeTypes = this.typesComputer.computeTypes((EObject)func, func.environments());
                if (computeTypes.stream().anyMatch(t -> typeName.equalsIgnoreCase(isRu ? McoreUtil.getTypeNameRu((TypeItem)t) : McoreUtil.getTypeName((TypeItem)t)))) {
                    typeSection.fill(computeTypes, " " + descr, isRu, (EObject)func);
                } else {
                    typeSection.getDescription().getParts().add(new TextPart((IDescriptionPart)typeSection.getDescription(), -1, descr));
                }
            } else {
                typeSection.getDescription().getParts().add(new TextPart((IDescriptionPart)typeSection.getDescription(), -1, descr));
            }
        } else {
            List computeTypes;
            TypeSection.TypeDefinition typeDef = (TypeSection.TypeDefinition)typeSection.getTypeDefinitions().get(0);
            String typeName = typeDef.getTypeName();
            if (typeName != null && typeSection.getTypeDefinitions().size() == 1 && typeDef.getFieldDefinitionExtension().isEmpty() && TYPES_NEED_PROPERTIES.contains(typeName.toLowerCase()) && (computeTypes = this.typesComputer.computeTypes((EObject)func, func.environments())).stream().anyMatch(t -> typeName.equalsIgnoreCase(isRu ? McoreUtil.getTypeNameRu((TypeItem)t) : McoreUtil.getTypeName((TypeItem)t)))) {
                typeSection.getDescription().getParts().clear();
                typeSection.fill(computeTypes, " " + descr, isRu, (EObject)func);
            }
        }
        this.appendContainingTypeAndProperties(typeSection, isRu);
    }

    private void appendContainingTypeAndProperties(TypeSection typeSection, boolean isRu) {
        if (typeSection.getTypeDefinitions().isEmpty()) {
            return;
        }
        TypeSection.TypeDefinition typeDef = (TypeSection.TypeDefinition)typeSection.getTypeDefinitions().get(typeSection.getTypeDefinitions().size() - 1);
        this.appendContainingTypeAndProperties(typeDef, isRu);
    }

    private void appendContainingTypeAndProperties(TypeSection.TypeDefinition typeDef, boolean isRu) {
        String typeName = typeDef.getTypeName();
        if (typeName != null && typeDef.getContainTypes().isEmpty() && TYPES_NEED_CONTAINING.contains(typeName.toLowerCase())) {
            typeDef.addContainType(new TypeSection.TypeDefinition((IDescriptionPart)typeDef, isRu ? "?\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439?" : "?Unknown?"));
        } else if (!typeDef.getContainTypes().isEmpty()) {
            for (TypeSection.TypeDefinition containingType : typeDef.getContainTypes()) {
                this.appendContainingTypeAndProperties(containingType, isRu);
            }
        }
        if (typeName != null && typeDef.getFieldDefinitionExtension().isEmpty() && TYPES_NEED_PROPERTIES.contains(typeName.toLowerCase())) {
            TypeSection.FieldDefinition unknownProperty = new TypeSection.FieldDefinition((IDescriptionPart)typeDef, isRu ? "\u041f\u043e\u043b\u04351?" : "Field1?");
            TypeSection unknownPropertyTypeSection = new TypeSection((IDescriptionPart)unknownProperty, -1);
            TypeSection.TypeDefinition unknownPropertyTypeDefinition = new TypeSection.TypeDefinition((IDescriptionPart)unknownPropertyTypeSection, isRu ? "?\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439?" : "?Unknown?");
            unknownPropertyTypeSection.getTypeDefinitions().add(unknownPropertyTypeDefinition);
            unknownProperty.getTypeSections().add(unknownPropertyTypeSection);
            typeDef.getFieldDefinitionExtension().add(unknownProperty);
        } else if (!typeDef.getFieldDefinitionExtension().isEmpty()) {
            for (TypeSection.FieldDefinition field : typeDef.getFieldDefinitionExtension()) {
                if (field.getTypeSections().isEmpty()) continue;
                TypeSection fieldTypeSection = (TypeSection)field.getTypeSections().get(field.getTypeSections().size() - 1);
                this.appendContainingTypeAndProperties(fieldTypeSection, isRu);
            }
        }
    }

    private boolean isOldCommentFormat(EObject object) {
        IProject project = this.resourceLookup.getProject(object);
        return this.bslPreferences.getDocumentCommentProperties(project).oldCommentFormat();
    }
}

