/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.quickfix;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.Expression;
import com._1c.g5.v8.dt.bsl.model.FeatureAccess;
import com._1c.g5.v8.dt.bsl.model.Invocation;
import com._1c.g5.v8.dt.bsl.model.SimpleStatement;
import com._1c.g5.v8.dt.bsl.model.Statement;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.TypeUtil;
import com._1c.g5.v8.dt.bsl.ui.quickfix.AbstractExternalQuickfixProvider;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.lcore.ui.texteditor.IndentTextEditorProvider;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.v8.dt.bsl.validation.NstrCamelCaseWordValidator;
import com.e1c.langtool.v8.dt.internal.bsl.ui.BslPlugin;
import com.e1c.langtool.v8.dt.internal.bsl.ui.quickfix.Messages;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.LineAndColumn;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.validation.Issue;

public class NstrCamelCaseWordQuikfixProvider
extends AbstractExternalQuickfixProvider {
    private static final String NSTR_NAME = "NStr";
    private static final String NSTR_NAME_RU = "\u041d\u0421\u0442\u0440";
    private static final String REPLACE_NAME = "Param";
    private static final String REPLACE_NAME_RU = "\u041f\u0430\u0440\u0430\u043c";
    private static final String SEMICOLON = ";";
    private static final String STR_REPLACE = "StrReplace";
    private static final String STR_REPLACE_RU = "\u0421\u0442\u0440\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c";
    private static final String STR_TEMPLATE = "StrTemplate";
    private static final String STR_TEMPLATE_RU = "\u0421\u0442\u0440\u0428\u0430\u0431\u043b\u043e\u043d";
    private static final String TEMPLATE_VAR_NAME = "Template";
    private static final String TEMPLATE_VAR_NAME_RU = "\u0428\u0430\u0431\u043b\u043e\u043d";
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("%\\d", 8);
    @Inject
    private IndentTextEditorProvider indentProvider;
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private IV8ProjectManager v8ProjectManager;

    @Fix(value="module-nstr-camelcase")
    public void extractToStrReplace(Issue issue, IssueResolutionAcceptor acceptor) {
        CharSequence[] words = issue.getData();
        String label = MessageFormat.format(Messages.NstrCamelCaseWordQuikfixProvider_Extract_to_StrReplace_title, String.join((CharSequence)", ", words));
        acceptor.accept(issue, label, Messages.NstrCamelCaseWordQuikfixProvider_Extract_to_StrReplace_description, null, (IModification)new AbstractExternalQuickfixProvider.ExternalQuickfixModification(issue, StringLiteral.class, arg_0 -> this.lambda$0((String[])words, arg_0)));
    }

    @Fix(value="module-nstr-camelcase")
    public void extractToStrTemplate(Issue issue, IssueResolutionAcceptor acceptor) {
        CharSequence[] words = issue.getData();
        if (words.length > 10) {
            return;
        }
        String label = MessageFormat.format(Messages.NstrCamelCaseWordQuikfixProvider_Extract_to_StrTemplate_title, String.join((CharSequence)", ", words));
        acceptor.accept(issue, label, Messages.NstrCamelCaseWordQuikfixProvider_Extract_to_StrTemplate_description, null, (IModification)new AbstractExternalQuickfixProvider.ExternalQuickfixModification(issue, StringLiteral.class, arg_0 -> this.lambda$1((String[])words, arg_0)));
    }

    @Fix(value="module-nstr-camelcase")
    public void removeCamelCaseWords(Issue issue, IssueResolutionAcceptor acceptor) {
        CharSequence[] words = issue.getData();
        if (words.length > 1) {
            String description = MessageFormat.format(Messages.NstrCamelCaseWordQuikfixProvider_Remove_all_words_description, String.join((CharSequence)", ", words));
            acceptor.accept(issue, Messages.NstrCamelCaseWordQuikfixProvider_Remove_all_words_title, description, null, (IModification)new AbstractExternalQuickfixProvider.ExternalQuickfixModification(issue, StringLiteral.class, arg_0 -> this.lambda$2((String[])words, arg_0)));
        }
        int i = 0;
        while (i < words.length) {
            CharSequence word = words[i];
            String label = MessageFormat.format(Messages.NstrCamelCaseWordQuikfixProvider_Remove_word_title, word);
            acceptor.accept(issue, label, Messages.NstrCamelCaseWordQuikfixProvider_Remove_word_description, null, (IModification)new AbstractExternalQuickfixProvider.ExternalQuickfixModification(issue, StringLiteral.class, arg_0 -> this.lambda$3((String)word, arg_0)));
            ++i;
        }
    }

    private void addRemoveEdits(List<INode> nodes, Set<String> words, MultiTextEdit edits) {
        for (INode node : nodes) {
            Matcher matcher = NstrCamelCaseWordValidator.CAMELCASE_PATTERN.matcher(node.getText());
            while (matcher.find()) {
                String word = matcher.group(0);
                if (word.startsWith(".")) {
                    word = word.substring(1);
                }
                if (word.endsWith(".")) {
                    word = word.substring(0, word.length() - 1);
                }
                if (!words.contains(word)) continue;
                DeleteEdit edit = new DeleteEdit(node.getOffset() + matcher.start(), word.length());
                edits.addChild((TextEdit)edit);
            }
        }
    }

    private void addReplaceEdits(List<INode> nodes, Map<String, String> words, MultiTextEdit edits) {
        for (INode node : nodes) {
            Matcher matcher = NstrCamelCaseWordValidator.CAMELCASE_PATTERN.matcher(node.getText());
            while (matcher.find()) {
                String word = matcher.group(0);
                if (word.startsWith(".")) {
                    word = word.substring(1);
                }
                if (word.endsWith(".")) {
                    word = word.substring(0, word.length() - 1);
                }
                if (!words.containsKey(word)) continue;
                String replace = words.get(word);
                ReplaceEdit edit = new ReplaceEdit(node.getOffset() + matcher.start(), word.length(), replace);
                edits.addChild((TextEdit)edit);
            }
        }
    }

    private TextEdit createExtractToStrReplaceEdits(@NonNull StringLiteral literal, String[] words) {
        IV8Project project = this.v8ProjectManager.getProject((EObject)literal);
        Statement statement = (Statement)EcoreUtil2.getContainerOfType((EObject)literal, Statement.class);
        if (statement == null) {
            return null;
        }
        List linesNodes = NodeModelUtils.findNodesForFeature((EObject)literal, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES);
        boolean isRu = project.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        MultiTextEdit edits = new MultiTextEdit();
        Map<String, String> replace = this.getStrReplaceWordReplacement(words, isRu);
        int insertOffset = 0;
        String templateName = null;
        ICompositeNode statementNode = NodeModelUtils.findActualNodeFor((EObject)statement);
        String indent = this.getIndent((INode)statementNode);
        if (this.isFeatureAssignment(statement, literal)) {
            this.addReplaceEdits(linesNodes, replace, edits);
            ICompositeNode leftNode = NodeModelUtils.findActualNodeFor((EObject)((SimpleStatement)statement).getLeft());
            templateName = leftNode.getText().trim();
            insertOffset = this.getLineEndingOffsetAfterSemicolon(statementNode);
        } else {
            insertOffset = statementNode.getOffset();
            templateName = this.extractNstrToStatement(literal, linesNodes, edits, replace, insertOffset, isRu, indent);
        }
        String templateText = this.createStrReplaceText(templateName, replace, indent, isRu);
        InsertEdit edit = new InsertEdit(insertOffset, templateText);
        edits.addChild((TextEdit)edit);
        if (edits.hasChildren()) {
            return edits;
        }
        return null;
    }

    private TextEdit createExtractToStrTemplateEdits(@NonNull StringLiteral literal, String[] words) {
        IV8Project project = this.v8ProjectManager.getProject((EObject)literal);
        Statement statement = (Statement)EcoreUtil2.getContainerOfType((EObject)literal, Statement.class);
        if (statement == null) {
            return null;
        }
        List linesNodes = NodeModelUtils.findNodesForFeature((EObject)literal, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES);
        boolean isRu = project.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        MultiTextEdit edits = new MultiTextEdit();
        Map<String, String> replace = this.getStrTemplateWordReplacement(words);
        int insertOffset = 0;
        String templateName = null;
        ICompositeNode statementNode = NodeModelUtils.findActualNodeFor((EObject)statement);
        String indent = this.getIndent((INode)statementNode);
        if (this.isFeatureAssignment(statement, literal)) {
            this.addReplaceEdits(linesNodes, replace, edits);
            ICompositeNode leftNode = NodeModelUtils.findActualNodeFor((EObject)((SimpleStatement)statement).getLeft());
            templateName = leftNode.getText().trim();
            insertOffset = this.getLineEndingOffsetAfterSemicolon(statementNode);
        } else {
            insertOffset = statementNode.getOffset();
            templateName = this.extractNstrToStatement(literal, linesNodes, edits, replace, insertOffset, isRu, indent);
        }
        String templateText = this.createStrTemplateText(templateName, words, indent, isRu);
        InsertEdit edit = new InsertEdit(insertOffset, templateText);
        edits.addChild((TextEdit)edit);
        if (edits.hasChildren()) {
            return edits;
        }
        return null;
    }

    private String createNstrAnnotationText(String indent, boolean isRu) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append(indent);
        sb.append("//");
        sb.append(" ");
        sb.append("@");
        LiteralType type = this.typeComputer.getType(NSTR_NAME);
        sb.append(isRu ? type.getNameRu() : type.getName());
        return sb.toString();
    }

    private String createStatemnetText(String templateName, String source, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append(indent);
        sb.append(templateName);
        sb.append(" = ");
        sb.append(source);
        sb.append(SEMICOLON);
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    private String createStrReplaceText(String templateName, Map<String, String> replace, String ident, boolean isRu) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append(ident);
        ArrayList<String> words = new ArrayList<String>(replace.keySet());
        Collections.sort(words);
        for (String word : words) {
            String param = replace.get(word);
            sb.append(templateName);
            sb.append(" = ");
            sb.append(isRu ? STR_REPLACE_RU : STR_REPLACE);
            sb.append("(");
            sb.append(templateName);
            sb.append(", \"");
            sb.append(param);
            sb.append("\"");
            sb.append(", \"");
            sb.append(word);
            sb.append("\"");
            sb.append(")");
            sb.append(SEMICOLON);
            sb.append(System.lineSeparator());
            sb.append(ident);
        }
        sb.append(System.lineSeparator());
        sb.append(ident);
        return sb.toString();
    }

    private String createStrTemplateText(String templateName, String[] words, String ident, boolean isRu) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append(ident);
        sb.append(templateName);
        sb.append(" = ");
        sb.append(isRu ? STR_TEMPLATE_RU : STR_TEMPLATE);
        sb.append("(");
        sb.append(templateName);
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            sb.append(", \"");
            sb.append(word);
            sb.append("\"");
            ++i;
        }
        sb.append(")");
        sb.append(SEMICOLON);
        sb.append(System.lineSeparator());
        sb.append(ident);
        return sb.toString();
    }

    private String extractNstrToStatement(StringLiteral literal, List<INode> linesNodes, MultiTextEdit edits, Map<String, String> replace, int insertOffset, boolean isRu, String indent) {
        ICompositeNode nstrNode = this.getNstrNodeForExtract((EObject)literal);
        this.moveNstrAnnotation(literal, nstrNode, edits, insertOffset, indent, isRu);
        String templateName = this.getLocalVarName(literal, isRu);
        DeleteEdit delete = new DeleteEdit(nstrNode.getOffset(), nstrNode.getLength());
        String sourceText = this.getReplacedNstrText(nstrNode, linesNodes, replace);
        String templateStatementText = this.createStatemnetText(templateName, sourceText, indent);
        InsertEdit insert = new InsertEdit(insertOffset, templateStatementText);
        edits.addChild((TextEdit)delete);
        edits.addChild((TextEdit)insert);
        insert = new InsertEdit(nstrNode.getTotalOffset(), templateName);
        edits.addChild((TextEdit)insert);
        return templateName;
    }

    private String getIndent(INode node) {
        LineAndColumn info = NodeModelUtils.getLineAndColumn((INode)node, (int)node.getOffset());
        if (info.getColumn() > 1) {
            String indent = node.getRootNode().getText().substring(node.getOffset() - info.getColumn(), node.getOffset());
            return this.indentProvider.convertToIndent(indent);
        }
        return this.indentProvider.getIndent();
    }

    private int getLineEndingOffsetAfterSemicolon(ICompositeNode statementNode) {
        int insertOffset = statementNode.getTotalEndOffset();
        int terminatorLine = 0;
        ICompositeNode next = statementNode;
        while (next.hasNextSibling()) {
            next = next.getNextSibling();
            for (ILeafNode leaf : next.getLeafNodes()) {
                if (!leaf.isHidden() && leaf.getText().equals(SEMICOLON)) {
                    terminatorLine = leaf.getStartLine();
                    insertOffset = leaf.getTotalEndOffset();
                }
                if (leaf.isHidden() && terminatorLine > 0 && leaf.getStartLine() <= terminatorLine) {
                    insertOffset = leaf.getTotalEndOffset();
                    continue;
                }
                if (terminatorLine > 0 && leaf.getStartLine() > terminatorLine) break;
            }
            if (terminatorLine > 0 && next.getStartLine() > terminatorLine) break;
        }
        return insertOffset;
    }

    private String getLocalVarName(StringLiteral literal, boolean isRu) {
        int index = 1;
        return isRu ? TEMPLATE_VAR_NAME_RU + index : TEMPLATE_VAR_NAME + index;
    }

    private ICompositeNode getNstrNodeForExtract(EObject literal) {
        EObject parent = literal.eContainer();
        if (parent instanceof Invocation && ((Invocation)parent).getParams().indexOf((Object)literal) == 0 && (((Invocation)parent).getMethodAccess().getName().equalsIgnoreCase(NSTR_NAME_RU) || ((Invocation)parent).getMethodAccess().getName().equalsIgnoreCase(NSTR_NAME))) {
            return NodeModelUtils.findActualNodeFor((EObject)parent);
        }
        return NodeModelUtils.findActualNodeFor((EObject)literal);
    }

    private String getReplacedNstrText(ICompositeNode nstrNode, List<INode> linesNodes, Map<String, String> replace) {
        MultiTextEdit edits2 = new MultiTextEdit();
        this.addReplaceEdits(linesNodes, replace, edits2);
        String sourceText = nstrNode.getRootNode().getText().substring(0, nstrNode.getEndOffset());
        Document document = new Document(sourceText);
        try {
            edits2.apply((IDocument)document);
            sourceText = document.get().substring(nstrNode.getOffset());
        }
        catch (BadLocationException | MalformedTreeException e) {
            BslPlugin.logError(e);
            sourceText = nstrNode.getRootNode().getText().substring(nstrNode.getOffset(), nstrNode.getEndOffset());
        }
        return sourceText;
    }

    private Map<String, String> getStrReplaceWordReplacement(String[] words, boolean isRu) {
        HashMap<String, String> replace = new HashMap<String, String>();
        int shift = 1;
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            String param = isRu ? REPLACE_NAME_RU : REPLACE_NAME;
            replace.put(word, "%" + param + (shift + i) + "%");
            ++i;
        }
        return replace;
    }

    private Map<String, String> getStrTemplateWordReplacement(String[] words) {
        HashMap<String, String> replace = new HashMap<String, String>();
        int shift = 1;
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            replace.put(word, "%" + (shift + i));
            ++i;
        }
        return replace;
    }

    private boolean isFeatureAssignment(Statement statement, @NonNull StringLiteral literal) {
        if (!(statement instanceof SimpleStatement)) {
            return false;
        }
        SimpleStatement simple = (SimpleStatement)statement;
        if (!(simple.getLeft() instanceof FeatureAccess)) {
            return false;
        }
        Expression right = simple.getRight();
        if (literal.equals(right)) {
            return true;
        }
        return right instanceof Invocation && ((Invocation)right).getParams().indexOf((Object)literal) == 0 && (((Invocation)right).getMethodAccess().getName().equalsIgnoreCase(NSTR_NAME_RU) || ((Invocation)right).getMethodAccess().getName().equalsIgnoreCase(NSTR_NAME));
    }

    private void moveNstrAnnotation(StringLiteral literal, ICompositeNode nstrNode, MultiTextEdit edits, int insertOffset, String indent, boolean isRu) {
        if (this.typeComputer.getAnnotatedTypes(literal).contains(this.typeComputer.getType(NSTR_NAME))) {
            LiteralType nstrType = this.typeComputer.getType(NSTR_NAME);
            INode annotationNode = (INode)this.typeComputer.getAnnotationNodes(literal).get(nstrType);
            if (annotationNode != null && annotationNode.getTotalOffset() < nstrNode.getOffset() && annotationNode.getTotalOffset() > insertOffset) {
                MoveSourceEdit source = new MoveSourceEdit(annotationNode.getTotalOffset(), annotationNode.getTotalLength());
                MoveTargetEdit target = new MoveTargetEdit(insertOffset, source);
                edits.addChild((TextEdit)source);
                edits.addChild((TextEdit)target);
            } else if (annotationNode != null) {
                List literals = TypeUtil.getStringLiteralsInLine((StringLiteral)literal);
                Pair offsetAndLength = TypeUtil.getAnnotationOffsetAndLength((LiteralType)nstrType, (ICompositeNode)nstrNode, (int)literals.indexOf(literal), (INode)annotationNode);
                DeleteEdit delete = new DeleteEdit(((Integer)offsetAndLength.getFirst()).intValue(), ((Integer)offsetAndLength.getSecond()).intValue());
                edits.addChild((TextEdit)delete);
                InsertEdit insert = new InsertEdit(insertOffset, this.createNstrAnnotationText(indent, isRu));
                edits.addChild((TextEdit)insert);
            }
        }
    }

    private /* synthetic */ TextEdit lambda$0(String[] stringArray, StringLiteral literal) {
        return this.createExtractToStrReplaceEdits(literal, stringArray);
    }

    private /* synthetic */ TextEdit lambda$1(String[] stringArray, StringLiteral literal) {
        String text = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)literal.lines(false));
        Matcher matcher = TEMPLATE_PATTERN.matcher(text);
        if (matcher.find()) {
            String message = MessageFormat.format(Messages.NstrCamelCaseWordQuikfixProvider_Warning_messge, matcher.group());
            if (!MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.NstrCamelCaseWordQuikfixProvider_Warning_title, (String)message)) {
                return null;
            }
        }
        return this.createExtractToStrTemplateEdits(literal, stringArray);
    }

    private /* synthetic */ TextEdit lambda$2(String[] stringArray, StringLiteral literal) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)literal, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES);
        MultiTextEdit edits = new MultiTextEdit();
        this.addRemoveEdits(nodes, Set.of(stringArray), edits);
        if (edits.hasChildren()) {
            return edits;
        }
        return null;
    }

    private /* synthetic */ TextEdit lambda$3(String string, StringLiteral literal) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)literal, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES);
        MultiTextEdit edits = new MultiTextEdit();
        this.addRemoveEdits(nodes, Set.of(string), edits);
        if (edits.hasChildren()) {
            return edits;
        }
        return null;
    }
}

