/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor;

import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.SideBySideEditor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;

public class SideBySideEditorSelectionProvider
implements IPostSelectionProvider {
    private ListenerList<ISelectionChangedListener> listeners = new ListenerList();
    private ListenerList<ISelectionChangedListener> postListeners = new ListenerList();
    private SideBySideEditor editor;
    private ISelection globalSelection;

    public SideBySideEditorSelectionProvider(SideBySideEditor editor) {
        Assert.isNotNull((Object)((Object)editor));
        this.editor = editor;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.add((Object)listener);
    }

    public void fireSelectionChanged(SelectionChangedEvent event) {
        this.fireEventChange(event, this.listeners);
    }

    public void firePostSelectionChanged(SelectionChangedEvent event) {
        this.fireEventChange(event, this.postListeners);
    }

    private void fireEventChange(final SelectionChangedEvent event, ListenerList<ISelectionChangedListener> listenersList) {
        for (final ISelectionChangedListener l : listenersList) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
        }
    }

    public SideBySideEditor getEditor() {
        return this.editor;
    }

    public ISelection getSelection() {
        ISelectionProvider selectionProvider;
        IEditorPart activeEditor = this.editor.getActiveEditor();
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return this.globalSelection != null ? this.globalSelection : StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        IEditorPart activeEditor = this.editor.getActiveEditor();
        if (activeEditor != null) {
            ISelectionProvider selectionProvider = activeEditor.getSite().getSelectionProvider();
            if (selectionProvider != null) {
                selectionProvider.setSelection(selection);
            }
        } else {
            this.globalSelection = selection;
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.globalSelection));
        }
    }
}

