/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat;

import com.e1c.langtool.internal.stat.Messages;
import com.e1c.langtool.stat.ComputerEngine;
import com.e1c.langtool.stat.GroupProvider;
import com.e1c.langtool.stat.StatisticsManager;
import com.e1c.langtool.stat.StatisticsService;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class AsyncRecomputer {
    private static final long ASYNC_RECOMPUTE_DELAY = 500L;
    private final StatisticsService statisticService;
    private final ComputerEngine engine;
    private final Map<IProject, Collection<IPath>> recomputed = new ConcurrentHashMap<IProject, Collection<IPath>>();
    private final RecomputeJob asyncRecompute = new RecomputeJob();
    private final AtomicBoolean autoStart;

    public AsyncRecomputer(StatisticsService statisticService, ComputerEngine engine, AtomicBoolean autoStart) {
        this.statisticService = statisticService;
        this.engine = engine;
        this.autoStart = autoStart;
    }

    public void scheduleComputeFullStat() {
        this.asyncRecompute.schedule(500L);
    }

    public void scheduleCompute() {
        if (this.autoStart.get()) {
            this.asyncRecompute.schedule(500L);
        }
    }

    public void startRemoveStatistic(IProject project) {
        this.cleanQueue(project);
        StatisticsManager manager = this.statisticService.getManager(project);
        manager.removeStatistic();
    }

    public void cleanQueue(IProject project) {
        Collection<IPath> queue = this.recomputed.get(project);
        if (queue != null) {
            queue.clear();
        }
    }

    public void addToQueue(IProject project, IPath path) {
        this.recomputed.computeIfAbsent(project, p -> ConcurrentHashMap.newKeySet()).add(path);
    }

    public void removeFromQueue(IProject project, IPath path) {
        Iterator<Map.Entry<IProject, Collection<IPath>>> iterator = this.recomputed.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IProject, Collection<IPath>> entry = iterator.next();
            if (!project.equals((Object)entry.getKey())) continue;
            Iterator<IPath> fileIterator = entry.getValue().iterator();
            while (fileIterator.hasNext()) {
                if (!path.equals((Object)fileIterator.next())) continue;
                iterator.remove();
            }
        }
    }

    private class RecomputeJob
    extends Job {
        public RecomputeJob() {
            super(Messages.AsyncRecomputer_Recompute);
        }

        public boolean belongsTo(Object family) {
            return "Statistics".equals(family);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Iterator<Map.Entry<IProject, Collection<IPath>>> iterator = AsyncRecomputer.this.recomputed.entrySet().iterator();
            while (iterator.hasNext()) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Map.Entry<IProject, Collection<IPath>> entry = iterator.next();
                IProject project = entry.getKey();
                if (!project.isAccessible()) {
                    return Status.CANCEL_STATUS;
                }
                Collection<IPath> files = entry.getValue();
                iterator.remove();
                this.recompute(project, files, monitor);
            }
            return Status.OK_STATUS;
        }

        private void recompute(IProject project, Collection<IPath> files, IProgressMonitor monitor) {
            StatisticsManager statisticManager = AsyncRecomputer.this.statisticService.getManager(project);
            for (IPath path : files) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (path.isEmpty() || files.size() > 100) {
                    AsyncRecomputer.this.engine.compute(project, monitor);
                    AsyncRecomputer.this.cleanQueue(project);
                    return;
                }
                for (GroupProvider provider : AsyncRecomputer.this.statisticService.getGroupProviders()) {
                    for (IPath group : provider.getParents(path, project)) {
                        statisticManager.removeStatistic(group);
                    }
                }
                statisticManager.removeStatistic(path);
                AsyncRecomputer.this.engine.computeResource(project, path, monitor);
                AsyncRecomputer.this.engine.computeParents(project, path, monitor);
            }
            if (!files.isEmpty()) {
                AsyncRecomputer.this.engine.computeTotalValue(project, monitor);
            }
        }
    }
}

