/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.collector.ProjectMultiThreadCollectingOperation;
import com.e1c.langtool.internal.stat.GroupProviderRegistry;
import com.e1c.langtool.internal.stat.Messages;
import com.e1c.langtool.internal.stat.PersistentStatistics;
import com.e1c.langtool.internal.stat.StatUtils;
import com.e1c.langtool.internal.stat.StatisticsComputerRegistry;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.stat.ComputerEngine;
import com.e1c.langtool.stat.GroupProvider;
import com.e1c.langtool.stat.GroupingRule;
import com.e1c.langtool.stat.Metric;
import com.e1c.langtool.stat.Statistics;
import com.e1c.langtool.stat.StatisticsComputer;
import com.e1c.langtool.stat.StatisticsManager;
import com.e1c.langtool.stat.StatisticsProvider;
import com.e1c.langtool.stat.StatisticsService;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;

public class ComputerEngineImpl
implements ComputerEngine {
    private final StatisticsService statisticsService;
    private final ITranslatingProjectManager translatingProjectManager;
    private final IFeatureValueCollectingService collectingService;
    private final StatisticsComputerRegistry computerRegistry;
    private final GroupProviderRegistry groupProviderRegistry;

    @Inject
    public ComputerEngineImpl(StatisticsService statisticsService, ITranslatingProjectManager translatingProjectManager, IFeatureValueCollectingService collectingService, GroupProviderRegistry groupProviderRegistry, StatisticsComputerRegistry computerRegistry) {
        this.statisticsService = statisticsService;
        this.translatingProjectManager = translatingProjectManager;
        this.collectingService = collectingService;
        this.computerRegistry = computerRegistry;
        this.groupProviderRegistry = groupProviderRegistry;
    }

    @Override
    public IStatus computeTotalValue(IProject project, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!project.isAccessible()) {
            return Status.OK_STATUS;
        }
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        if (!translating.isTranslating()) {
            return Status.OK_STATUS;
        }
        @NonNull StatisticsManager statisticsManager = this.statisticsService.getManager(project);
        @NonNull StatisticsProvider statisticsProvider = this.statisticsService.getProvider(project);
        List languages = translating.getInterfaceLanguages();
        Collection<Metric> metrics = this.statisticsService.getMetrics();
        ConcurrentHashMap<String, Integer> totalBaseValues = new ConcurrentHashMap<String, Integer>();
        ConcurrentHashMap<String, Map<String, Integer>> totalValues = new ConcurrentHashMap<String, Map<String, Integer>>();
        Collection<IPath> resources = StatUtils.getResources(project.getProjectRelativePath(), project);
        for (IPath resource : resources) {
            @NonNull Statistics stat = statisticsProvider.getStatistic(resource);
            for (Metric metric : metrics) {
                totalBaseValues.computeIfAbsent(metric.getID(), k -> 0);
                totalBaseValues.computeIfPresent(metric.getID(), (k, value) -> metric.getGroupingRule().apply(stat.getMetricValue(metric), (int)value));
                Map langTotal = totalValues.computeIfAbsent(metric.getID(), k -> new ConcurrentHashMap());
                for (TranslateLanguage language : languages) {
                    if (!metric.isApplicable(language)) continue;
                    langTotal.computeIfAbsent(language.getLanguageCode(), k -> 0);
                    langTotal.computeIfPresent(language.getLanguageCode(), (k, value) -> metric.getGroupingRule().apply(stat.getMetricValue(metric, language), (int)value));
                }
            }
        }
        if (resources.isEmpty()) {
            for (Metric metric : metrics) {
                totalBaseValues.computeIfAbsent(metric.getID(), k -> 0);
                Map langTotal = totalValues.computeIfAbsent(metric.getID(), k -> new ConcurrentHashMap());
                for (TranslateLanguage language : languages) {
                    if (!metric.isApplicable(language)) continue;
                    langTotal.computeIfAbsent(language.getLanguageCode(), k -> 0);
                }
            }
        }
        Map<String, Map<String, Float>> totalPercentage = this.computePercentage(totalBaseValues, totalValues, languages);
        PersistentStatistics stat = new PersistentStatistics(totalBaseValues, totalValues, totalPercentage);
        statisticsManager.updateProjectStatistic(stat);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus compute(IProject project, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!project.isAccessible()) {
            return Status.OK_STATUS;
        }
        @NonNull StatisticsManager statisticsManager = this.statisticsService.getManager(project);
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        if (!translating.isTranslating()) {
            return Status.OK_STATUS;
        }
        CollectingParameters.Builder paramBuilder = CollectingParameters.builder().enableCache().collectChildObjects().collectSubResources().collectInterface();
        if (!translating.getModelLanguages().isEmpty()) {
            paramBuilder.collectModel();
        }
        ProjectMultiThreadCollectingOperation operation = ProjectMultiThreadCollectingOperation.Builder.newBuilder().collectingService(this.collectingService).threadNamePrefix("Project-statisticss-").operationTaskName(Messages.ComputerEngineImpl_Statistic_computer_job).parameters((ICollectingParameters)paramBuilder.build()).project(project).build();
        List languages = translating.getInterfaceLanguages();
        ConcurrentHashMap<String, Integer> totalBaseValues = new ConcurrentHashMap<String, Integer>();
        ConcurrentHashMap<String, Map<String, Integer>> totalValues = new ConcurrentHashMap<String, Map<String, Integer>>();
        ConcurrentHashMap groupBaseValues = new ConcurrentHashMap();
        ConcurrentHashMap groupValues = new ConcurrentHashMap();
        BiConsumer<IFile, Collection> action = (file, fValues) -> {
            if (fValues.isEmpty()) {
                return;
            }
            if (monitor.isCanceled()) {
                return;
            }
            IPath path = file.getProjectRelativePath();
            Collection keys = fValues.stream().map(FeatureValue::getContextKey).collect(Collectors.toSet());
            if (keys.isEmpty()) {
                return;
            }
            Map<String, Integer> baseValues = this.computeBaseMetrics(project, keys);
            Map<String, Map<String, Integer>> values = this.computeMetrics(project, keys, languages);
            Map<String, Map<String, Float>> percentage = this.computePercentage(baseValues, values, languages);
            PersistentStatistics stat = new PersistentStatistics(baseValues, values, percentage);
            statisticsManager.updateFullStatistic(path, (Statistics)stat);
            this.appendGroupBase(groupBaseValues, path, stat, project);
            this.appendGroupValue(groupValues, path, stat, languages, project);
            this.appendTotalBase(totalBaseValues, baseValues);
            this.appendTotalValue(totalValues, values, languages);
        };
        statisticsManager.removeStatistic();
        operation.processByFiles(action, monitor);
        Map<String, Map<String, Float>> totalPercentage = this.computePercentage(totalBaseValues, totalValues, languages);
        PersistentStatistics stat = new PersistentStatistics(totalBaseValues, totalValues, totalPercentage);
        statisticsManager.updateProjectStatistic(stat);
        for (Map.Entry entry : groupBaseValues.entrySet()) {
            Map bValue = (Map)entry.getValue();
            Map values = (Map)groupValues.get(entry.getKey());
            Map<String, Map<String, Float>> groupPercentage = this.computePercentage(bValue, values, languages);
            PersistentStatistics statGroup = new PersistentStatistics(bValue, values, groupPercentage);
            statisticsManager.updateFullStatistic((IPath)entry.getKey(), (Statistics)statGroup);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus computeResource(IProject project, IPath path, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!project.isAccessible()) {
            return Status.OK_STATUS;
        }
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        if (!translating.isTranslating()) {
            return Status.OK_STATUS;
        }
        List languages = translating.getInterfaceLanguages();
        CollectingParameters.Builder paramBuilder = CollectingParameters.builder().enableCache().collectChildObjects().collectSubResources().collectInterface();
        if (!translating.getModelLanguages().isEmpty()) {
            paramBuilder.collectModel();
        }
        ConcurrentHashMap.KeySetView keys = ConcurrentHashMap.newKeySet();
        BiConsumer<Object, FeatureValue> action = (object, feature) -> {
            boolean bl = keys.add(feature.getContextKey());
        };
        this.collectingService.collectFile(project.getFile(path), (ICollectingParameters)paramBuilder.build(), action, monitor);
        Map<String, Integer> baseValues = this.computeBaseMetrics(project, keys);
        Map<String, Map<String, Integer>> values = this.computeMetrics(project, keys, languages);
        Map<String, Map<String, Float>> percentage = this.computePercentage(baseValues, values, languages);
        PersistentStatistics stat = new PersistentStatistics(baseValues, values, percentage);
        @NonNull StatisticsManager statisticsManager = this.statisticsService.getManager(project);
        statisticsManager.updateFullStatistic(path, (Statistics)stat);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus computeParents(IProject project, IPath path, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!project.isAccessible()) {
            return Status.OK_STATUS;
        }
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        if (!translating.isTranslating()) {
            return Status.OK_STATUS;
        }
        @NonNull StatisticsManager statisticsManager = this.statisticsService.getManager(project);
        @NonNull StatisticsProvider provider = this.statisticsService.getProvider(project);
        List languages = translating.getInterfaceLanguages();
        Collection<Metric> metrics = this.statisticsService.getMetrics();
        ConcurrentHashMap<IPath, Map> groupBaseValues = new ConcurrentHashMap<IPath, Map>();
        ConcurrentHashMap<IPath, Map> groupValues = new ConcurrentHashMap<IPath, Map>();
        for (GroupProvider groupProvider : this.groupProviderRegistry.get()) {
            Collection<IPath> groups = groupProvider.getParents(path, project);
            for (IPath group : groups) {
                Collection<IPath> resources = groupProvider.getResources(group, project);
                for (IPath resource : resources) {
                    @NonNull Statistics stat = provider.getStatistic(resource);
                    Map baseValues = groupBaseValues.computeIfAbsent(group, k -> new ConcurrentHashMap());
                    Map values = groupValues.computeIfAbsent(group, k -> new ConcurrentHashMap());
                    for (Metric metric : metrics) {
                        baseValues.computeIfAbsent(metric.getID(), k -> 0);
                        baseValues.computeIfPresent(metric.getID(), (k, value) -> metric.getGroupingRule().apply(stat.getMetricValue(metric), (int)value));
                        Map langValue = values.computeIfAbsent(metric.getID(), k -> new ConcurrentHashMap());
                        for (TranslateLanguage language : languages) {
                            langValue.computeIfAbsent(language.getLanguageCode(), k -> 0);
                            langValue.computeIfPresent(language.getLanguageCode(), (k, value) -> metric.getGroupingRule().apply(stat.getMetricValue(metric, language), (int)value));
                        }
                    }
                }
            }
        }
        for (Map.Entry entry : groupBaseValues.entrySet()) {
            Map bValue = (Map)entry.getValue();
            Map values = (Map)groupValues.get(entry.getKey());
            Map<String, Map<String, Float>> groupPercentage = this.computePercentage(bValue, values, languages);
            PersistentStatistics statGroup = new PersistentStatistics(bValue, values, groupPercentage);
            statisticsManager.updateFullStatistic((IPath)entry.getKey(), (Statistics)statGroup);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus computeGroup(IProject project, IPath group, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!project.isAccessible()) {
            return Status.OK_STATUS;
        }
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        if (!translating.isTranslating()) {
            return Status.OK_STATUS;
        }
        @NonNull StatisticsManager statisticsManager = this.statisticsService.getManager(project);
        @NonNull StatisticsProvider statisticsProvider = this.statisticsService.getProvider(project);
        List languages = translating.getInterfaceLanguages();
        Collection<Metric> metrics = this.statisticsService.getMetrics();
        ConcurrentHashMap<String, Integer> totalBaseValues = new ConcurrentHashMap<String, Integer>();
        ConcurrentHashMap<String, Map<String, Integer>> totalValues = new ConcurrentHashMap<String, Map<String, Integer>>();
        for (GroupProvider groupProvider : this.groupProviderRegistry.get()) {
            Collection<IPath> resources = groupProvider.getResources(group, project);
            for (IPath resource : resources) {
                @NonNull Statistics stat = statisticsProvider.getStatistic(resource);
                for (Metric metric : metrics) {
                    totalBaseValues.computeIfAbsent(metric.getID(), k -> 0);
                    totalBaseValues.computeIfPresent(metric.getID(), (k, value) -> metric.getGroupingRule().apply(stat.getMetricValue(metric), (int)value));
                    Map langTotal = totalValues.computeIfAbsent(metric.getID(), k -> new ConcurrentHashMap());
                    for (TranslateLanguage language : languages) {
                        if (!metric.isApplicable(language)) continue;
                        langTotal.computeIfAbsent(language.getLanguageCode(), k -> 0);
                        langTotal.computeIfPresent(language.getLanguageCode(), (k, value) -> metric.getGroupingRule().apply(stat.getMetricValue(metric, language), (int)value));
                    }
                }
            }
            if (!resources.isEmpty()) continue;
            for (Metric metric : metrics) {
                totalBaseValues.computeIfAbsent(metric.getID(), k -> 0);
                Map langTotal = totalValues.computeIfAbsent(metric.getID(), k -> new ConcurrentHashMap());
                for (TranslateLanguage language : languages) {
                    if (!metric.isApplicable(language)) continue;
                    langTotal.computeIfAbsent(language.getLanguageCode(), k -> 0);
                }
            }
        }
        Map<String, Map<String, Float>> totalPercentage = this.computePercentage(totalBaseValues, totalValues, languages);
        PersistentStatistics stat = new PersistentStatistics(totalBaseValues, totalValues, totalPercentage);
        statisticsManager.updateFullStatistic(group, (Statistics)stat);
        return Status.OK_STATUS;
    }

    private Map<String, Integer> computeBaseMetrics(IProject project, Collection<ContextTranslationKey> keys) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (StatisticsComputer computer : this.computerRegistry.get()) {
            result.put(computer.getMetric().getID(), computer.computeBaseValue(project, keys));
        }
        return result;
    }

    private Map<String, Map<String, Integer>> computeMetrics(IProject project, Collection<ContextTranslationKey> keys, Collection<TranslateLanguage> languages) {
        HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>();
        for (StatisticsComputer computer : this.computerRegistry.get()) {
            Metric metric = computer.getMetric();
            Map langResult = result.computeIfAbsent(metric.getID(), k -> new HashMap());
            for (TranslateLanguage language : languages) {
                if (!metric.isApplicable(language)) continue;
                langResult.put(language.getLanguageCode(), computer.computeTranslatedValue(project, keys, language));
            }
        }
        return result;
    }

    private Map<String, Map<String, Float>> computePercentage(Map<String, Integer> baseValues, Map<String, Map<String, Integer>> values, Collection<TranslateLanguage> languages) {
        HashMap<String, Map<String, Float>> result = new HashMap<String, Map<String, Float>>();
        for (Map.Entry<String, Integer> entry : baseValues.entrySet()) {
            Map<String, Integer> langValues = values.get(entry.getKey());
            if (langValues == null) continue;
            Map langResult = result.computeIfAbsent(entry.getKey(), k -> new HashMap());
            for (Map.Entry<String, Integer> langEntry : langValues.entrySet()) {
                int langValue = langEntry.getValue();
                int baseValue = entry.getValue();
                float percentage = 0.0f;
                if (langValue > 0 && baseValue > 0) {
                    percentage = (float)langValue / (float)baseValue * 100.0f;
                }
                langResult.put(langEntry.getKey(), Float.valueOf(percentage));
            }
        }
        return result;
    }

    private void appendGroupValue(Map<IPath, Map<String, Map<String, Integer>>> groupValues, IPath path, Statistics stat, List<TranslateLanguage> languages, IProject project) {
        Collection<Metric> metrics = this.statisticsService.getMetrics();
        for (GroupProvider groupProvider : this.groupProviderRegistry.get()) {
            Collection<IPath> groups = groupProvider.getParents(path, project);
            for (IPath group : groups) {
                Map values = groupValues.computeIfAbsent(group, k -> new ConcurrentHashMap());
                for (Metric metric : metrics) {
                    Map langValue = values.computeIfAbsent(metric.getID(), k -> new ConcurrentHashMap());
                    for (TranslateLanguage language : languages) {
                        if (!metric.isApplicable(language)) continue;
                        langValue.computeIfAbsent(language.getLanguageCode(), k -> 0);
                        langValue.computeIfPresent(language.getLanguageCode(), (k, v) -> metric.getGroupingRule().apply(stat.getMetricValue(metric, language), (int)v));
                    }
                }
            }
        }
    }

    private void appendGroupBase(Map<IPath, Map<String, Integer>> groupBaseValues, IPath path, Statistics stat, IProject project) {
        Collection<Metric> metrics = this.statisticsService.getMetrics();
        for (GroupProvider groupProvider : this.groupProviderRegistry.get()) {
            Collection<IPath> groups = groupProvider.getParents(path, project);
            for (IPath group : groups) {
                Map baseValues = groupBaseValues.computeIfAbsent(group, k -> new ConcurrentHashMap());
                for (Metric metric : metrics) {
                    @NonNull String id = metric.getID();
                    baseValues.computeIfAbsent(id, k -> 0);
                    @NonNull GroupingRule groupingRule = metric.getGroupingRule();
                    baseValues.computeIfPresent(id, (k, v) -> groupingRule.apply(stat.getMetricValue(metric), (int)v));
                }
            }
        }
    }

    private void appendTotalValue(Map<String, Map<String, Integer>> totalValues, Map<String, Map<String, Integer>> values, Collection<TranslateLanguage> languages) {
        for (Metric metric : this.statisticsService.getMetrics()) {
            for (TranslateLanguage language : languages) {
                if (!metric.isApplicable(language)) continue;
                Map langTotal = totalValues.computeIfAbsent(metric.getID(), k -> new ConcurrentHashMap());
                String langCode = language.getLanguageCode();
                int value = values.getOrDefault(metric.getID(), Map.of()).getOrDefault(langCode, 0);
                langTotal.computeIfAbsent(language.getLanguageCode(), k -> 0);
                langTotal.compute(langCode, (? super K k, ? super V current) -> metric.getGroupingRule().apply((int)current, value));
            }
        }
    }

    private void appendTotalBase(Map<String, Integer> totalBaseValues, Map<String, Integer> baseValues) {
        for (Metric metric : this.statisticsService.getMetrics()) {
            @NonNull String id = metric.getID();
            totalBaseValues.computeIfAbsent(id, k -> 0);
            totalBaseValues.compute(id, (? super K k, ? super V value) -> metric.getGroupingRule().apply((int)value, (Integer)baseValues.get(id)));
        }
    }
}

