/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat;

import com.e1c.langtool.internal.stat.StatUtils;
import com.e1c.langtool.stat.GroupProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;

public final class FolderProvider
implements GroupProvider {
    private static final String ID_GROUP = "folder-group";

    @Override
    public String getID() {
        return ID_GROUP;
    }

    @Override
    public IPath getPath(@NonNull Object group, IProject project) {
        if (group instanceof IFolder) {
            return ((IFolder)group).getProjectRelativePath();
        }
        return null;
    }

    @Override
    public Collection<IPath> getParents(IPath path, IProject project) {
        ArrayList<IPath> collection = new ArrayList<IPath>();
        IPath parent = this.getParent(path, project);
        while (!Objects.isNull(parent)) {
            if (parent.isEmpty()) break;
            collection.add(parent);
            parent = this.getParent(parent, project);
        }
        return collection;
    }

    @Override
    public IPath getParent(IPath path, IProject project) {
        IContainer parent = null;
        if (!path.isEmpty()) {
            parent = project.getFile(path).getParent();
        }
        if (parent == null) {
            return null;
        }
        return parent.getProjectRelativePath();
    }

    @Override
    public Collection<IPath> getResources(IPath path, IProject project) {
        return StatUtils.getResources(path, project);
    }
}

