/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat;

import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.stat.Metric;
import com.e1c.langtool.stat.Statistics;
import java.util.Map;
import java.util.Objects;

public class PersistentStatistics
implements Statistics {
    private Map<String, Integer> baseValues;
    private Map<String, Map<String, Integer>> values;
    private Map<String, Map<String, Float>> persentage;

    public PersistentStatistics(Map<String, Integer> baseValues, Map<String, Map<String, Integer>> values, Map<String, Map<String, Float>> persentage) {
        this.baseValues = Objects.requireNonNull(baseValues);
        this.values = Objects.requireNonNull(values);
        this.persentage = Objects.requireNonNull(persentage);
    }

    @Override
    public int getMetricValue(Metric metric) {
        return this.baseValues.getOrDefault(metric.getID(), 0);
    }

    @Override
    public int getMetricValue(Metric metric, TranslateLanguage language) {
        return this.values.getOrDefault(metric.getID(), Map.of()).getOrDefault(language.getLanguageCode(), 0);
    }

    @Override
    public float getMetricPercentage(Metric metric, TranslateLanguage language) {
        return this.persentage.getOrDefault(metric.getID(), Map.of()).getOrDefault(language.getLanguageCode(), Float.valueOf(0.0f)).floatValue();
    }
}

