/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat;

import com._1c.g5.wiring.InjectorAwareServiceRegistrator;
import com._1c.g5.wiring.ServiceInitialization;
import com.e1c.langtool.internal.stat.ExternalDependenciesModule;
import com.e1c.langtool.internal.stat.ServiceModule;
import com.e1c.langtool.stat.ComputerEngine;
import com.e1c.langtool.stat.IExporterRegistry;
import com.e1c.langtool.stat.StatisticsService;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class StatPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.stat";
    private static StatPlugin plugin;
    private static BundleContext context;
    private volatile Injector injector;
    private InjectorAwareServiceRegistrator registrator;

    public static StatPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        StatPlugin.log(StatPlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        super.start(bundleContext);
        plugin = this;
        this.registrator = new InjectorAwareServiceRegistrator(bundleContext, this::getInjector);
        ServiceInitialization.schedule(() -> {
            this.registrator.managedService(StatisticsService.class).activateBeforeRegistration().registerInjected();
            this.registrator.service(ComputerEngine.class).registerInjected();
            this.registrator.service(IExporterRegistry.class).registerInjected();
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        this.registrator.deactivateManagedServices((Plugin)this);
        this.registrator.unregisterServices();
        plugin = null;
        this.injector = null;
        super.stop(bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<StatPlugin> clazz = StatPlugin.class;
        synchronized (StatPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ServiceModule(), new ExternalDependenciesModule(this)});
        }
        catch (Exception e) {
            StatPlugin.log(StatPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }
}

