/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat;

import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.internal.stat.StatPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class StatUtils {
    private StatUtils() {
    }

    public static Collection<IPath> getResources(IPath path, IProject project) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IPath> allFiles = new ArrayList<IPath>();
        Object container = null;
        container = path.isEmpty() ? root.getProject(project.getName()) : project.getFolder(path);
        if (container == null) {
            return Collections.emptyList();
        }
        StatUtils.recursiveFindFiles(allFiles, (IContainer)container);
        return allFiles;
    }

    private static void recursiveFindFiles(Collection<IPath> allFiles, IContainer container) {
        try {
            IResource[] iResources;
            IResource[] iResourceArray = iResources = container.members();
            int n = iResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (!Objects.isNull(TranslationUtils.getTranslationSource((Object)resource))) {
                    allFiles.add(resource.getProjectRelativePath());
                }
                if (resource.getType() == 2) {
                    StatUtils.recursiveFindFiles(allFiles, (IContainer)((IFolder)resource));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            StatPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.e1c.langtool.stat", "Couldn't get members", (Throwable)e));
        }
    }
}

