/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat;

import com.e1c.langtool.internal.stat.StatPlugin;
import com.e1c.langtool.stat.StatisticsComputer;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

@Singleton
public class StatisticsComputerRegistry {
    private static final String ATT_COMPUTER = "computer";
    private static final String ATT_CLASS = "class";
    private static final String EXTENSION_POINT_ID = "com.e1c.langtool.stat.metricComputer";
    private volatile Collection<StatisticsComputer> computerRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<StatisticsComputer> get() {
        if (this.computerRegistry == null) {
            StatisticsComputerRegistry statisticsComputerRegistry = this;
            synchronized (statisticsComputerRegistry) {
                if (this.computerRegistry != null) {
                    return this.computerRegistry;
                }
                this.computerRegistry = this.loadComputerRegistry();
            }
        }
        return this.computerRegistry;
    }

    private Collection<StatisticsComputer> loadComputerRegistry() {
        IConfigurationElement[] config;
        ArrayList<StatisticsComputer> computers = new ArrayList<StatisticsComputer>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String elementName = ce.getName();
            if (elementName.equals(ATT_COMPUTER)) {
                try {
                    StatisticsComputer computer = (StatisticsComputer)ce.createExecutableExtension(ATT_CLASS);
                    computers.add(computer);
                }
                catch (Exception e) {
                    StatPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.e1c.langtool.stat", "Couldn't instantiate extension", (Throwable)e));
                }
            }
            ++n2;
        }
        return Collections.unmodifiableCollection(computers);
    }
}

