/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat;

import com.e1c.langtool.collector.ICollectingCacheChangeListener;
import com.e1c.langtool.collector.ICollectingCacheManager;
import com.e1c.langtool.internal.stat.AsyncRecomputer;
import com.e1c.langtool.internal.stat.CompositeStatisticsManager;
import com.e1c.langtool.internal.stat.CompositeStatisticsProvider;
import com.e1c.langtool.internal.stat.EmptyStatisticsManager;
import com.e1c.langtool.internal.stat.EmptyStatisticsProvider;
import com.e1c.langtool.internal.stat.GroupProviderRegistry;
import com.e1c.langtool.internal.stat.StatisticsComputerRegistry;
import com.e1c.langtool.internal.stat.db.ProjectMetricStorage;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslatingProjectChangeEvent;
import com.e1c.langtool.platform.TranslatingProjectChangeListener;
import com.e1c.langtool.stat.ComputerEngine;
import com.e1c.langtool.stat.GroupProvider;
import com.e1c.langtool.stat.IExporterRegistry;
import com.e1c.langtool.stat.Metric;
import com.e1c.langtool.stat.StatisticsChangeListener;
import com.e1c.langtool.stat.StatisticsComputer;
import com.e1c.langtool.stat.StatisticsManager;
import com.e1c.langtool.stat.StatisticsProvider;
import com.e1c.langtool.stat.StatisticsService;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;

public class StatisticsServiceImpl
implements StatisticsService {
    private static final StatisticsManager EMPTY_MANAGER = new EmptyStatisticsManager();
    private static final StatisticsProvider EMPTY_PROVIDER = new EmptyStatisticsProvider();
    private final ListenerList<StatisticsChangeListener> changeListeners = new ListenerList();
    private final Map<IProject, StatisticsProvider> providers = new ConcurrentHashMap<IProject, StatisticsProvider>();
    private final Map<IProject, CompositeStatisticsManager> managers = new ConcurrentHashMap<IProject, CompositeStatisticsManager>();
    private final Map<IProject, ProjectMetricStorage> storages = new ConcurrentHashMap<IProject, ProjectMetricStorage>();
    private final ITranslatingProjectManager translatingProjectManager;
    private final ICollectingCacheManager collectingCacheManager;
    private final ICollectingCacheChangeListener cacheChangeListener = event -> this.cacheChanged(event.getProject(), event.getPath());
    private final ITranslationStorageManager storageManager;
    private final StatisticsComputerRegistry computerRegistry;
    private final GroupProviderRegistry groupProviderRegistry;
    private final AsyncRecomputer recomputer;
    private final AtomicBoolean autoStart = new AtomicBoolean();
    private final TranslatingProjectChangeListener projectChangeListener = this::projectChanged;
    private final IExporterRegistry exporterRegistry;

    @Inject
    public StatisticsServiceImpl(ITranslatingProjectManager translatingProjectManager, ICollectingCacheManager collectingCacheManager, ITranslationStorageManager storageManager, ComputerEngine engine, GroupProviderRegistry groupProviderRegistryImpl, StatisticsComputerRegistry computerRegistry, IExporterRegistry exporterRegistry) {
        this.translatingProjectManager = translatingProjectManager;
        this.collectingCacheManager = collectingCacheManager;
        this.storageManager = storageManager;
        this.computerRegistry = computerRegistry;
        this.groupProviderRegistry = groupProviderRegistryImpl;
        this.exporterRegistry = exporterRegistry;
        this.recomputer = new AsyncRecomputer(this, engine, this.autoStart);
    }

    public void activate() {
        this.collectingCacheManager.addChangeListener(this.cacheChangeListener);
        this.translatingProjectManager.addPostChangeListener(this.projectChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deactivate() {
        this.collectingCacheManager.removeChangeListener(this.cacheChangeListener);
        this.translatingProjectManager.removePostChangeListener(this.projectChangeListener);
        for (Map.Entry<IProject, ProjectMetricStorage> entry : this.storages.entrySet()) {
            ProjectMetricStorage storage = entry.getValue();
            storage.close();
        }
        this.storages.clear();
        Map<IProject, Object> map = this.managers;
        synchronized (map) {
            this.managers.clear();
        }
        map = this.providers;
        synchronized (map) {
            this.providers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatisticsProvider getProvider(IProject project) {
        if (project == null) {
            return null;
        }
        Map<IProject, StatisticsProvider> map = this.providers;
        synchronized (map) {
            StatisticsProvider provider = this.providers.get(project);
            if (provider == null) {
                ProjectMetricStorage storage = this.storages.computeIfAbsent(project, k -> {
                    @NonNull ITranslatingProject translating = this.translatingProjectManager.getProject(k);
                    if (translating.isTranslating()) {
                        return new ProjectMetricStorage((IProject)k, translating.getInterfaceLanguages());
                    }
                    return null;
                });
                if (storage == null) {
                    return EMPTY_PROVIDER;
                }
                provider = new CompositeStatisticsProvider(project, storage, this);
                this.providers.put(project, provider);
            }
            return provider;
        }
    }

    @Override
    public void addStatisticChangeListener(StatisticsChangeListener l) {
        this.changeListeners.add((Object)l);
        for (Map.Entry<IProject, CompositeStatisticsManager> entry : this.managers.entrySet()) {
            entry.getValue().addStatisticChangeListener(l);
        }
        this.autoStart.set(true);
        this.recomputer.scheduleCompute();
    }

    @Override
    public void removeStatisticChangeListener(StatisticsChangeListener l) {
        this.changeListeners.remove((Object)l);
        for (Map.Entry<IProject, CompositeStatisticsManager> entry : this.managers.entrySet()) {
            entry.getValue().removeStatisticChangeListener(l);
        }
        if (this.changeListeners.isEmpty()) {
            this.autoStart.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatisticsManager getManager(IProject project) {
        if (project == null) {
            return null;
        }
        Map<IProject, CompositeStatisticsManager> map = this.managers;
        synchronized (map) {
            CompositeStatisticsManager manager = this.managers.get(project);
            if (manager == null) {
                ProjectMetricStorage storage = this.storages.computeIfAbsent(project, k -> {
                    @NonNull ITranslatingProject translating = this.translatingProjectManager.getProject(k);
                    if (translating.isTranslating()) {
                        return new ProjectMetricStorage((IProject)k, translating.getInterfaceLanguages());
                    }
                    return null;
                });
                if (storage == null) {
                    return EMPTY_MANAGER;
                }
                manager = new CompositeStatisticsManager(project, storage, this, this.translatingProjectManager, this.storageManager, this.recomputer, this.exporterRegistry);
                for (StatisticsChangeListener l : this.changeListeners) {
                    manager.addStatisticChangeListener(l);
                }
                this.managers.put(project, manager);
            }
            return manager;
        }
    }

    @Override
    public Collection<Metric> getMetrics() {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (StatisticsComputer computer : this.computerRegistry.get()) {
            metrics.add(computer.getMetric());
        }
        return metrics;
    }

    @Override
    public @NonNull Collection<GroupProvider> getGroupProviders() {
        return this.groupProviderRegistry.get();
    }

    private void cacheChanged(IProject project, IPath path) {
        boolean fullProject;
        if (project == null) {
            return;
        }
        boolean bl = fullProject = path == null || path.isEmpty() || path.isRoot();
        if (fullProject) {
            this.recomputer.startRemoveStatistic(project);
            return;
        }
        this.recomputer.addToQueue(project, path);
        if (!this.changeListeners.isEmpty()) {
            this.recomputer.scheduleCompute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectChanged(TranslatingProjectChangeEvent event) {
        TranslatingProjectChangeEvent.EventType type = event.getType();
        IProject project = event.getProject().getProject();
        if (type == TranslatingProjectChangeEvent.EventType.REGISTERED || type == TranslatingProjectChangeEvent.EventType.CHANGED && event.getProject().isTranslating()) {
            this.getManager(project);
        } else {
            if (type == TranslatingProjectChangeEvent.EventType.DEREGISTERED) {
                StatisticsManager manager = this.getManager(project);
                manager.removeStatistic();
                ProjectMetricStorage storage = this.storages.get(project);
                if (storage != null) {
                    storage.delete();
                }
                this.storages.remove(project);
                Map<IProject, Object> map = this.managers;
                synchronized (map) {
                    this.managers.remove(project);
                }
                map = this.providers;
                synchronized (map) {
                    this.providers.remove(project);
                }
            }
            if (type == TranslatingProjectChangeEvent.EventType.CHANGED && !event.getProject().isTranslating()) {
                Map<IProject, CompositeStatisticsManager> manager = this.managers;
                synchronized (manager) {
                    StatisticsManager manager2 = this.managers.remove(project);
                    if (manager2 != null) {
                        manager2.removeStatistic();
                    }
                }
                ProjectMetricStorage storage = this.storages.get(project);
                if (storage != null) {
                    storage.delete();
                }
                this.storages.remove(project);
                Map<IProject, StatisticsProvider> map = this.providers;
                synchronized (map) {
                    this.providers.remove(project);
                }
            }
        }
    }
}

