/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat.db;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.stat.db.MetricPercentage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mapdb.Serializer;

public class MetricPercentageSerializer
implements Serializer<MetricPercentage>,
Serializable {
    private static final long serialVersionUID = 2659625735502075064L;

    public MetricPercentage deserialize(DataInput in, int available) throws IOException {
        int total = in.readInt();
        HashMap<String, Float> result = new HashMap<String, Float>(total);
        int i = 0;
        while (i < total) {
            String key = in.readUTF();
            float value = in.readFloat();
            result.put(key, Float.valueOf(value));
            ++i;
        }
        return new MetricPercentage(result);
    }

    public void serialize(DataOutput out, MetricPercentage data) throws IOException {
        out.writeInt(data.getPercentage().size());
        for (Map.Entry<String, Float> entry : data.getPercentage().entrySet()) {
            String key = entry.getKey();
            if (StringUtils.isNullOrEmpty((String)key)) {
                key = "";
            }
            out.writeUTF(entry.getKey());
            out.writeFloat(entry.getValue().floatValue());
        }
    }

    public int fixedSize() {
        return -1;
    }
}

