/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat.db;

import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.internal.stat.StatPlugin;
import com.e1c.langtool.internal.stat.db.MetricValues;
import com.e1c.langtool.internal.stat.db.MetricValuesSerializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.IStatus;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;

public abstract class MetricStorage {
    private static final String TOTAL_VALUES = "totalValues";
    private static final String VERSION_KEY = "version";
    private static final int STORAGE_VERSION = 2;
    protected final ReadWriteLock initLock = new ReentrantReadWriteLock(false);
    private volatile boolean initialized;
    private final File dbFile;
    private DB db;
    private Map<Long, MetricValues> values;
    private Atomic.Var<MetricValues> totalValues;

    public MetricStorage(File dbFile) {
        this.dbFile = dbFile;
    }

    public MetricValues getTotalValues() {
        this.checkOrOpen();
        this.initLock.readLock().lock();
        try {
            if (!this.initialized) {
                MetricValues metricValues = new MetricValues();
                return metricValues;
            }
            MetricValues metricValues = (MetricValues)this.totalValues.get();
            return metricValues;
        }
        finally {
            this.initLock.readLock().unlock();
        }
    }

    public void setTotalValues(MetricValues totalValues) {
        this.checkOrOpen();
        this.initLock.readLock().lock();
        try {
            this.totalValues.set((Object)totalValues);
        }
        finally {
            this.initLock.readLock().unlock();
        }
    }

    public MetricValues getMetricValues(long id) {
        this.checkOrOpen();
        this.initLock.readLock().lock();
        try {
            if (!this.initialized) {
                return null;
            }
            MetricValues metricValues = this.values.get(id);
            return metricValues;
        }
        finally {
            this.initLock.readLock().unlock();
        }
    }

    public MetricValues putMetricValues(long id, MetricValues data) {
        this.checkOrOpen();
        this.initLock.readLock().lock();
        try {
            MetricValues result = this.values.put(id, data);
            if (result != null) {
                this.setTotalValues(new MetricValues());
            }
            MetricValues metricValues = result;
            return metricValues;
        }
        finally {
            this.initLock.readLock().unlock();
        }
    }

    public MetricValues removeMetricValues(long id) {
        this.checkOrOpen();
        this.initLock.readLock().lock();
        try {
            MetricValues result = this.values.remove(id);
            if (result != null) {
                this.setTotalValues(new MetricValues());
            }
            MetricValues metricValues = result;
            return metricValues;
        }
        finally {
            this.initLock.readLock().unlock();
        }
    }

    public void open() {
        if (this.initialized) {
            return;
        }
        this.initLock.writeLock().lock();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(MetricStorage.class.getClassLoader());
            this.doOpen();
            this.initialized = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
            this.initLock.writeLock().unlock();
        }
    }

    public void close() {
        this.initLock.writeLock().lock();
        try {
            this.doClose();
            this.initialized = false;
        }
        finally {
            this.initLock.writeLock().unlock();
        }
    }

    public void delete() {
        this.initLock.writeLock().lock();
        try {
            this.close();
            TranslationUtils.cleanUpMabDbFiles((File)this.dbFile);
        }
        finally {
            this.initLock.writeLock().unlock();
        }
    }

    private void doClose() {
        this.beforeClose();
        this.values = null;
        this.totalValues = null;
        if (this.db != null && !this.db.isClosed()) {
            this.db.close();
        }
        this.db = null;
    }

    protected void beforeClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkOrOpen() {
        this.initLock.readLock().lock();
        try {
            if (this.initialized) {
                return;
            }
        }
        finally {
            this.initLock.readLock().unlock();
        }
        this.initLock.writeLock().lock();
        try {
            MetricStorage metricStorage = this;
            synchronized (metricStorage) {
                block20: {
                    if (!this.initialized) break block20;
                    return;
                }
                try {
                    this.open();
                }
                catch (Throwable e) {
                    String message = MessageFormat.format("Restart statistics storage because cannot open file: {0}", this.dbFile);
                    IStatus status = StatPlugin.createErrorStatus(message, e);
                    StatPlugin.log(status);
                    try {
                        this.close();
                        this.delete();
                        this.open();
                    }
                    catch (Exception e2) {
                        StatPlugin.logError(e2);
                    }
                }
                if (!this.initialized) {
                    try {
                        this.delete();
                    }
                    catch (Exception e2) {
                        StatPlugin.logError(e2);
                    }
                }
            }
        }
        finally {
            this.initLock.writeLock().unlock();
        }
    }

    private void doOpen() {
        try {
            Files.createDirectories(this.dbFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            StatPlugin.logError(e);
        }
        this.db = this.openDb(this.dbFile);
        Atomic.Integer storageVersion = this.db.getAtomicInteger(VERSION_KEY);
        if (storageVersion.get() > 0 && storageVersion.get() != 2) {
            this.delete();
            this.db = this.openDb(this.dbFile);
            storageVersion = this.db.getAtomicInteger(VERSION_KEY);
        }
        storageVersion.set(2);
        MetricValuesSerializer valueSerializer = new MetricValuesSerializer();
        this.values = this.db.createTreeMap("values").keySerializer(BTreeKeySerializer.ZERO_OR_POSITIVE_LONG).valueSerializer((Serializer)valueSerializer).valuesOutsideNodesEnable().counterEnable().makeOrGet();
        this.totalValues = this.db.exists(TOTAL_VALUES) ? this.db.getAtomicVar(TOTAL_VALUES) : this.db.createAtomicVar(TOTAL_VALUES, (Object)new MetricValues(), (Serializer)valueSerializer);
        this.afterOpenDb(this.db);
    }

    protected void afterOpenDb(DB db) {
    }

    private DB openDb(File file) {
        return DBMaker.newFileDB((File)file).transactionDisable().closeOnJvmShutdown().cacheLRUEnable().snapshotEnable().make();
    }
}

