/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat.db;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.stat.db.MetricValues;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mapdb.Serializer;

public class MetricValuesSerializer
implements Serializer<MetricValues>,
Serializable {
    private static final long serialVersionUID = -3342800361032291312L;

    public MetricValues deserialize(DataInput in, int available) throws IOException {
        int total = in.readInt();
        HashMap<String, Integer> result = new HashMap<String, Integer>(total);
        int i = 0;
        while (i < total) {
            String key = in.readUTF();
            int value = in.readInt();
            result.put(key, value);
            ++i;
        }
        return new MetricValues(result);
    }

    public void serialize(DataOutput out, MetricValues data) throws IOException {
        Map<String, Integer> values = data.getValues();
        int total = values.size();
        out.writeInt(total);
        for (Map.Entry<String, Integer> entry : values.entrySet()) {
            String key = entry.getKey();
            if (StringUtils.isNullOrEmpty((String)key)) {
                key = "";
            }
            out.writeUTF(key);
            out.writeInt(entry.getValue());
        }
    }

    public int fixedSize() {
        return -1;
    }
}

