/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat.db;

import com.e1c.langtool.collector.PathSerializer;
import com.e1c.langtool.internal.stat.db.MetricStorage;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.Serializer;

public class ResourceIndexMetricStorage
extends MetricStorage {
    private Atomic.Long lastId;
    private Map<IPath, Long> resources;

    public ResourceIndexMetricStorage(File file) {
        super(file);
    }

    public Map<IPath, Long> getResources() {
        this.checkOrOpen();
        this.initLock.readLock().lock();
        try {
            Map<IPath, Long> map = this.resources;
            return map;
        }
        finally {
            this.initLock.readLock().unlock();
        }
    }

    public Long getResourceId(IPath path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        this.checkOrOpen();
        this.initLock.readLock().lock();
        try {
            Long l = this.resources.get(path);
            return l;
        }
        finally {
            this.initLock.readLock().unlock();
        }
    }

    public long getResourceIdOrNew(IPath path) {
        if (path == null || path.isEmpty()) {
            return 0L;
        }
        this.checkOrOpen();
        this.initLock.readLock().lock();
        try {
            long l = this.resources.computeIfAbsent(path, p -> this.newId());
            return l;
        }
        finally {
            this.initLock.readLock().unlock();
        }
    }

    @Override
    protected void afterOpenDb(DB db) {
        this.lastId = db.getAtomicLong("lastId");
        PathSerializer pathSerializer = new PathSerializer();
        this.resources = db.createHashMap("resources").keySerializer((Serializer)pathSerializer).valueSerializer(Serializer.LONG).counterEnable().makeOrGet();
    }

    @Override
    protected void beforeClose() {
        this.resources = null;
        this.lastId = null;
        super.beforeClose();
    }

    private Long newId() {
        return this.lastId.incrementAndGet();
    }
}

