/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat.export;

import com.e1c.langtool.common.Pair;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.stat.FormatterUtil;
import com.e1c.langtool.stat.IStatisticsExporter;
import com.e1c.langtool.stat.Metric;
import com.e1c.langtool.stat.Statistics;
import com.e1c.langtool.stat.StatisticsProvider;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class CsvExporter
implements IStatisticsExporter {
    private static final String DELIMITER = ",";

    @Override
    public void export(Path path, StatisticsProvider provider, Collection<TranslateLanguage> languages, Collection<Metric> metrics) throws IOException {
        Statistics totalValueStatistic = provider.getTotalValueStatistic();
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path.toString()), StandardCharsets.UTF_8));){
            writer.write("Path,Language");
            for (Metric metric : metrics) {
                writer.write(DELIMITER + metric.getTitle() + " Source");
                writer.write(",Translation");
                writer.write(",%");
            }
            writer.newLine();
            List<Pair<IPath, Statistics>> sortedPairs = this.sortStatisticsByPath(provider.statisticsIterator());
            for (Pair<IPath, Statistics> pair : sortedPairs) {
                IPath resourcePath = (IPath)pair.getKey();
                Statistics statistics = (Statistics)pair.getValue();
                for (TranslateLanguage language : languages) {
                    String languageName = language.getName();
                    StringBuilder csvLine = new StringBuilder(resourcePath.toString());
                    csvLine.append(DELIMITER);
                    csvLine.append(languageName);
                    for (Metric metric : metrics) {
                        int sourceValue = statistics.getMetricValue(metric);
                        int translatedValue = statistics.getMetricValue(metric, language);
                        float percentTranslatedValue = statistics.getMetricPercentage(metric, language);
                        csvLine.append(DELIMITER).append(sourceValue).append(DELIMITER).append(translatedValue).append(DELIMITER).append(FormatterUtil.format(percentTranslatedValue));
                    }
                    writer.write(csvLine.toString());
                    writer.newLine();
                }
            }
            for (TranslateLanguage language : languages) {
                StringBuilder totalLine = new StringBuilder("Total");
                totalLine.append(DELIMITER);
                totalLine.append(language.getName());
                for (Metric metric : metrics) {
                    int sourceValue = totalValueStatistic.getMetricValue(metric);
                    int translatedValue = totalValueStatistic.getMetricValue(metric, language);
                    float percentTranslatedValue = totalValueStatistic.getMetricPercentage(metric, language);
                    totalLine.append(DELIMITER).append(sourceValue).append(DELIMITER).append(translatedValue).append(DELIMITER).append(FormatterUtil.format(percentTranslatedValue));
                }
                writer.write(totalLine.toString());
                writer.newLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

