/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat.export;

import com.e1c.langtool.common.Pair;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.stat.FormatterUtil;
import com.e1c.langtool.stat.IStatisticsExporter;
import com.e1c.langtool.stat.Metric;
import com.e1c.langtool.stat.Statistics;
import com.e1c.langtool.stat.StatisticsProvider;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class JsonExporter
implements IStatisticsExporter {
    @Override
    public void export(Path path, StatisticsProvider provider, Collection<TranslateLanguage> languages, Collection<Metric> metrics) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path.toString()), StandardCharsets.UTF_8));){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonObject rootObject = new JsonObject();
            JsonArray dataArray = new JsonArray();
            List<Pair<IPath, Statistics>> sortPairsByPath = this.sortStatisticsByPath(provider.statisticsIterator());
            for (Pair<IPath, Statistics> pair : sortPairsByPath) {
                IPath resourcePath = (IPath)pair.getKey();
                Statistics statistics = (Statistics)pair.getValue();
                for (TranslateLanguage language : languages) {
                    JsonObject dataObject = new JsonObject();
                    dataObject.addProperty("Path", resourcePath.toString());
                    dataObject.addProperty("Language", language.getName());
                    JsonObject metricsObject = new JsonObject();
                    for (Metric metric : metrics) {
                        int sourceValue = statistics.getMetricValue(metric);
                        int translatedValue = statistics.getMetricValue(metric, language);
                        float procentTranslatedValue = statistics.getMetricPercentage(metric, language);
                        JsonObject metricObject = new JsonObject();
                        metricObject.addProperty("SourceValue", (Number)sourceValue);
                        metricObject.addProperty("TranslatedValue", (Number)translatedValue);
                        metricObject.addProperty("Percentage", FormatterUtil.format(procentTranslatedValue));
                        metricsObject.add(metric.getTitle(), (JsonElement)metricObject);
                    }
                    dataObject.add("Metrics", (JsonElement)metricsObject);
                    dataArray.add((JsonElement)dataObject);
                }
            }
            for (TranslateLanguage language : languages) {
                JsonObject totalObject = new JsonObject();
                totalObject.addProperty("Path", "Total");
                totalObject.addProperty("Language", language.getName());
                JsonObject totalMetricsObject = new JsonObject();
                for (Metric metric : metrics) {
                    int sourceValue = provider.getTotalValueStatistic().getMetricValue(metric);
                    int translatedValue = provider.getTotalValueStatistic().getMetricValue(metric, language);
                    float procentTranslatedValue = provider.getTotalValueStatistic().getMetricPercentage(metric, language);
                    JsonObject metricObject = new JsonObject();
                    metricObject.addProperty("SourceValue", (Number)sourceValue);
                    metricObject.addProperty("TranslatedValue", (Number)translatedValue);
                    metricObject.addProperty("Percentage", FormatterUtil.format(procentTranslatedValue));
                    totalMetricsObject.add(metric.getTitle(), (JsonElement)metricObject);
                }
                totalObject.add("Metrics", (JsonElement)totalMetricsObject);
                dataArray.add((JsonElement)totalObject);
            }
            rootObject.add("Data", (JsonElement)dataArray);
            String jsonString = gson.toJson((JsonElement)rootObject);
            writer.write(jsonString);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

