/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.qfix;

import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.dcs.model.core.DcsFactory;
import com._1c.g5.v8.dt.dcs.model.core.LocalString;
import com._1c.g5.v8.dt.dcs.model.core.Presentation;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaDataSetField;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaDataSetFieldFolder;
import com._1c.g5.v8.dt.dcs.model.schema.DataSetField;
import com.e1c.g5.v8.dt.check.qfix.IFixSession;
import com.e1c.g5.v8.dt.check.qfix.components.BasicModelFixContext;
import com.e1c.g5.v8.dt.check.qfix.components.QuickFix;
import com.e1c.g5.v8.dt.check.qfix.components.SingleVariantModelBasicFix;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.dcs.qfix.Messages;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EStructuralFeature;

@QuickFix(checkId="dcs-field-title", supplierId="com.e1c.langtool.v8.dt.dcs")
public class DataSetFieldPresentationCreateFix
extends SingleVariantModelBasicFix<DataSetField> {
    private final IV8ProjectManager v8ProjectManager;

    @Inject
    public DataSetFieldPresentationCreateFix(IV8ProjectManager v8ProjectManager) {
        this.v8ProjectManager = v8ProjectManager;
    }

    protected void configureFix(SingleVariantModelBasicFix.FixConfigurer configurer) {
        configurer.description(Messages.DataSetFieldPresentationCreateFix_decription);
    }

    protected void applyChanges(DataSetField object, EStructuralFeature feature, BasicModelFixContext context, IFixSession session) {
        String name;
        if (object instanceof DataCompositionSchemaDataSetField) {
            name = ((DataCompositionSchemaDataSetField)object).getDataPath();
        } else if (object instanceof DataCompositionSchemaDataSetFieldFolder) {
            name = ((DataCompositionSchemaDataSetFieldFolder)object).getDataPath();
        } else {
            return;
        }
        if (StringUtils.isBlank((String)name)) {
            return;
        }
        IV8Project v8Project = this.v8ProjectManager.getProject(session.getDtProject());
        String langCode = null;
        if (v8Project.getDefaultLanguage() != null) {
            langCode = v8Project.getDefaultLanguage().getLanguageCode();
        }
        LocalString lws = DcsFactory.eINSTANCE.createLocalString();
        String str = StringUtils.nameToText((String)name);
        if (langCode != null) {
            lws.getContent().put((Object)langCode, (Object)str);
        }
        Presentation title = DcsFactory.eINSTANCE.createPresentation();
        title.setLocalValue(lws);
        object.eSet(feature, (Object)title);
    }
}

