/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.translator;

import com._1c.g5.v8.dt.dcs.model.core.DataCompositionField;
import com._1c.g5.v8.dt.dcs.path.DcsPath;
import com._1c.g5.v8.dt.dcs.path.DcsPathException;
import com._1c.g5.v8.dt.dcs.settings.DcsAvailableFieldInfo;
import com._1c.g5.v8.dt.dcs.settings.DcsAvailableSettingsSourceException;
import com._1c.g5.v8.dt.dcs.settings.DcsAvailableSettingsSourceForSchema;
import com.e1c.langtool.v8.dt.internal.dcs.DcsPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.WrappedException;

public class DcsAvailableFields {
    public static final String AUTO_FIELD_PATH = "{19A414D5-35DE-4dc6-92E2-7C97BBCCB551}";
    private DcsAvailableSettingsSourceForSchema source;
    private DcsAvailableSettingsSourceForSchema.FieldUse use;
    private Map<String, DcsAvailableFieldInfo> availableFields = new HashMap<String, DcsAvailableFieldInfo>();

    public DcsAvailableFields(DcsAvailableSettingsSourceForSchema source, DcsAvailableSettingsSourceForSchema.FieldUse use) {
        this.source = source;
        this.use = use;
    }

    public DcsAvailableFieldInfo findField(DataCompositionField field) {
        if (field == null) {
            return null;
        }
        String name = field.getValue();
        if (this.availableFields.containsKey(name)) {
            return this.availableFields.get(name);
        }
        if (this.source == null) {
            return null;
        }
        try {
            DcsPath path = new DcsPath(name);
            this.computeForChild(path);
        }
        catch (DcsPathException e) {
            throw new WrappedException((Exception)((Object)e));
        }
        if (!this.availableFields.containsKey(name)) {
            this.availableFields.put(name, null);
        }
        return this.availableFields.get(name);
    }

    public DcsAvailableFieldInfo getFieldInfo(DcsPath path) {
        if (path.isEmpty()) {
            return null;
        }
        String name = path.toString();
        if (this.availableFields.containsKey(name)) {
            return this.availableFields.get(name);
        }
        if (this.source == null) {
            return null;
        }
        try {
            DcsAvailableFieldInfo fieldInfo = new DcsAvailableFieldInfo();
            this.source.getFieldInfo(new DcsPath(), this.use, path, fieldInfo);
            if (fieldInfo.dataPath[0] != null) {
                this.availableFields.put(fieldInfo.dataPath[0].toString(), fieldInfo);
            }
            if (fieldInfo.dataPath[1] != null) {
                this.availableFields.put(fieldInfo.dataPath[1].toString(), fieldInfo);
            }
            if (fieldInfo.dataPath[0] == null && fieldInfo.dataPath[1] == null) {
                this.computeForChild(path);
            }
            return this.availableFields.get(name);
        }
        catch (DcsPathException | DcsAvailableSettingsSourceException e) {
            DcsPlugin.logError(e);
            this.availableFields.put(name, null);
            return null;
        }
    }

    private void computeForChild(DcsPath path) throws DcsPathException {
        ArrayList childFields = new ArrayList();
        try {
            DcsPath parentPath = path.nearParentPath();
            this.source.getChildFields(new DcsPath(), this.use, parentPath, childFields, 1, DcsAvailableSettingsSourceForSchema.OrderType.eOBTitle, true);
        }
        catch (DcsAvailableSettingsSourceException e) {
            throw new WrappedException((Exception)((Object)e));
        }
        for (DcsAvailableFieldInfo fieldInfo : childFields) {
            if (fieldInfo.dataPath[0] != null) {
                this.availableFields.put(fieldInfo.dataPath[0].toString(), fieldInfo);
            }
            if (fieldInfo.dataPath[1] == null) continue;
            this.availableFields.put(fieldInfo.dataPath[1].toString(), fieldInfo);
        }
    }
}

