/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.translator;

import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.bm.index.emf.IBmEmfIndexManager;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.dcs.DcsPlugin;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchema;
import com._1c.g5.v8.dt.dcs.settings.DcsAvailableSettingsSourceException;
import com._1c.g5.v8.dt.dcs.settings.DcsAvailableSettingsSourceForSchema;
import com._1c.g5.v8.dt.dcs.settings.SettingsContext;
import com._1c.g5.v8.dt.md.typeinfo.IMdTypeIndex;
import com.e1c.langtool.v8.dt.dcs.translator.DcsAvailableFields;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

@Singleton
public class DcsAvailableFieldsService {
    private final IV8ProjectManager v8ProjectManager;
    private final IMdTypeIndex mdTypeIndex;
    private final IBmModelManager bmModelManager;
    private final IBmEmfIndexManager emfIndexManager;

    @Inject
    public DcsAvailableFieldsService(IV8ProjectManager v8ProjectManager, IMdTypeIndex mdTypeIndex, IBmModelManager bmModelManager, IBmEmfIndexManager emfIndexManager) {
        this.v8ProjectManager = v8ProjectManager;
        this.mdTypeIndex = mdTypeIndex;
        this.bmModelManager = bmModelManager;
        this.emfIndexManager = emfIndexManager;
    }

    public DcsAvailableFields getDcsAvailableFields(DataCompositionSchema schema) {
        DcsAvailableFieldsAdapter adapter = this.getOrCreateAdapter(schema);
        return adapter.getDcsAvailableFields();
    }

    private DcsAvailableFieldsAdapter getOrCreateAdapter(DataCompositionSchema schema) {
        DcsAvailableFieldsAdapter adapter = (DcsAvailableFieldsAdapter)EcoreUtil.getExistingAdapter((Notifier)schema, DcsAvailableFieldsAdapter.class);
        if (adapter == null) {
            adapter = new DcsAvailableFieldsAdapter();
            schema.eAdapters().add((Object)adapter);
            adapter.setSchema(schema);
        }
        return adapter;
    }

    private final class DcsAvailableFieldsAdapter
    implements Adapter {
        private DcsAvailableSettingsSourceForSchema source;
        private DataCompositionSchema schema;
        private DcsAvailableFields availableFields;

        private DcsAvailableFieldsAdapter() {
        }

        public void notifyChanged(Notification notification) {
        }

        public void setSchema(DataCompositionSchema schema) {
            this.schema = schema;
        }

        private DcsAvailableSettingsSourceForSchema getDcsAvailableSettingsSourceForSchema() {
            if (this.source == null) {
                DcsPlugin.getDefault().getDcsDataSetInfoLocalQueryCache().clearAll();
                IV8Project v8project = DcsAvailableFieldsService.this.v8ProjectManager.getProject((EObject)this.schema);
                IBmModel bmModel = DcsAvailableFieldsService.this.bmModelManager.getModel(v8project.getDtProject());
                SettingsContext context = new SettingsContext(v8project.getDtProject(), bmModel, DcsAvailableFieldsService.this.mdTypeIndex, DcsAvailableFieldsService.this.emfIndexManager);
                this.source = new DcsAvailableSettingsSourceForSchema(context);
                try {
                    this.source.init(v8project, this.schema, v8project.getDefaultLanguage().getLanguageCode(), v8project.getScriptVariant().getValue(), v8project.getVersion());
                }
                catch (DcsAvailableSettingsSourceException e) {
                    com.e1c.langtool.v8.dt.internal.dcs.DcsPlugin.logError(e);
                }
            }
            return this.source;
        }

        public DcsAvailableFields getDcsAvailableFields() {
            if (this.availableFields == null) {
                this.availableFields = new DcsAvailableFields(this.getDcsAvailableSettingsSourceForSchema(), DcsAvailableSettingsSourceForSchema.FieldUse.eSelect);
            }
            return this.availableFields;
        }

        public Notifier getTarget() {
            return this.schema;
        }

        public void setTarget(Notifier newTarget) {
            if (newTarget instanceof DataCompositionSchema) {
                this.schema = (DataCompositionSchema)newTarget;
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == this.getClass();
        }
    }
}

