/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.translator;

import com._1c.g5.v8.dt.bm.xtext.IDependentModelProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.dcs.expressions.model.Expressions;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.dcs.expressions.translator.DcsExprTextProcessor;
import com.e1c.langtool.v8.dt.dcs.settings.impl.ExpressionsField;
import com.e1c.langtool.v8.dt.internal.dcs.DcsPlugin;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.util.CancelIndicator;

public class DcsExprFeatureTranslationProvider
implements IComputedStringFeatureTranslationProvider {
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IDependentModelProvider dependentModelProvider;

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        return ExpressionsField.hasExpressionFeature(object) && ExpressionsField.isExpression(stringFeature);
    }

    public boolean isSupported(EObject object) {
        return ExpressionsField.hasExpressionFeature(object);
    }

    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        if (!ExpressionsField.isExpression(stringFeature)) {
            return null;
        }
        Object value = object.eGet(stringFeature.getEFeature());
        if (value instanceof String && StringUtils.isNotEmpty((String)((String)value))) {
            IFile file = this.resourceLookup.getPlatformResource(object);
            if (file == null) {
                return null;
            }
            IPath basePath = file.getProjectRelativePath().removeFileExtension().addFileExtension("dcsexpr");
            Expressions expr = (Expressions)this.dependentModelProvider.getDependentModel(object, stringFeature.getEFeature(), basePath, CancelIndicator.NullImpl);
            if (expr == null) {
                return null;
            }
            DcsExprTextProcessor processor = DcsExprTextProcessor.create((IProjectTranslationProvider)translationProvider, (Expressions)expr);
            try {
                processor.process((IProgressMonitor)new NullProgressMonitor());
                String string = processor.getText();
                return string;
            }
            catch (Exception e) {
                DcsPlugin.logError(e);
            }
            finally {
                this.dependentModelProvider.unload((EObject)expr);
            }
        }
        return null;
    }
}

