/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.translator;

import com._1c.g5.v8.dt.dcs.model.core.DataCompositionField;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchema;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaCalculatedField;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaParameter;
import com._1c.g5.v8.dt.dcs.model.schema.DataSetField;
import com._1c.g5.v8.dt.dcs.model.schema.NestedDataCompositionSchema;
import com._1c.g5.v8.dt.dcs.model.settings.DataCompositionNestedObjectSettings;
import com._1c.g5.v8.dt.dcs.model.settings.DataCompositionSettings;
import com._1c.g5.v8.dt.dcs.model.settings.UserField;
import com._1c.g5.v8.dt.dcs.path.DcsPath;
import com._1c.g5.v8.dt.dcs.path.DcsPathBase;
import com._1c.g5.v8.dt.dcs.path.DcsPathException;
import com._1c.g5.v8.dt.dcs.path.DcsPathPart;
import com._1c.g5.v8.dt.dcs.settings.DcsAvailableFieldInfo;
import com._1c.g5.v8.dt.mcore.FieldSource;
import com._1c.g5.v8.dt.mcore.StringValue;
import com._1c.g5.v8.dt.metadata.dbview.DbViewFieldDef;
import com._1c.g5.v8.dt.metadata.mdclass.DbObjectTabularSection;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.dcs.settings.DcsFeatureSettings;
import com.e1c.langtool.v8.dt.dcs.translator.AbstractFieldProvider;
import com.e1c.langtool.v8.dt.dcs.translator.DcsAvailableFields;
import com.e1c.langtool.v8.dt.dcs.translator.DcsAvailableFieldsService;
import com.e1c.langtool.v8.dt.internal.dcs.DcsPlugin;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ModelNameTranslationCache;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;

public class FieldTranslationProvider
extends AbstractFieldProvider
implements IComputedStringFeatureTranslationProvider {
    private static final DcsPath DCS_PATH_PARAMERTERS;
    private final INamedEObjectNameProvider namedEObjectNameProvider;
    private final DcsAvailableFieldsService dcsAvailableField;

    static {
        DcsPath path;
        try {
            path = new DcsPath("DataParameters");
        }
        catch (DcsPathException e) {
            path = null;
            DcsPlugin.logError(e);
        }
        DCS_PATH_PARAMERTERS = path;
    }

    @Inject
    public FieldTranslationProvider(INamedEObjectNameProvider namedEObjectNameProvider, DcsAvailableFieldsService dcsAvailableField) {
        this.namedEObjectNameProvider = namedEObjectNameProvider;
        this.dcsAvailableField = dcsAvailableField;
    }

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        if (!stringFeature.equals(DcsFeatureSettings.Literals.DATA_COMPOSITION_FIELD__VALUE) && !stringFeature.equals(McoreFeatureSettings.Literals.STRING_VALUE__VALUE)) {
            return false;
        }
        String value = (String)object.eGet(stringFeature.getEFeature());
        if (value == null) {
            return false;
        }
        DataCompositionSettings settings = (DataCompositionSettings)EcoreUtil2.getContainerOfType((EObject)object, DataCompositionSettings.class);
        if (settings != null && this.hasUserFields(settings, value)) {
            return true;
        }
        DataCompositionSchema schema = this.getSchema(object, settings);
        if (schema == null) {
            return false;
        }
        if (this.hasCalculatedFields(schema, value)) {
            return true;
        }
        if (this.hasDataSetField(schema, value)) {
            return true;
        }
        String[] segments = value.split("\\.");
        if (segments.length < 2) {
            return false;
        }
        if (object instanceof DataCompositionField) {
            DataCompositionField field = (DataCompositionField)object;
            try {
                DcsAvailableFieldInfo fieldInfo = this.dcsAvailableField.getDcsAvailableFields(schema).findField(field);
                return fieldInfo != null;
            }
            catch (Throwable e) {
                DcsPlugin.logError(e);
                return false;
            }
        }
        if (object instanceof StringValue) {
            DcsPath path;
            try {
                path = new DcsPath(value);
            }
            catch (DcsPathException e) {
                return false;
            }
            try {
                DcsAvailableFieldInfo fieldInfo = this.dcsAvailableField.getDcsAvailableFields(schema).getFieldInfo(path);
                return fieldInfo != null;
            }
            catch (Throwable e) {
                DcsPlugin.logError(e);
                return false;
            }
        }
        return false;
    }

    private boolean hasUserFields(DataCompositionSettings settings, String fieldName) {
        if (settings.getUserFields() == null) {
            return false;
        }
        return settings.getUserFields().getItems().stream().anyMatch(field -> field.getDataPath().equals(fieldName));
    }

    public boolean isSupported(EObject object) {
        return object instanceof DataCompositionField || object instanceof StringValue && object.eResource() != null && !object.eResource().getContents().isEmpty() && object.eResource().getContents().get(0) instanceof DataCompositionSchema;
    }

    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        int lang;
        Optional<UserField> userField;
        if (!stringFeature.equals(DcsFeatureSettings.Literals.DATA_COMPOSITION_FIELD__VALUE) && !stringFeature.equals(McoreFeatureSettings.Literals.STRING_VALUE__VALUE)) {
            return null;
        }
        String value = (String)object.eGet(stringFeature.getEFeature());
        if (value == null) {
            return null;
        }
        DataCompositionSettings settings = (DataCompositionSettings)EcoreUtil2.getContainerOfType((EObject)object, DataCompositionSettings.class);
        if (settings != null && (userField = this.getUserFields(settings, value)).isPresent()) {
            return translationProvider.getTranslation((EObject)userField.get(), DcsFeatureSettings.Literals.USER_FIELD__DATA_PATH, language);
        }
        DataCompositionSchema schema = this.getSchema(object, settings);
        if (schema == null) {
            return null;
        }
        Optional<DataCompositionSchemaCalculatedField> calc = this.getCalculatedFields(schema, value);
        if (calc.isPresent()) {
            return translationProvider.getTranslation((EObject)calc.get(), DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_CALCULATED_FIELD__DATA_PATH, language);
        }
        Optional<DataSetField> dataSetField = this.getDataSetField(schema, value);
        if (dataSetField.isPresent()) {
            return this.getDataSetFieldTranslation(dataSetField.get(), translationProvider, language);
        }
        try {
            DcsPath segments = new DcsPath(value);
            if (segments.nearParentPath().isEmpty()) {
                return null;
            }
        }
        catch (DcsPathException e2) {
            DcsPlugin.logError(e2);
            return null;
        }
        DcsAvailableFields dcsAvailableFields = this.dcsAvailableField.getDcsAvailableFields(schema);
        DcsAvailableFieldInfo fieldInfo = null;
        if (object instanceof DataCompositionField) {
            DataCompositionField field = (DataCompositionField)object;
            fieldInfo = dcsAvailableFields.findField(field);
        } else if (object instanceof StringValue) {
            DcsPath path;
            try {
                path = new DcsPath(value);
            }
            catch (DcsPathException e) {
                return null;
            }
            fieldInfo = this.dcsAvailableField.getDcsAvailableFields(schema).getFieldInfo(path);
        } else {
            return null;
        }
        if (fieldInfo == null) {
            return null;
        }
        int sourceLang = lang = translationProvider.getProject().getScriptVariant().getValue();
        if (translationProvider.getProject().isChangeScriptVariant()) {
            int n = sourceLang = lang == 0 ? 1 : 0;
        }
        if (fieldInfo.dataPath[sourceLang] == null || fieldInfo.dataPath[lang] == null) {
            return null;
        }
        ArrayList parts = Lists.newArrayList();
        ArrayList translatedParts = Lists.newArrayList();
        try {
            if (!fieldInfo.dataPath[sourceLang].splitNotSingle((List)parts) || !fieldInfo.dataPath[lang].splitNotSingle((List)translatedParts)) {
                return null;
            }
        }
        catch (DcsPathException e) {
            DcsPlugin.logError(e);
            return null;
        }
        DcsPath translation = new DcsPath();
        try {
            DcsPath path = new DcsPath();
            FieldInfo current = null;
            int i = 0;
            while (i < parts.size()) {
                DcsPathPart part = (DcsPathPart)parts.get(i);
                DcsAvailableFieldInfo pathFieldInfo = dcsAvailableFields.getFieldInfo(path = path.append(part));
                if (pathFieldInfo == null) {
                    translation = translation.append((DcsPathPart)translatedParts.get(i));
                } else {
                    current = new FieldInfo(current, pathFieldInfo);
                    DcsPath translatedPart = null;
                    translation = current.parent != null && current.parent.info.isFolder && (translatedPart = this.getTranslation(translationProvider, language, schema, current, (DcsPathBase)path)) != null ? new DcsPath(translatedPart.toString()) : ((translatedPart = this.getTranslation(translationProvider, language, schema, current, (DcsPathBase)part)) != null ? translation.append(translatedPart) : translation.append((DcsPathPart)translatedParts.get(i)));
                }
                ++i;
            }
        }
        catch (DcsPathException e1) {
            DcsPlugin.logError(e1);
            return null;
        }
        return translation.toString();
    }

    private DataCompositionSchema getSchema(EObject object, DataCompositionSettings settings) {
        DataCompositionSchema schema = null;
        EObject e = object;
        while (e != null) {
            if (e instanceof NestedDataCompositionSchema) {
                schema = ((NestedDataCompositionSchema)e).getSchema();
                break;
            }
            if (e instanceof DataCompositionSchema) {
                schema = (DataCompositionSchema)e;
                break;
            }
            e = e.eContainer();
        }
        if (schema != null && settings != null && settings.eContainer() instanceof DataCompositionNestedObjectSettings) {
            DataCompositionNestedObjectSettings nested = (DataCompositionNestedObjectSettings)settings.eContainer();
            Optional<NestedDataCompositionSchema> nestedSchema = schema.getNestedSchemas().stream().filter(s -> s.getName().equals(nested.getObjectID())).findFirst();
            return nestedSchema.map(NestedDataCompositionSchema::getSchema).orElse(schema);
        }
        return schema;
    }

    private DcsPath getTranslation(IProjectTranslationProvider translationProvider, TranslateLanguage language, DataCompositionSchema schema, FieldInfo fieldInfo, DcsPathBase part) throws DcsPathException {
        DcsAvailableFieldInfo info = fieldInfo.info;
        if ((info.isLeaf && fieldInfo.parent != null || info.isTable || fieldInfo.parent != null && !fieldInfo.parent.info.isFolder && !fieldInfo.parent.info.isResource) && info.getFieldDef() instanceof DbViewFieldDef) {
            EObject mdObject = info.getFieldDef().getMdObject();
            if (!(mdObject instanceof MdObject) || mdObject instanceof FieldSource && !(mdObject instanceof DbObjectTabularSection)) {
                return null;
            }
            Provider provider = () -> {
                Pair translation;
                MdObject md = (MdObject)mdObject;
                if (mdObject.eIsProxy()) {
                    md = (MdObject)EcoreUtil.resolve((EObject)mdObject, (EObject)schema);
                }
                if ((translation = this.namedEObjectNameProvider.getTranslatedName((EObject)md, translationProvider)) != null && md.getName().equals(translation.getKey())) {
                    return (String)translation.getValue();
                }
                return md.getName();
            };
            URI objectUri = EcoreUtil.getURI((EObject)mdObject);
            ModelNameTranslationCache cache = (ModelNameTranslationCache)translationProvider.getCache(ModelNameTranslationCache.class);
            String translation = cache.getTranslation(objectUri, provider);
            return new DcsPath(translation);
        }
        if (info.isLeaf && !info.isFolder && info.getFieldDef() == null && fieldInfo.parent != null && fieldInfo.parent.info.isFolder && fieldInfo.parent.info.dataPath[0].equals((Object)DCS_PATH_PARAMERTERS)) {
            Optional translation;
            String dataPath = part.toString();
            Optional<DataCompositionSchemaParameter> param = schema.getParameters().stream().filter(p -> p.getName().equals(dataPath)).findFirst();
            if (param.isPresent() && (translation = translationProvider.getOptionalTranslation((EObject)param.get(), DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_PARAMETER__NAME, language)).isPresent()) {
                return new DcsPath((String)translation.get());
            }
        } else if (!info.isFolder || !info.isLeaf && fieldInfo.parent != null && fieldInfo.parent.info.isFolder) {
            String dataPath = part.toString();
            Optional<String> translation = Optional.empty();
            Optional<DataCompositionSchemaCalculatedField> calc = this.getCalculatedFields(schema, dataPath);
            if (calc.isPresent()) {
                translation = translationProvider.getOptionalTranslation((EObject)calc.get(), DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_CALCULATED_FIELD__DATA_PATH, language);
            } else {
                Optional<DataSetField> dataSetField = this.getDataSetField(schema, dataPath);
                if (dataSetField.isPresent()) {
                    translation = Optional.ofNullable(this.getDataSetFieldTranslation(dataSetField.get(), translationProvider, language));
                }
            }
            if (translation.isPresent()) {
                return new DcsPath((String)translation.get());
            }
        }
        return null;
    }

    private Optional<UserField> getUserFields(DataCompositionSettings settings, String fieldName) {
        if (settings.getUserFields() == null) {
            return Optional.empty();
        }
        return settings.getUserFields().getItems().stream().filter(field -> field.getDataPath().equals(fieldName)).findFirst();
    }

    private static final class FieldInfo {
        public final FieldInfo parent;
        public final DcsAvailableFieldInfo info;

        public FieldInfo(FieldInfo parent, DcsAvailableFieldInfo info) {
            Assert.isNotNull((Object)info);
            this.parent = parent;
            this.info = info;
        }
    }
}

