/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.translator;

import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaDataSetField;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaDataSetQuery;
import com._1c.g5.v8.dt.dcs.model.schema.DcsPackage;
import com._1c.g5.v8.dt.metadata.dbview.DbViewElement;
import com._1c.g5.v8.dt.ql.dcs.model.QuerySchemaQueryGroupSourceJoin;
import com._1c.g5.v8.dt.ql.dcs.resource.IDependentQuerySchemaProvider;
import com._1c.g5.v8.dt.ql.model.AbstractQuerySchemaQuery;
import com._1c.g5.v8.dt.ql.model.AbstractQuerySchemaTable;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com._1c.g5.v8.dt.ql.model.QuerySchemaOperator;
import com._1c.g5.v8.dt.ql.model.QuerySchemaQuerySourceJoin;
import com._1c.g5.v8.dt.ql.model.QuerySchemaSelectQuery;
import com._1c.g5.v8.dt.ql.model.QuerySchemaSource;
import com._1c.g5.v8.dt.ql.model.QuerySchemaTable;
import com._1c.g5.v8.dt.ql.typesystem.IDynamicDbViewFieldComputer;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.dcs.settings.DcsFeatureSettings;
import com.e1c.langtool.v8.dt.internal.dcs.DcsPlugin;
import com.e1c.langtool.v8.dt.ql.translator.QlTextEditor;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IResourceScopeCache;

public class QueryStringFeatureTranslationProvider
implements IComputedStringFeatureTranslationProvider {
    @Inject
    protected IResourceScopeCache cache;
    @Inject
    private IDependentQuerySchemaProvider dependentModelProvider;
    @Inject
    private INamedEObjectNameProvider namedEObjectNameProvider;

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        return stringFeature.equals(DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_QUERY__QUERY) || stringFeature.equals(DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_FIELD__FIELD) && EcoreUtil2.getContainerOfType((EObject)object, DataCompositionSchemaDataSetQuery.class) != null;
    }

    public boolean isSupported(EObject object) {
        return object.eClass().getEPackage().equals(DcsPackage.eINSTANCE);
    }

    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        if (stringFeature.equals(DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_QUERY__QUERY)) {
            return this.computeTranslatedQueryString((DataCompositionSchemaDataSetQuery)object, translationProvider, language);
        }
        if (stringFeature.equals(DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_FIELD__FIELD) && EcoreUtil2.getContainerOfType((EObject)object, DataCompositionSchemaDataSetQuery.class) != null) {
            return this.computeTranslatedFieldFieldString((DataCompositionSchemaDataSetField)object, translationProvider, language);
        }
        return null;
    }

    private String computeTranslatedQueryString(DataCompositionSchemaDataSetQuery source, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        QueryInfo queryInfo = this.getQueryInfo(source, translationProvider, language);
        return queryInfo.getQueryText();
    }

    private String computeTranslatedFieldFieldString(DataCompositionSchemaDataSetField source, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        DataCompositionSchemaDataSetQuery query = (DataCompositionSchemaDataSetQuery)EcoreUtil2.getContainerOfType((EObject)source, DataCompositionSchemaDataSetQuery.class);
        String field = source.getField();
        if (query != null) {
            QueryInfo queryInfo = this.getQueryInfo(query, translationProvider, language);
            return queryInfo.getFieldNames().get(field);
        }
        return null;
    }

    private QueryInfo getQueryInfo(DataCompositionSchemaDataSetQuery source, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        String queryInfoSuffix = "QueryInfo_" + language.getLanguageCode();
        Pair key = new Pair((Object)source, (Object)queryInfoSuffix);
        Resource eResource = source.eResource();
        Provider provider = () -> this.computeQueryInfo(source, translationProvider);
        return (QueryInfo)this.cache.get((Object)key, eResource, provider);
    }

    private QueryInfo computeQueryInfo(DataCompositionSchemaDataSetQuery object, IProjectTranslationProvider translationProvider) {
        QuerySchema query;
        Map fieldNames;
        String queryText;
        block7: {
            queryText = object.getQuery();
            fieldNames = Map.of();
            query = this.dependentModelProvider.getQuerySchema((EObject)object, (EStructuralFeature)DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_QUERY__QUERY, CancelIndicator.NullImpl);
            if (query != null) break block7;
            DcsPlugin.log(DcsPlugin.createWarningStatus("Can't create DCS query object from text: \n\n" + queryText));
            QueryInfo queryInfo = new QueryInfo(queryText, fieldNames);
            this.dependentModelProvider.unload(query);
            return queryInfo;
        }
        try {
            try {
                QlTextEditor processor = QlTextEditor.create((IProjectTranslationProvider)translationProvider, (QuerySchema)query, (boolean)true);
                processor.process((IProgressMonitor)new NullProgressMonitor());
                if (!Strings.isNullOrEmpty((String)queryText) && !queryText.equals(processor.getProcessedText())) {
                    List fieldMaps = processor.getFieldMaps();
                    if (!fieldMaps.isEmpty() && fieldMaps.get(fieldMaps.size() - 1) != null) {
                        fieldNames = (Map)fieldMaps.get(fieldMaps.size() - 1);
                    }
                    queryText = processor.getProcessedText();
                }
                this.appendAllAvailableFields(fieldNames, query, translationProvider);
            }
            catch (Exception e) {
                DcsPlugin.logError(e);
                this.dependentModelProvider.unload(query);
            }
        }
        catch (Throwable throwable) {
            this.dependentModelProvider.unload(query);
            throw throwable;
        }
        this.dependentModelProvider.unload(query);
        return new QueryInfo(queryText, fieldNames);
    }

    private void appendAllAvailableFields(Map<String, String> fieldNames, QuerySchema schema, IProjectTranslationProvider translationProvider) {
        if (schema.getQueries().isEmpty()) {
            return;
        }
        AbstractQuerySchemaQuery absQuery = (AbstractQuerySchemaQuery)schema.getQueries().get(schema.getQueries().size() - 1);
        if (!(absQuery instanceof QuerySchemaSelectQuery)) {
            return;
        }
        IResourceServiceProvider rsp = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.qldcs"));
        IDynamicDbViewFieldComputer dynamicDbViewFieldComputer = (IDynamicDbViewFieldComputer)rsp.get(IDynamicDbViewFieldComputer.class);
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        QuerySchemaSelectQuery query = (QuerySchemaSelectQuery)absQuery;
        queue.addAll((Collection<Object>)query.getOperators());
        EObject element = null;
        while ((element = (EObject)queue.poll()) != null) {
            if (element instanceof QuerySchemaOperator) {
                queue.addAll((Collection<Object>)((QuerySchemaOperator)element).getSources());
                continue;
            }
            if (element instanceof QuerySchemaSource) {
                queue.add(((QuerySchemaSource)element).getSource());
                queue.addAll((Collection<Object>)((QuerySchemaSource)element).getJoins());
                continue;
            }
            if (element instanceof QuerySchemaTable) {
                queue.add(((QuerySchemaTable)element).getTable());
                continue;
            }
            if (element instanceof QuerySchemaQueryGroupSourceJoin) {
                queue.addAll((Collection<Object>)((QuerySchemaQueryGroupSourceJoin)element).getJoins());
                continue;
            }
            if (element instanceof QuerySchemaQuerySourceJoin) {
                queue.add(((QuerySchemaQuerySourceJoin)element).getSource());
                continue;
            }
            if (!(element instanceof AbstractQuerySchemaTable)) continue;
            List fields = dynamicDbViewFieldComputer.computeFieldsBySemanticObject(element);
            for (DbViewElement field : fields) {
                Pair translation;
                if (fieldNames.containsKey(field.getName()) || (translation = this.namedEObjectNameProvider.getTranslatedName((EObject)field, translationProvider)) == null || !((String)translation.getKey()).equalsIgnoreCase(field.getName())) continue;
                fieldNames.put((String)translation.getKey(), (String)translation.getValue());
            }
        }
    }

    private final class QueryInfo {
        private final String queryText;
        private final Map<String, String> fieldNames;

        public QueryInfo(String queryText, Map<String, String> fieldNames) {
            this.queryText = queryText;
            this.fieldNames = fieldNames;
        }

        public String getQueryText() {
            return this.queryText;
        }

        public Map<String, String> getFieldNames() {
            return this.fieldNames;
        }
    }
}

