/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.dcs.i18n;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.V8ParametersStringParser;
import com._1c.g5.v8.dt.dcs.model.areaTemplate.DataCompositionDetailsAreaParameterFieldExpression;
import com._1c.g5.v8.dt.dcs.model.areaTemplate.DataCompositionExpressionAreaParameter;
import com._1c.g5.v8.dt.dcs.model.common.DataCompositionDataSetFieldRole;
import com._1c.g5.v8.dt.dcs.model.common.DataCompositionOrderExpression;
import com._1c.g5.v8.dt.dcs.model.core.LocalString;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaCalculatedField;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaDataSetField;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaDataSetLink;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaParameter;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaTotalField;
import com._1c.g5.v8.dt.dcs.model.schema.DcsPackage;
import com._1c.g5.v8.dt.dcs.model.settings.DataCompositionUserFieldExpression;
import com._1c.g5.wiring.ServiceAccess;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.core.ext.IBmObjectExporterExtension;
import com.e1c.langtool.v8.dt.dcs.settings.DcsFeatureSettings;
import com.e1c.langtool.v8.dt.internal.dcs.i18n.DcsExprFeatureKeyComputer2;
import com.e1c.langtool.v8.dt.internal.dcs.i18n.DcsNStrUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class DcsV8ExporterExtension
implements IBmObjectExporterExtension {
    private static final QName QNAME_EXPRESSION = new QName("expression");
    private static final QName QNAME_PRESENTATION_EXPRESSION = new QName("presentationExpression");
    private static final QName QNAME_DCSAT_EXPRESSION = new QName("http://v8.1c.ru/8.1/data-composition-system/area-template", "expression", "dcsat");
    private static final QName QNAME_ACCOUNT_TYPE_EXPRESSION = new QName("http://v8.1c.ru/8.1/data-composition-system/common", "accountTypeExpression");
    private static final QName QNAME_COMMON_EXPRESSION = new QName("http://v8.1c.ru/8.1/data-composition-system/common", "expression");
    private static final QName QNAME_SOURCE_EXPRESSION = new QName("sourceExpression");
    private static final QName QNAME_DESTINATION_EXPRESSION = new QName("destinationExpression");
    private static final QName QNAME_LINK_CONDITION_EXPRESSION = new QName("linkConditionExpression");
    private static final QName QNAME_START_EXPRESSION = new QName("startExpression");
    private static final QName QNAME_DETAIL_EXPRESSION = new QName("http://v8.1c.ru/8.1/data-composition-system/settings", "detailExpression");
    private static final QName QNAME_DETAIL_EXPRESSION_PRESENTATION = new QName("http://v8.1c.ru/8.1/data-composition-system/settings", "detailExpressionPresentation");
    private static final QName QNAME_TOTAL_EXPRESSION = new QName("http://v8.1c.ru/8.1/data-composition-system/settings", "totalExpression");
    private static final QName QNAME_TOTAL_EXPRESSION_PRESENTATION = new QName("http://v8.1c.ru/8.1/data-composition-system/settings", "totalExpressionPresentation");
    private static final Map<QName, EFeatureSettings> FIELD_FEATURE_SETTINGS_MAP_DATA_SET_FIELD_ROLE = ImmutableMap.builder().put((Object)QNAME_ACCOUNT_TYPE_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_DATA_SET_FIELD_ROLE__ACCOUNT_TYPE_EXPRESSION).build();
    private static final Map<QName, EFeatureSettings> FIELD_FEATURE_SETTINGS_MAP_ORDER_EXPRESSION = ImmutableMap.builder().put((Object)QNAME_COMMON_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_ORDER_EXPRESSION__EXPRESSION).build();
    private static final Map<QName, EFeatureSettings> FIELD_FEATURE_SETTINGS_MAP_SCHEMA_DATA_SET_FIELD = ImmutableMap.builder().put((Object)QNAME_PRESENTATION_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_FIELD__PRESENTATION_EXPRESSION).build();
    private static final Map<QName, EFeatureSettings> FIELD_FEATURE_SETTINGS_MAP_CALCULATED_FIELD = ImmutableMap.builder().put((Object)QNAME_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_CALCULATED_FIELD__EXPRESSION).put((Object)QNAME_PRESENTATION_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_CALCULATED_FIELD__PRESENTATION_EXPRESSION).build();
    private static final Map<QName, EFeatureSettings> FIELD_FEATURE_SETTINGS_MAP_SCHEMA_TOTAL_FIELD = ImmutableMap.builder().put((Object)QNAME_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_TOTAL_FIELD__EXPRESSION).build();
    private static final Map<QName, EFeatureSettings> FIELD_FEATURE_SETTINGS_MAP_SCHEMA_DATA_SET_LINK = ImmutableMap.builder().put((Object)QNAME_SOURCE_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_LINK__SOURCE_EXPRESSION).put((Object)QNAME_DESTINATION_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_LINK__DESTINATION_EXPRESSION).put((Object)QNAME_LINK_CONDITION_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_LINK__LINK_CONDITION_EXPRESSION).put((Object)QNAME_START_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_LINK__START_EXPRESSION).build();
    private static final Map<QName, EFeatureSettings> FIELD_FEATURE_SETTINGS_MAP_SCHEMA_PARAMETER = ImmutableMap.builder().put((Object)QNAME_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_SCHEMA_PARAMETER__EXPRESSION).build();
    private static final Map<QName, EFeatureSettings> FIELD_FEATURE_SETTINGS_MAP_USER_FIELD_EXPRESSION = ImmutableMap.builder().put((Object)QNAME_DETAIL_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_USER_FIELD_EXPRESSION__DETAIL_EXPRESSION).put((Object)QNAME_DETAIL_EXPRESSION_PRESENTATION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_USER_FIELD_EXPRESSION__DETAIL_EXPRESSION_PRESENTATION).put((Object)QNAME_TOTAL_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_USER_FIELD_EXPRESSION__TOTAL_EXPRESSION).put((Object)QNAME_TOTAL_EXPRESSION_PRESENTATION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_USER_FIELD_EXPRESSION__TOTAL_EXPRESSION_PRESENTATION).build();
    private static final Map<QName, EFeatureSettings> FIELD_FEATURE_SETTINGS_MAP_EXPRESSION_AREA_PARAMETER = ImmutableMap.builder().put((Object)QNAME_DCSAT_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_EXPRESSION_AREA_PARAMETER__EXPRESSION).build();
    private static final Map<QName, EFeatureSettings> FIELD_FEATURE_SETTINGS_MAP_DETAILS_AREA_PARAMETER_FIELD_EXPRESSION = ImmutableMap.builder().put((Object)QNAME_DCSAT_EXPRESSION, (Object)DcsFeatureSettings.Literals.DATA_COMPOSITION_DETAILS_AREA_PARAMETER_FIELD_EXPRESSION__EXPRESSION).build();
    private ITranslatingProjectManager translatingProjectManager;
    private IStorageSettingsManager storageSettingsManager;
    private ITranslationFeatureKeyProvider featureKeyProvider;
    private ITranslationStorageManager storageManager;
    private DcsExprFeatureKeyComputer2 featureKeyComputer;

    @Inject
    public DcsV8ExporterExtension(ITranslatingProjectManager translatingProjectManager, IStorageSettingsManager storageSettingsManager, ITranslationFeatureKeyProvider featureKeyProvider, ITranslationStorageManager storageManager, DcsExprFeatureKeyComputer2 featureKeyComputer) {
        this.translatingProjectManager = translatingProjectManager;
        this.storageSettingsManager = storageSettingsManager;
        this.featureKeyProvider = featureKeyProvider;
        this.storageManager = storageManager;
        this.featureKeyComputer = featureKeyComputer;
    }

    public void beforeExport(IDtProject dtProject, IBmObject bmObject, IBmObject clone, IFile file, Map<IFile, byte[]> exportedExtraFiles) {
        URI currentFileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        IProject project = file.getProject();
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
        if (translatingProject != null && translatingProject.isTranslating()) {
            String defaultLanguageCode = translatingProject.getDefaultLanguage().getLanguageCode();
            List languages = translatingProject.getInterfaceLanguages();
            StorageID storageId = this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId();
            ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(project, storageId);
            ITranslationStorageProvider.ContextStorage currentStorage = storage instanceof ITranslationStorageProvider.ContextStorage ? (ITranslationStorageProvider.ContextStorage)storage : null;
            NstrBodyProcessor bodyProcessor = new NstrBodyProcessor(file, currentFileURI, languages, defaultLanguageCode, currentStorage);
            HashSet<ContextTranslationKey> affectedKeys = new HashSet<ContextTranslationKey>();
            TreeIterator iterator = clone.eAllContents();
            while (iterator.hasNext()) {
                EObject content = (EObject)iterator.next();
                ContextTranslationKey key = this.replaceLocalizableStrings(content, bodyProcessor, defaultLanguageCode, file, languages, currentStorage);
                if (key == null) continue;
                affectedKeys.add(key);
            }
            affectedKeys.addAll(bodyProcessor.getAffectedKeys());
            for (TranslateLanguage language : languages) {
                Map hashes = currentStorage.saveFiles(affectedKeys, language, Hashing.sha256());
                if (hashes.isEmpty()) continue;
                hashes.forEach((iFile, hash) -> exportedExtraFiles.put((IFile)iFile, (byte[])hash));
            }
        }
    }

    public Collection<EClass> targets() {
        return Lists.newArrayList((Object[])new EClass[]{DcsPackage.Literals.DATA_COMPOSITION_SCHEMA});
    }

    protected List<String> getLanguageCodes(IProject project) {
        ITranslatingProjectManager manager = (ITranslatingProjectManager)ServiceAccess.get(ITranslatingProjectManager.class);
        ITranslatingProject translating = manager.getProject(project);
        ArrayList languageCodes = Lists.newArrayList();
        if (translating != null && translating.isTranslating()) {
            translating.getInterfaceLanguages().forEach(l -> languageCodes.add(l.getLanguageCode()));
        }
        return languageCodes;
    }

    private ContextTranslationKey replaceLocalizableStrings(EObject object, BiFunction<FeatureKey, String, String> processor, String defaultLanguageCode, IFile currentFile, Collection<TranslateLanguage> languages, ITranslationStorageProvider.ContextStorage currentStorage) {
        if (object instanceof LocalString) {
            return this.updateLocalString((LocalString)object, defaultLanguageCode, currentFile, languages, currentStorage);
        }
        if (object instanceof DataCompositionDataSetFieldRole) {
            this.setLocaliableStrings(object, FIELD_FEATURE_SETTINGS_MAP_DATA_SET_FIELD_ROLE, processor);
        }
        if (object instanceof DataCompositionSchemaCalculatedField) {
            this.setLocaliableStrings(object, FIELD_FEATURE_SETTINGS_MAP_CALCULATED_FIELD, processor);
        }
        if (object instanceof DataCompositionExpressionAreaParameter) {
            this.setLocaliableStrings(object, FIELD_FEATURE_SETTINGS_MAP_EXPRESSION_AREA_PARAMETER, processor);
        }
        if (object instanceof DataCompositionOrderExpression) {
            this.setLocaliableStrings(object, FIELD_FEATURE_SETTINGS_MAP_ORDER_EXPRESSION, processor);
        }
        if (object instanceof DataCompositionOrderExpression) {
            this.setLocaliableStrings(object, FIELD_FEATURE_SETTINGS_MAP_ORDER_EXPRESSION, processor);
        }
        if (object instanceof DataCompositionSchemaDataSetField) {
            this.setLocaliableStrings(object, FIELD_FEATURE_SETTINGS_MAP_SCHEMA_DATA_SET_FIELD, processor);
        }
        if (object instanceof DataCompositionSchemaTotalField) {
            this.setLocaliableStrings(object, FIELD_FEATURE_SETTINGS_MAP_SCHEMA_TOTAL_FIELD, processor);
        }
        if (object instanceof DataCompositionSchemaDataSetLink) {
            this.setLocaliableStrings(object, FIELD_FEATURE_SETTINGS_MAP_SCHEMA_DATA_SET_LINK, processor);
        }
        if (object instanceof DataCompositionSchemaParameter) {
            this.setLocaliableStrings(object, FIELD_FEATURE_SETTINGS_MAP_SCHEMA_PARAMETER, processor);
        }
        if (object instanceof DataCompositionUserFieldExpression) {
            this.setLocaliableStrings(object, FIELD_FEATURE_SETTINGS_MAP_USER_FIELD_EXPRESSION, processor);
        }
        if (object instanceof DataCompositionDetailsAreaParameterFieldExpression) {
            this.setLocaliableStrings(object, FIELD_FEATURE_SETTINGS_MAP_DETAILS_AREA_PARAMETER_FIELD_EXPRESSION, processor);
        }
        return null;
    }

    private void setLocaliableStrings(EObject object, Map<QName, EFeatureSettings> fieldFeatureMap, BiFunction<FeatureKey, String, String> processor) {
        for (Map.Entry<QName, EFeatureSettings> entry : fieldFeatureMap.entrySet()) {
            EFeatureSettings featureSettings = entry.getValue();
            String value = (String)object.eGet(featureSettings.getEFeature());
            if (featureSettings == null || !DcsNStrUtil.canContainNStr(value)) continue;
            FeatureKey fieldFeatureKey = this.featureKeyComputer.computeFqn(object, featureSettings);
            String valueToWrite = DcsNStrUtil.processExpressionWithNStr(fieldFeatureKey, value, processor);
            object.eSet(featureSettings.getEFeature(), (Object)valueToWrite);
        }
    }

    private ContextTranslationKey updateLocalString(LocalString localString, String defaultLanguageCode, IFile currentFile, Collection<TranslateLanguage> languages, ITranslationStorageProvider.ContextStorage currentStorage) {
        EMap localStringsMap = localString.getContent();
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)localString, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT);
        String value = (String)localStringsMap.get((Object)defaultLanguageCode);
        if (value == null) {
            return null;
        }
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(currentFile, featureKey, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT, value);
        for (TranslateLanguage language : languages) {
            if (localStringsMap.containsKey((Object)language.getLanguageCode())) {
                currentStorage.setTranslation((ContextTranslationKey)contextKey, language, (String)localStringsMap.get((Object)language.getLanguageCode()), false);
            } else {
                currentStorage.removeTranslation((ContextTranslationKey)contextKey, language, false);
            }
            localStringsMap.removeKey((Object)language.getLanguageCode());
        }
        return contextKey;
    }

    private class NstrBodyProcessor
    implements BiFunction<FeatureKey, String, String> {
        private final IFile currentFile;
        private final URI currentFileURI;
        private final Collection<TranslateLanguage> languages;
        private final String defaultLanguageCode;
        private final ITranslationStorageProvider.ContextStorage currentStorage;
        private final Collection<ContextTranslationKey> affectedKeys;

        public NstrBodyProcessor(IFile currentFile, URI currentFileURI, Collection<TranslateLanguage> languages, String defaultLanguageCode, ITranslationStorageProvider.ContextStorage currentStorage) {
            this.currentFile = currentFile;
            this.currentFileURI = currentFileURI;
            this.languages = languages;
            this.defaultLanguageCode = defaultLanguageCode;
            this.currentStorage = currentStorage;
            this.affectedKeys = new HashSet<ContextTranslationKey>();
        }

        @Override
        public String apply(FeatureKey fieldFeatureKey, String text) {
            V8ParametersStringParser parser = new V8ParametersStringParser(text);
            if (parser.getStatus().isOK()) {
                Map parameters = parser.getParameters();
                String sourceString = (String)parameters.get(this.defaultLanguageCode);
                for (TranslateLanguage language : this.languages) {
                    String languageCode = language.getLanguageCode();
                    ContextTranslationKey contextKey = DcsNStrUtil.buildNStrContextTranslationKey(this.currentFile, this.currentFileURI, fieldFeatureKey, sourceString);
                    if (parameters.containsKey(languageCode)) {
                        this.currentStorage.setTranslation(contextKey, language, (String)parameters.get(languageCode), false);
                        parameters.remove(languageCode);
                    } else {
                        this.currentStorage.removeTranslation(contextKey, language, false);
                    }
                    this.affectedKeys.add(contextKey);
                }
                return DcsNStrUtil.formatNStr(parameters);
            }
            return text;
        }

        public Collection<ContextTranslationKey> getAffectedKeys() {
            return this.affectedKeys;
        }
    }
}

