/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.dcs.i18n;

import com._1c.g5.v8.bm.core.IBmEngine;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.dcs.DcsPlugin;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchema;
import com._1c.g5.v8.dt.dcs.model.schema.DcsPackage;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.wiring.ServiceAccess;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.e1c.langtool.v8.dt.core.ext.IResourceContentImporterExtension;
import com.e1c.langtool.v8.dt.internal.dcs.i18n.DcsExprFeatureKeyComputer2;
import com.e1c.langtool.v8.dt.internal.dcs.i18n.DcsLoadingPostprocessor;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.w3c.dom.Document;

public class DcsV8ImporterExtension
implements IResourceContentImporterExtension {
    private static final String CONFIGURATION_MDO_FILE_PATH = "src/Configuration/Configuration.mdo";
    private static final String XPATH_DEFAULT_LANGUAGE_FULL_NAME = "//defaultLanguage";
    private static final String XPATH_LANGUAGE_CODE_BY_NAME = "//languages/name[text() = \"%s\"]/../languageCode/text()";
    private static final String LANGUAGE_FQN_PREFIX = "Language.";
    private final ITranslatingProjectManager translatingProjectManager;
    private final ITranslationFeatureKeyProvider featureKeyProvider;
    private final IStorageSettingsManager storageSettingsManager;
    private final ITranslationStorageManager storageManager;
    private final DcsExprFeatureKeyComputer2 featureKeyComputer;
    private final IResourceLookup resourceLookup;
    private Map<IProject, String> projectDefaultLanguageCode = Collections.synchronizedMap(new WeakHashMap());

    @Inject
    public DcsV8ImporterExtension(ITranslatingProjectManager translatingProjectManager, ITranslationFeatureKeyProvider featureKeyProvider, IStorageSettingsManager storageSettingsManager, ITranslationStorageManager storageManager, DcsExprFeatureKeyComputer2 featureKeyComputer, IResourceLookup resourceLookup) {
        this.translatingProjectManager = translatingProjectManager;
        this.featureKeyProvider = featureKeyProvider;
        this.storageSettingsManager = storageSettingsManager;
        this.storageManager = storageManager;
        this.featureKeyComputer = featureKeyComputer;
        this.resourceLookup = resourceLookup;
    }

    public void afterImport(IBmEngine engine, IBmTransaction transaction, Resource resource, IPath path, IBmObject importedObject) {
        IProject project = this.resourceLookup.getProject((EObject)importedObject);
        this.handleConfiguration(project, importedObject);
        String defaultLanguageCode = this.projectDefaultLanguageCode.get(project);
        if (defaultLanguageCode == null) {
            defaultLanguageCode = this.tryGetDefaultLanguageCode(project);
        }
        if (defaultLanguageCode != null) {
            URI resourceURI = resource.getURI();
            StorageID storageId = this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId();
            ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(project, storageId);
            ITranslationStorageProvider.ContextStorage currentStorage = storage instanceof ITranslationStorageProvider.ContextStorage ? (ITranslationStorageProvider.ContextStorage)storage : null;
            ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
            List interfaceLanguages = translatingProject != null && translatingProject.isTranslating() ? translatingProject.getInterfaceLanguages() : null;
            if (resourceURI != null && interfaceLanguages != null && currentStorage != null) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                TranslationProperties properties = this.getTranslationProperties(project);
                DataCompositionSchema schema = (DataCompositionSchema)importedObject;
                IFile file = project.getFile(path);
                DcsLoadingPostprocessor postprocessor = new DcsLoadingPostprocessor(this.featureKeyProvider, this.featureKeyComputer, schema, resourceURI, file, defaultLanguageCode, interfaceLanguages, currentStorage, properties);
                DcsPlugin.getDefault().getInjector().injectMembers((Object)postprocessor);
                postprocessor.process((IProgressMonitor)monitor);
            }
        } else if (DcsPlugin.getDefault().isDebugging()) {
            DcsPlugin.log((IStatus)DcsPlugin.createWarningStatus((String)"Project default language unknown. DCS will not be processed by DcsV8Importer aspect."));
        }
    }

    public Collection<EClass> targets() {
        return Lists.newArrayList((Object[])new EClass[]{DcsPackage.Literals.DATA_COMPOSITION_SCHEMA});
    }

    private TranslationProperties getTranslationProperties(IProject project) {
        TranslationPreferences prefs = (TranslationPreferences)ServiceAccess.get(TranslationPreferences.class);
        return prefs.getTranslationProperties(project);
    }

    private void handleConfiguration(IProject project, IBmObject item) {
        if (item instanceof Configuration) {
            String defaultLanguageCode = ((Configuration)item).getDefaultLanguage().getLanguageCode();
            this.projectDefaultLanguageCode.put(project, defaultLanguageCode);
        }
    }

    private String tryGetDefaultLanguageCode(IProject project) {
        block13: {
            if (project != null) {
                try {
                    IFile configurationFile = project.getFile(CONFIGURATION_MDO_FILE_PATH);
                    if (configurationFile == null || !configurationFile.isAccessible()) break block13;
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (InputStream inputStream = configurationFile.getContents();){
                        Document document = builder.parse(inputStream);
                        XPathFactory xpathFactory = XPathFactory.newInstance();
                        XPath xpath = xpathFactory.newXPath();
                        String defaultLanguageFullName = (String)xpath.evaluate(XPATH_DEFAULT_LANGUAGE_FULL_NAME, document, XPathConstants.STRING);
                        if (defaultLanguageFullName != null && defaultLanguageFullName.startsWith(LANGUAGE_FQN_PREFIX)) {
                            String languageName = defaultLanguageFullName.substring(LANGUAGE_FQN_PREFIX.length());
                            String defaultLanguageCode = (String)xpath.evaluate(String.format(XPATH_LANGUAGE_CODE_BY_NAME, languageName), document, XPathConstants.STRING);
                            return defaultLanguageCode;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    if (!DcsPlugin.getDefault().isDebugging()) break block13;
                    DcsPlugin.log((IStatus)DcsPlugin.createErrorStatus((String)"Exception while trying to figure out default language code", (Throwable)e));
                }
            }
        }
        return null;
    }
}

