/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.yandex;

import com.e1c.langtool.external.ExternalApiAccessLimit;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.external.InvalidAccessKeyException;
import com.e1c.langtool.external.InvalidLanguagesException;
import com.e1c.langtool.external.InvalidTextException;
import com.e1c.langtool.external.ServiceUnavailableException;
import com.e1c.langtool.external.TranslationServiceException;
import com.e1c.langtool.yandex.Errors;
import com.e1c.langtool.yandex.Messages;
import com.e1c.langtool.yandex.YandexPreferenceConstants;
import com.e1c.langtool.yandex.YandexQueryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class YandexTranslateProvider
implements IExternalTranslationProvider {
    public static final String PROVIDER_ID = "com.e1c.langtool.yandex.yandexTranslateProvider";
    private static final int CODE_OK = 200;
    private static final String TAG = Messages.YandexTranslateProvider_ServiceNameTag;
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int ACCESS_API_PER_SECOND = 20;
    private static final int SYMBOLS_PER_MINUTE = 16600;
    private Preferences preferences = InstanceScope.INSTANCE.getNode("com.e1c.langtool.yandex");
    protected final HttpClient client = this.createClient();
    private final Gson gson = new Gson();
    private final ExternalApiAccessLimit limits = new ExternalApiAccessLimit(Duration.ofSeconds(1L), 20, Duration.ofMinutes(1L), 16600);
    private volatile Set<String> supportedLangs;

    public String getTranslationItemImageName() {
        return "icons/obj16/yandex.png";
    }

    public List<String> translate(String text, String source, String target) {
        if (text == null) {
            throw new IllegalArgumentException("The given text must be not null");
        }
        if (text.trim().length() == 0) {
            return Arrays.asList(text);
        }
        String licenseKey = this.getLicenseKey();
        String folderId = this.getFolderId();
        String modelId = this.getModelId();
        HttpRequest request = this.createTranslationQuery().folderId(folderId).key(licenseKey).language(source, target).text(text).model(modelId).build();
        this.limits.checkOrWaitSymbolLimits(text.length());
        HttpResponse<String> response = this.safeExec(request);
        this.handleResponse(response);
        TranslationEntity translation = (TranslationEntity)this.gson.fromJson(response.body(), TranslationEntity.class);
        if (translation.getTranslations().isEmpty()) {
            return Arrays.asList("");
        }
        return translation.getTranslations().stream().map(TranslationItem::getText).collect(Collectors.toList());
    }

    public Map<String, List<String>> translate(List<String> texts, String source, String target) {
        String licenseKey = this.getLicenseKey();
        String folderId = this.getFolderId();
        String modelId = this.getModelId();
        YandexQueryBuilder queryBuilder = this.createTranslationQuery().folderId(folderId).key(licenseKey).language(source, target).model(modelId);
        for (String text : texts) {
            if (text == null) {
                throw new IllegalArgumentException("The given text must be not null");
            }
            queryBuilder.text(text);
        }
        HttpRequest request = queryBuilder.build();
        int total = texts.stream().collect(Collectors.summingInt(String::length));
        this.limits.checkOrWaitSymbolLimits(total);
        HttpResponse<String> response = this.safeExec(request);
        this.handleResponse(response);
        TranslationEntity entity = (TranslationEntity)this.gson.fromJson(response.body(), TranslationEntity.class);
        return this.toResultTranslationMap(texts, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getLanguageCodes() {
        Set<String> result = this.supportedLangs;
        if (result == null) {
            YandexTranslateProvider yandexTranslateProvider = this;
            synchronized (yandexTranslateProvider) {
                result = this.supportedLangs;
                if (result == null) {
                    this.supportedLangs = result = Collections.unmodifiableSet(this.getSupportedLanguages().keySet());
                }
            }
        }
        return result;
    }

    public Map<String, String> getLanguages(String target) {
        return this.getSupportedLanguages();
    }

    public boolean isActive() {
        return this.preferences.getBoolean("isActive", false);
    }

    protected YandexQueryBuilder createTranslationQuery() {
        return YandexQueryBuilder.createTranslationQuery();
    }

    protected YandexQueryBuilder createGettingSupportedLanguagesQuery() {
        return YandexQueryBuilder.createGettingSupportedLanguagesQuery();
    }

    private Map<String, String> getSupportedLanguages() {
        String licenseKey = this.getLicenseKey();
        String folderId = this.getFolderId();
        HttpRequest request = this.createGettingSupportedLanguagesQuery().folderId(folderId).key(licenseKey).build();
        HttpResponse<String> response = this.safeExec(request);
        this.handleResponse(response);
        SupportedLanguagesEntity entity = (SupportedLanguagesEntity)this.gson.fromJson(response.body(), SupportedLanguagesEntity.class);
        TreeMap<String, String> languages = new TreeMap<String, String>();
        if (entity.getLanguages() != null) {
            for (LanguageDescription lang : entity.getLanguages()) {
                languages.put(String.valueOf(lang.getCode()), lang.getName());
            }
        }
        return languages;
    }

    private Map<String, List<String>> toResultTranslationMap(List<String> texts, TranslationEntity entity) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        Iterator<TranslationItem> resIt = entity.getTranslations().iterator();
        for (String text : texts) {
            res.put(text, Arrays.asList(resIt.next().getText()));
        }
        return res;
    }

    private void handleResponse(HttpResponse<String> response) {
        if (response.statusCode() == 501) {
            throw new InvalidLanguagesException(this.getExceptionMsg(Messages.YandexTranslateProvider_501ErrorMsg, 501));
        }
        if (response.statusCode() == 414) {
            throw new InvalidTextException(Messages.YandexTranslateProvider_414ErrorMsg);
        }
        if (response.statusCode() != 200) {
            try {
                ErrorEntity entity = (ErrorEntity)this.gson.fromJson(response.body(), ErrorEntity.class);
                this.handleResponseCode(entity);
            }
            catch (JsonSyntaxException e) {
                throw new TranslationServiceException(this.getExceptionMsg(Messages.YandexTranslateProvider_UnknowErrorMsg, response.statusCode()));
            }
        }
    }

    private void handleResponseCode(ErrorEntity error) {
        if (error.getCode() == 200) {
            return;
        }
        if (error.getCode() == Errors.UNAUTHENTICATED.getCode()) {
            throw new InvalidAccessKeyException(this.getExceptionMsg(Messages.YandexTranslateProvider_401ErrorMsg, error));
        }
        if (error.getCode() == Errors.PERMISSION_DENIED.getCode()) {
            throw new InvalidAccessKeyException(this.getExceptionMsg(Messages.YandexTranslateProvider_402ErrorMsg, error));
        }
        throw new TranslationServiceException(this.getExceptionMsg(Messages.YandexTranslateProvider_UnknowErrorMsg, error));
    }

    private String getExceptionMsg(String msg, int code) {
        return String.format("%s %s (%d)", TAG, msg, code);
    }

    private String getExceptionMsg(String msg, ErrorEntity error) {
        return String.format("%s %s (%d) %s", TAG, msg, error.getCode(), error.getMessage());
    }

    protected HttpClient createClient() {
        return HttpClient.newBuilder().connectTimeout(Duration.ofMillis(5000L)).proxy(ProxySelector.getDefault()).build();
    }

    private String getLicenseKey() {
        return this.preferences.get("apiKey", YandexPreferenceConstants.DEFAULT_API_KEY);
    }

    private String getFolderId() {
        return this.preferences.get("folderId", YandexPreferenceConstants.DEFAULT_FOLDER_ID);
    }

    private String getModelId() {
        return this.preferences.get("modelId", YandexPreferenceConstants.DEFAULT_MODEL_ID);
    }

    private HttpResponse<String> safeExec(HttpRequest request) {
        try {
            this.limits.checkOrWaitAccessApiLimits();
            return this.client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException e) {
            throw new ServiceUnavailableException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TranslationServiceException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TranslationServiceException((Throwable)e);
        }
    }

    public static class ErrorEntity {
        private int code;
        private String message;

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    public static class LanguageDescription {
        private String code;
        private String name;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class SupportedLanguagesEntity {
        private List<LanguageDescription> languages;

        public List<LanguageDescription> getLanguages() {
            return this.languages;
        }

        public void setLanguages(List<LanguageDescription> languages) {
            this.languages = languages;
        }
    }

    public static class TranslationEntity {
        private List<TranslationItem> translations;

        public List<TranslationItem> getTranslations() {
            return this.translations;
        }

        public void setTranslations(List<TranslationItem> translations) {
            this.translations = translations;
        }
    }

    public static class TranslationItem {
        private String text;
        private String detectedLanguageCode;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getDetectedLanguageCode() {
            return this.detectedLanguageCode;
        }

        public void setDetectedLanguageCode(String detectedLanguageCode) {
            this.detectedLanguageCode = detectedLanguageCode;
        }
    }
}

