/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.emf;

import com._1c.g5.wiring.InjectorAwareServiceRegistrator;
import com._1c.g5.wiring.ServiceInitialization;
import com.e1c.langtool.emf.collector.IComputedNameProviderRegistry;
import com.e1c.langtool.emf.collector.IComputedNameService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.internal.emf.ExternalDependenciesModule;
import com.e1c.langtool.internal.emf.ServiceModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class CorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.emf";
    private static CorePlugin plugin;
    private static BundleContext context;
    private volatile Injector injector;
    private InjectorAwareServiceRegistrator registrator;

    public static CorePlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        CorePlugin.log(CorePlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        super.start(bundleContext);
        plugin = this;
        this.registrator = new InjectorAwareServiceRegistrator(bundleContext, this::getInjector);
        ServiceInitialization.schedule(() -> {
            this.registrator.service(ITranslationFeatureKeyProvider.class).registerInjected();
            this.registrator.service(IComputedNameProviderRegistry.class).registerInjected();
            this.registrator.service(IComputedNameService.class).registerInjected();
            this.registrator.service(IFeatureSettingsService.class).registerInjected();
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        this.registrator.deactivateManagedServices((Plugin)this);
        this.registrator.unregisterServices();
        plugin = null;
        this.injector = null;
        super.stop(bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<CorePlugin> clazz = CorePlugin.class;
        synchronized (CorePlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ServiceModule(), new ExternalDependenciesModule(this)});
        }
        catch (Exception e) {
            CorePlugin.log(CorePlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }
}

