/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.emf.collector;

import com.e1c.langtool.emf.collector.IComputedNameProvider;
import com.e1c.langtool.emf.collector.IComputedNameProviderRegistry;
import com.e1c.langtool.emf.collector.IComputedNameService;
import com.e1c.langtool.emf.collector.IComputedStringFeatureProvider;
import com.e1c.langtool.emf.collector.IComputedStringMapFeatureProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.internal.emf.CorePlugin;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.concurrent.CancellationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ComputedNameService
implements IComputedNameService {
    @Inject
    private IComputedNameProviderRegistry registry;

    @Override
    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        if (object == null) {
            return false;
        }
        for (IComputedNameProvider provider : this.registry.getAllProviders()) {
            try {
                if (!(provider instanceof IComputedStringFeatureProvider) || !provider.isSupported(object) || !((IComputedStringFeatureProvider)provider).isComputedString(object, stringFeature)) continue;
                return true;
            }
            catch (Exception e) {
                if (e instanceof CancellationException) {
                    throw e;
                }
                String message = MessageFormat.format("Error while checking \"is computed\" feature \"{0}\" for object: {1}", stringFeature.getName(), EcoreUtil.getURI((EObject)object));
                IStatus status = CorePlugin.createErrorStatus(message, e);
                CorePlugin.log(status);
            }
        }
        return false;
    }

    @Override
    public boolean isComputedMapValue(EObject object, EFeatureSettings feature, Object key) {
        if (object == null) {
            return false;
        }
        for (IComputedNameProvider provider : this.registry.getAllProviders()) {
            if (!(provider instanceof IComputedStringMapFeatureProvider) || !provider.isSupported(object) || !((IComputedStringMapFeatureProvider)provider).isComputedMapValue(object, feature, key)) continue;
            return true;
        }
        return false;
    }
}

