/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.emf.naming;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.emf.naming.FeatureKeyEObjectMigrationnExtension;
import com.e1c.langtool.emf.naming.FeatureKeyMigrationnExtension;
import com.e1c.langtool.emf.naming.IFeatureKeyComputer;
import com.e1c.langtool.emf.naming.IFeatureKeyConverterExtension;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.internal.emf.CorePlugin;
import com.e1c.langtool.platform.ITranslateProject;
import com.e1c.langtool.settings.FeatureSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;

public class TranslationFeatureKeyProvider
implements ITranslationFeatureKeyProvider {
    private static final String ATT_CLASS = "class";
    private static final String EXTENSION_POINT_ID = "featureKeyComputers";
    private volatile List<IFeatureKeyComputer> keyComputers;

    @Override
    public FeatureKey getFeatureKey(EObject object, FeatureSettings featureSettings) {
        FeatureKey keyFqn = this.getKey(object);
        if (keyFqn != null) {
            return keyFqn.append(featureSettings.getName());
        }
        return SegmentFeatureKey.create((String)featureSettings.getName());
    }

    @Override
    public FeatureKey getKey(EObject object) {
        FeatureKey keyFqn = null;
        if (object == null) {
            return keyFqn;
        }
        for (IFeatureKeyComputer computer : this.getKeyComputers()) {
            if (!computer.isSupported(object)) continue;
            keyFqn = computer.getFeatureKey(object);
            break;
        }
        return keyFqn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IFeatureKeyComputer> getKeyComputers() {
        Class<TranslationFeatureKeyProvider> clazz;
        if (this.keyComputers != null) {
            return this.keyComputers;
        }
        Class<TranslationFeatureKeyProvider> clazz2 = clazz = TranslationFeatureKeyProvider.class;
        synchronized (clazz2) {
            IConfigurationElement[] configElements;
            if (this.keyComputers != null) {
                return this.keyComputers;
            }
            ArrayList<IFeatureKeyComputer> allComputers = new ArrayList<IFeatureKeyComputer>();
            IConfigurationElement[] elements = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.e1c.langtool.emf", EXTENSION_POINT_ID);
            int length = configElements.length;
            int index = 0;
            while (index < length) {
                IConfigurationElement configElement = elements[index];
                try {
                    IFeatureKeyComputer e = (IFeatureKeyComputer)configElement.createExecutableExtension(ATT_CLASS);
                    allComputers.add(e);
                }
                catch (CoreException e) {
                    CorePlugin.logError(e);
                }
                ++index;
            }
            this.keyComputers = List.copyOf(allComputers);
            return this.keyComputers;
        }
    }

    @Override
    public Collection<FeatureKey> getOldFeatureKeys(EObject object) {
        HashSet<FeatureKey> keys = new HashSet<FeatureKey>();
        if (object == null) {
            return keys;
        }
        for (IFeatureKeyComputer computer : this.getKeyComputers()) {
            Collection<FeatureKey> oldKeys;
            if (!(computer instanceof FeatureKeyEObjectMigrationnExtension) || !computer.isSupported(object) || (oldKeys = ((FeatureKeyEObjectMigrationnExtension)computer).getOldFeatureKeys(object)) == null || oldKeys.isEmpty()) continue;
            keys.addAll(oldKeys);
        }
        return keys;
    }

    @Override
    public Collection<FeatureKey> getOldFeatureKeys(ContextTranslationKey contexTranslationKey) {
        HashSet<FeatureKey> keys = new HashSet<FeatureKey>();
        if (contexTranslationKey == null) {
            return keys;
        }
        for (IFeatureKeyComputer computer : this.getKeyComputers()) {
            Collection<FeatureKey> oldKeys;
            if (!(computer instanceof FeatureKeyMigrationnExtension) || !((FeatureKeyMigrationnExtension)computer).isSupport(contexTranslationKey) || (oldKeys = ((FeatureKeyMigrationnExtension)computer).getOldFeatureKeys(contexTranslationKey.getFeatureKey())) == null || oldKeys.isEmpty()) continue;
            keys.addAll(oldKeys);
        }
        return keys;
    }

    @Override
    public FeatureKey getConvertedFeatureKey(EObject object, FeatureSettings featureSettings, String translation, ITranslateProject project) {
        FeatureKey keyFqn = null;
        if (object == null) {
            return keyFqn;
        }
        for (IFeatureKeyComputer computer : this.getKeyComputers()) {
            if (!(computer instanceof IFeatureKeyConverterExtension) || !computer.isSupported(object)) continue;
            keyFqn = ((IFeatureKeyConverterExtension)computer).getConvertedFeatureKey(object, translation, project);
            break;
        }
        if (keyFqn != null) {
            return keyFqn.append(featureSettings.getName());
        }
        return this.getFeatureKey(object, featureSettings);
    }
}

