/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.emf.settings;

import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.emf.settings.IFeatureSettingsProvider;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.internal.emf.CorePlugin;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class FeatureSettingsService
implements IFeatureSettingsService {
    private static final String ATT_CLASS = "class";
    private volatile List<IFeatureSettingsProvider> providers;

    @Override
    public List<EFeatureSettings> allSettingsByObject(EObject object) {
        ArrayList<EFeatureSettings> settings = new ArrayList<EFeatureSettings>();
        for (IFeatureSettingsProvider provider : this.getProviders()) {
            settings.addAll(provider.allSettingsByObject(object));
        }
        return settings;
    }

    @Override
    public List<EFeatureSettings> getModelSettings(EObject object) {
        ArrayList<EFeatureSettings> settings = new ArrayList<EFeatureSettings>();
        for (IFeatureSettingsProvider provider : this.getProviders()) {
            settings.addAll(provider.getModelSettings(object));
        }
        return settings;
    }

    @Override
    public List<EFeatureSettings> getInterfaceSettings(EObject object) {
        ArrayList<EFeatureSettings> settings = new ArrayList<EFeatureSettings>();
        for (IFeatureSettingsProvider provider : this.getProviders()) {
            settings.addAll(provider.getInterfaceSettings(object));
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IFeatureSettingsProvider> getProviders() {
        Class<FeatureSettingsService> clazz;
        if (this.providers != null) {
            return this.providers;
        }
        Class<FeatureSettingsService> clazz2 = clazz = FeatureSettingsService.class;
        synchronized (clazz2) {
            IConfigurationElement[] configElements;
            if (this.providers != null) {
                return this.providers;
            }
            LinkedList<IFeatureSettingsProvider> allProviders = new LinkedList<IFeatureSettingsProvider>();
            IConfigurationElement[] elements = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.e1c.langtool.emf.featureSettingsProviders");
            int length = configElements.length;
            int index = 0;
            while (index < length) {
                IConfigurationElement configElement = elements[index];
                try {
                    IFeatureSettingsProvider e = (IFeatureSettingsProvider)configElement.createExecutableExtension(ATT_CLASS);
                    allProviders.add(e);
                }
                catch (CoreException e) {
                    CorePlugin.logError(e);
                }
                ++index;
            }
            this.providers = List.copyOf(allProviders);
            return this.providers;
        }
    }

    @Override
    public EFeatureSettings getSettings(EStructuralFeature eFeature, EObject object) {
        for (EFeatureSettings settings : this.allSettingsByObject(object)) {
            if (!settings.getEFeature().equals(eFeature)) continue;
            return settings;
        }
        return null;
    }

    @Override
    public boolean isInterfaceFeature(EStructuralFeature eFeature, EObject object) {
        for (EFeatureSettings settings : this.getInterfaceSettings(object)) {
            if (!settings.getEFeature().equals(eFeature)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isModelFeature(EStructuralFeature eFeature, EObject object) {
        for (EFeatureSettings settings : this.getModelSettings(object)) {
            if (!settings.getEFeature().equals(eFeature)) continue;
            return true;
        }
        return false;
    }
}

