/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.expressions;

import com._1c.g5.v8.dt.dcs.expressions.model.BinaryExpression;
import com._1c.g5.v8.dt.dcs.expressions.model.Case;
import com._1c.g5.v8.dt.dcs.expressions.model.CaseBody;
import com._1c.g5.v8.dt.dcs.expressions.model.Expression;
import com._1c.g5.v8.dt.dcs.expressions.model.ExpressionWithAlias;
import com._1c.g5.v8.dt.dcs.expressions.model.ExpressionWithDistinct;
import com._1c.g5.v8.dt.dcs.expressions.model.Expressions;
import com._1c.g5.v8.dt.dcs.expressions.model.ExpressionsPackage;
import com._1c.g5.v8.dt.dcs.expressions.model.Field;
import com._1c.g5.v8.dt.dcs.expressions.model.Function;
import com._1c.g5.v8.dt.dcs.expressions.model.Ident;
import com._1c.g5.v8.dt.dcs.expressions.model.InList;
import com._1c.g5.v8.dt.dcs.expressions.model.Like;
import com._1c.g5.v8.dt.dcs.expressions.model.MultiPartName;
import com._1c.g5.v8.dt.dcs.expressions.model.Parameter;
import com._1c.g5.v8.dt.dcs.expressions.model.SinglePartName;
import com._1c.g5.v8.dt.dcs.expressions.model.TypeLiteral;
import com._1c.g5.v8.dt.dcs.expressions.model.UnaryExpression;
import com._1c.g5.v8.dt.dcs.expressions.model.ValueLiteral;
import com.e1c.langtool.IBasicProcessor;
import java.util.ArrayDeque;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public abstract class DcsExprProcessor
implements IBasicProcessor {
    private final Collection<EObject> allObjects = new ArrayDeque<EObject>();
    protected final EObject object;
    private boolean processChildObjects;
    protected IProgressMonitor monitor;

    protected static boolean isSupported(EObject obj) {
        EPackage objectPackage = obj.eClass().getEPackage();
        return objectPackage.equals(ExpressionsPackage.eINSTANCE);
    }

    public DcsExprProcessor(EObject object) {
        this.object = object;
    }

    public boolean isCanceled() {
        return this.monitor == null ? false : this.monitor.isCanceled();
    }

    public void process(IProgressMonitor monitor) {
        this.monitor = monitor;
        if (DcsExprProcessor.isSupported(this.object)) {
            this.allObjects.add(this.object);
        }
        this.doProcessInternal(this.allObjects);
    }

    public boolean isProcessChildObjects() {
        return this.processChildObjects;
    }

    public void setProcessChildObjects(boolean processChildObjects) {
        this.processChildObjects = processChildObjects;
    }

    protected abstract <T extends EObject> void doProcess(T var1, Class<T> var2);

    private void doProcessInternal(Collection<? extends EObject> objects) {
        for (EObject eObject : objects) {
            if (this.isCanceled()) {
                return;
            }
            this.doProcessInternal(eObject);
        }
    }

    private void doProcessInternal(EObject obj) {
        if (this.isCanceled()) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof Expressions) {
            this.doProcessInternal((Expressions)obj);
        } else if (obj instanceof UnaryExpression) {
            this.doProcessInternal((UnaryExpression)obj);
        } else if (obj instanceof BinaryExpression) {
            this.doProcessInternal((BinaryExpression)obj);
        } else if (obj instanceof ValueLiteral) {
            this.doProcessInternal((ValueLiteral)obj);
        } else if (obj instanceof TypeLiteral) {
            this.doProcessInternal((TypeLiteral)obj);
        } else if (obj instanceof Case) {
            this.doProcessInternal((Case)obj);
        } else if (obj instanceof CaseBody) {
            this.doProcessInternal((CaseBody)obj);
        } else if (obj instanceof InList) {
            this.doProcessInternal((InList)obj);
        } else if (obj instanceof Like) {
            this.doProcessInternal((Like)obj);
        } else if (obj instanceof Parameter) {
            this.doProcessInternal((Parameter)obj);
        } else if (obj instanceof Ident) {
            this.doProcessInternal((Ident)obj);
        } else if (obj instanceof SinglePartName) {
            this.doProcessInternal((SinglePartName)obj);
        } else if (obj instanceof MultiPartName) {
            this.doProcessInternal((MultiPartName)obj);
        } else if (obj instanceof Field) {
            this.doProcessInternal((Field)obj);
        } else if (obj instanceof ExpressionWithAlias) {
            this.doProcessInternal((ExpressionWithAlias)obj);
        } else if (obj instanceof ExpressionWithDistinct) {
            this.doProcessInternal((ExpressionWithDistinct)obj);
        } else if (obj instanceof Function) {
            this.doProcessInternal((Function)obj);
        } else if (obj instanceof Expression) {
            this.doProcessInternal((Expression)obj);
        }
    }

    private void doProcessInternal(Expressions obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Expressions.class);
        this.doProcessInternal((EObject)obj.getItem());
    }

    private void doProcessInternal(Expression obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Expression.class);
    }

    private void doProcessInternal(UnaryExpression obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, UnaryExpression.class);
        this.doProcessInternal((EObject)obj.getOperand());
    }

    private void doProcessInternal(BinaryExpression obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, BinaryExpression.class);
        this.doProcessInternal((EObject)obj.getLeft());
        this.doProcessInternal((EObject)obj.getRight());
    }

    private void doProcessInternal(ValueLiteral obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ValueLiteral.class);
        this.doProcessInternal((EObject)obj.getValue());
    }

    private void doProcessInternal(TypeLiteral obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, TypeLiteral.class);
        this.doProcessInternal((EObject)obj.getValue());
    }

    private void doProcessInternal(Case obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Case.class);
        this.doProcessInternal(obj.getInputExpression());
        this.doProcessInternal((Collection<? extends EObject>)obj.getBody());
        this.doProcessInternal((EObject)obj.getElseExpression());
    }

    private void doProcessInternal(CaseBody obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, CaseBody.class);
        this.doProcessInternal((EObject)obj.getWhen());
        this.doProcessInternal((EObject)obj.getThen());
    }

    private void doProcessInternal(InList obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, InList.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getItems());
    }

    private void doProcessInternal(Like obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Like.class);
        this.doProcessInternal((EObject)obj.getLiteral());
        this.doProcessInternal((EObject)obj.getEscape());
    }

    private void doProcessInternal(Parameter obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Parameter.class);
    }

    private void doProcessInternal(Ident obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Ident.class);
    }

    private void doProcessInternal(SinglePartName obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, SinglePartName.class);
    }

    private void doProcessInternal(MultiPartName obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, MultiPartName.class);
        this.doProcessInternal((EObject)obj.getPrev());
    }

    private void doProcessInternal(Field obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Field.class);
        this.doProcessInternal((EObject)obj.getPath());
    }

    private void doProcessInternal(ExpressionWithAlias obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ExpressionWithAlias.class);
        this.doProcessInternal((EObject)obj.getExpression());
    }

    private void doProcessInternal(ExpressionWithDistinct obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ExpressionWithDistinct.class);
        this.doProcessInternal((EObject)obj.getExpression());
    }

    private void doProcessInternal(Function obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Function.class);
        this.doProcessInternal((EObject)obj.getName());
        this.doProcessInternal((Collection<? extends EObject>)obj.getParameters());
    }
}

