/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.expressions;

import com._1c.g5.v8.dt.bm.xtext.IDependentModelProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.dcs.expressions.ExpressionsTerms;
import com._1c.g5.v8.dt.dcs.expressions.model.Expressions;
import com._1c.g5.v8.dt.dcs.expressions.model.Function;
import com._1c.g5.v8.dt.dcs.expressions.model.StringLiteral;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.dcs.expressions.DcsExprUtils;
import com.e1c.langtool.v8.dt.dcs.expressions.StringLiteralInternalizeTokenProvider;
import com.e1c.langtool.v8.dt.dcs.expressions.settings.DcsExprFeatureSettings;
import com.e1c.langtool.v8.dt.dcs.expressions.translator.DcsExprTextProcessor;
import com.e1c.langtool.v8.dt.platform.ITranslateV8Project;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.util.CancelIndicator;

public class StringLiteralExpressionTranslationProvider
implements IComputedStringFeatureTranslationProvider {
    @Inject
    private StringLiteralInternalizeTokenProvider stringLiteralProvider;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IDependentModelProvider dependentModelProvider;

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        if (!DcsExprFeatureSettings.Literals.STRING_LITERAL__VALUE.equals(stringFeature)) {
            return false;
        }
        Function parent = (Function)object.eContainer();
        return this.stringLiteralProvider.isExpressionLiteral(parent, (StringLiteral)object);
    }

    public boolean isSupported(EObject object) {
        return object instanceof StringLiteral && object.eContainer() instanceof Function;
    }

    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        if (!DcsExprFeatureSettings.Literals.STRING_LITERAL__VALUE.equals(stringFeature)) {
            return null;
        }
        String value = DcsExprUtils.getStringLiteralValue((StringLiteral)object);
        if (StringUtils.isNullOrEmpty((String)value)) {
            return null;
        }
        Function parent = (Function)object.eContainer();
        if (this.stringLiteralProvider.isExpressionLiteral(parent, (StringLiteral)object)) {
            IFile file = this.resourceLookup.getPlatformResource(object);
            if (file == null) {
                return null;
            }
            IPath basePath = file.getProjectRelativePath().removeFileExtension().addFileExtension("dcsexpr");
            if (this.stringLiteralProvider.isExpressionListLiteral(parent, (StringLiteral)object)) {
                int index = parent.getParameters().indexOf((Object)object);
                String name = parent.getName().getFullContent();
                boolean isOrderExpressions = !(name == null || index != 5 && index != 6 || !name.equalsIgnoreCase(ExpressionsTerms.kDCSExprTerm_EvalExpression[0]) && !name.equalsIgnoreCase(ExpressionsTerms.kDCSExprTerm_EvalExpression[1]));
                ScriptVariant sourceScriptVariant = ((ITranslateV8Project)translationProvider.getProject().getSourceProject()).getScriptVariant();
                boolean sourceRu = sourceScriptVariant == ScriptVariant.RUSSIAN;
                String[] sorts = sourceRu ? StringLiteralInternalizeTokenProvider.EVAL_EXPRESSION_SORT_RU : StringLiteralInternalizeTokenProvider.EVAL_EXPRESSION_SORT_EN;
                String[] sortsTranslated = translationProvider.getProject().getScriptVariant() == ScriptVariant.RUSSIAN ? StringLiteralInternalizeTokenProvider.EVAL_EXPRESSION_SORT_RU : StringLiteralInternalizeTokenProvider.EVAL_EXPRESSION_SORT_EN;
                String[] parts = DcsExprUtils.getStringLiteralListExpressionParts((StringLiteral)object);
                CharSequence[] translated = new String[parts.length];
                System.arraycopy(parts, 0, translated, 0, parts.length);
                int i = 0;
                while (i < parts.length) {
                    String part = parts[i];
                    if (!StringUtils.isBlank((String)part)) {
                        Object translation;
                        String partAppend = null;
                        if (isOrderExpressions) {
                            String test = part.stripTrailing();
                            int j = 0;
                            while (j < sorts.length) {
                                String sort = sorts[j];
                                if (test.endsWith(" " + sort)) {
                                    int position = test.length() - sort.length() - 1;
                                    partAppend = part.substring(position);
                                    part = part.substring(0, position);
                                    partAppend = partAppend.replace(sort, sortsTranslated[j]);
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (StringUtils.isNullOrEmpty((String)(translation = this.translateExpression(object, translationProvider, part, basePath)))) {
                            translation = part;
                        }
                        if (isOrderExpressions && partAppend != null) {
                            translation = (String)translation + partAppend;
                        }
                        translated[i] = translation;
                    }
                    ++i;
                }
                return String.join((CharSequence)",", translated);
            }
            return this.translateExpression(object, translationProvider, value, basePath);
        }
        return null;
    }

    private String translateExpression(EObject object, IProjectTranslationProvider translationProvider, String value, IPath basePath) {
        Expressions expression = (Expressions)this.dependentModelProvider.getDependentModel(object, DcsExprFeatureSettings.Literals.STRING_LITERAL__VALUE.getEFeature(), basePath, (s, f) -> value, CancelIndicator.NullImpl);
        if (expression == null) {
            return null;
        }
        try {
            DcsExprTextProcessor processor = DcsExprTextProcessor.create(translationProvider, expression);
            processor.process((IProgressMonitor)new NullProgressMonitor());
            String translation = processor.getText();
            if (StringUtils.isNotEmpty((String)translation)) {
                String string = translation;
                return string;
            }
        }
        finally {
            this.dependentModelProvider.unload((EObject)expression);
        }
        return null;
    }
}

