/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.expressions.translator;

import com._1c.g5.v8.dt.bm.xtext.IDependentModelProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.dcs.expressions.ExpressionsTerms;
import com._1c.g5.v8.dt.dcs.expressions.functions.ExpressionsFunctionsFunction;
import com._1c.g5.v8.dt.dcs.expressions.functions.IExpressionsFunctionsProvider;
import com._1c.g5.v8.dt.dcs.expressions.functions.IExpressionsFunctionsProviderManager;
import com._1c.g5.v8.dt.dcs.expressions.model.ExpressionWithAlias;
import com._1c.g5.v8.dt.dcs.expressions.model.Expressions;
import com._1c.g5.v8.dt.dcs.expressions.model.Field;
import com._1c.g5.v8.dt.dcs.expressions.model.Function;
import com._1c.g5.v8.dt.dcs.expressions.model.Ident;
import com._1c.g5.v8.dt.dcs.expressions.model.Name;
import com._1c.g5.v8.dt.dcs.expressions.model.Parameter;
import com._1c.g5.v8.dt.dcs.expressions.model.StringLiteral;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.IBasicProcessor;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.converter.IConverterManager;
import com.e1c.langtool.converter.IConverterService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.ITranslateProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.Utils;
import com.e1c.langtool.v8.dt.dcs.expressions.DcsExprUtils;
import com.e1c.langtool.v8.dt.dcs.expressions.InternalizeTokenProvider;
import com.e1c.langtool.v8.dt.dcs.expressions.StringLiteralInternalizeTokenProvider;
import com.e1c.langtool.v8.dt.dcs.expressions.settings.DcsExprFeatureSettings;
import com.e1c.langtool.v8.dt.dcs.expressions.translator.FunctionProviderCache;
import com.e1c.langtool.v8.dt.internal.dcs.expressions.ExprPlugin;
import com.e1c.langtool.v8.dt.platform.ITranslateV8Project;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.xtext.MonitorBasedCancelIndicator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.CancelIndicator;

public class DcsExprTextProcessor
implements IBasicProcessor {
    private static final String SKIP_SYMBOLS_REGEX = "^[(\\)\\\"+-\\/\\\\=\\[\\]*\\%&\\.,\\:]$";
    private static final Pattern skipSymbolsPattern = Pattern.compile("^[(\\)\\\"+-\\/\\\\=\\[\\]*\\%&\\.,\\:]$");
    private static final String SINGLE_ENTRY_NSTR_TEMPLATE = "%s = '%s'";
    private final String expressionsText;
    private final Expressions expressions;
    @Inject
    private ITranslationFeatureKeyProvider translationKeyProvider;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IExpressionsFunctionsProviderManager functionProviderManager;
    @Inject
    private InternalizeTokenProvider internalizeTokenProvider;
    @Inject
    private INamedEObjectNameProvider namedEObjectNameProvider;
    @Inject
    private StringLiteralInternalizeTokenProvider stringLiteralProvider;
    @Inject
    private IDependentModelProvider dependentModelProvider;
    @Inject
    private TranslationPreferences preferences;
    @Inject
    private IConverterService converterService;
    private IExpressionsFunctionsProvider functionProvider;
    private CancelIndicator cancelIndicator;
    private IProjectTranslationProvider translationProvider;
    private MultiTextEdit edit;
    private IDocument document;
    private TranslateLanguage defaultLanguage;
    private IProgressMonitor monitor;
    private IFile resourceFile;

    public static DcsExprTextProcessor create(IProjectTranslationProvider translationProvider, Expressions expr) {
        if (translationProvider == null) {
            throw new IllegalArgumentException("TranslationProvider cannot be null");
        }
        if (expr == null) {
            throw new IllegalArgumentException("Expressions cannot be empty");
        }
        ICompositeNode tree = NodeModelUtils.getNode((EObject)expr);
        DcsExprTextProcessor processor = new DcsExprTextProcessor(tree.getText(), expr);
        ExprPlugin.getDefault().getInjector().injectMembers((Object)processor);
        processor.setTranslationProvider(translationProvider);
        return processor;
    }

    protected DcsExprTextProcessor(String expressionsText, Expressions expressions) {
        this.expressionsText = expressionsText;
        this.expressions = expressions;
    }

    public boolean isCanceled() {
        return this.monitor == null ? false : this.monitor.isCanceled();
    }

    public CancelIndicator getCancelIndicator() {
        if (this.cancelIndicator == null) {
            this.cancelIndicator = this.monitor == null ? CancelIndicator.NullImpl : new MonitorBasedCancelIndicator(this.monitor);
        }
        return this.cancelIndicator;
    }

    public String getText() {
        if (this.document != null) {
            return this.document.get();
        }
        return this.expressionsText;
    }

    public void setTranslationProvider(IProjectTranslationProvider translationProvider) {
        this.translationProvider = translationProvider;
    }

    public void process(IProgressMonitor monitor) {
        this.monitor = monitor;
        EcoreUtil2.resolveLazyCrossReferences((Resource)this.expressions.eResource(), (CancelIndicator)this.getCancelIndicator());
        ICompositeNode tree = NodeModelUtils.getNode((EObject)this.expressions);
        if (tree == null) {
            return;
        }
        this.document = new Document(this.expressionsText);
        this.edit = new MultiTextEdit();
        this.visit(tree);
        if (this.isCanceled()) {
            return;
        }
        try {
            this.edit.apply(this.document);
        }
        catch (BadLocationException | MalformedTreeException e) {
            ExprPlugin.logError(e);
        }
    }

    private void visit(ICompositeNode tree) {
        for (INode child : tree.getChildren()) {
            if (this.isCanceled()) {
                return;
            }
            this.visit(child);
        }
    }

    private void visit(INode node) {
        if (this.isCanceled()) {
            return;
        }
        if (node instanceof ICompositeNode) {
            this.visit((ICompositeNode)node);
        } else if (node instanceof ILeafNode) {
            this.visit((ILeafNode)node);
        }
    }

    private void visit(ILeafNode node) {
        if (node.isHidden()) {
            return;
        }
        String text = node.getText();
        if (this.isSkipSymbols(text)) {
            return;
        }
        String replace = null;
        EObject semanticElement = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        replace = this.getReplaceText(semanticElement);
        if (StringUtils.isNullOrEmpty((String)replace)) {
            EObject grammarElement = node.getGrammarElement();
            if (grammarElement instanceof Keyword) {
                replace = this.getReplaceText(grammarElement);
                if (StringUtils.isNotEmpty((String)replace)) {
                    this.addReplace(node, replace);
                }
            } else if (grammarElement instanceof EnumLiteralDeclaration) {
                Keyword literal = ((EnumLiteralDeclaration)grammarElement).getLiteral();
                if (literal instanceof Keyword && StringUtils.isNotEmpty((String)(replace = this.getReplaceText(literal)))) {
                    this.addReplace(node, replace);
                }
            } else if (grammarElement instanceof TerminalRule) {
                ScriptVariant target;
                ScriptVariant source = ((ITranslateV8Project)this.translationProvider.getProject().getSourceProject()).getScriptVariant();
                if (text.equalsIgnoreCase(ExpressionsTerms.kDCSExprTerm_OrderDesc[source.getValue()])) {
                    ScriptVariant target2 = this.translationProvider.getProject().getScriptVariant();
                    replace = ExpressionsTerms.kDCSExprTerm_OrderDesc[target2.getValue()];
                    if (StringUtils.isNotEmpty((String)replace)) {
                        this.addReplace(node, replace);
                    }
                } else if (text.equalsIgnoreCase(ExpressionsTerms.kDCSExprTerm_OrderAsc[source.getValue()]) && StringUtils.isNotEmpty((String)(replace = ExpressionsTerms.kDCSExprTerm_OrderAsc[(target = this.translationProvider.getProject().getScriptVariant()).getValue()]))) {
                    this.addReplace(node, replace);
                }
            }
        } else if (StringUtils.isNotEmpty((String)replace) && semanticElement instanceof Parameter) {
            Parameter param = (Parameter)semanticElement;
            String[] source = param.getValue().split("\\.");
            if (source.length == 2) {
                String[] segments = replace.split("\\.");
                int index = source[0].equals(text) ? 0 : 1;
                this.addReplace(node, segments[index]);
            } else {
                this.addReplace(node, replace);
            }
        } else {
            this.addReplace(node, replace);
        }
    }

    private boolean isSkipSymbols(String text) {
        return skipSymbolsPattern.matcher(text).matches();
    }

    private void addReplace(ILeafNode node, String replace) {
        int offcet = node.getOffset();
        int length = node.getLength();
        String text = node.getText();
        if (StringUtils.isNotEmpty((String)replace) && !text.equals(replace)) {
            this.edit.addChild((TextEdit)new ReplaceEdit(offcet, length, replace));
            if (ExprPlugin.getDefault().isDebugging()) {
                System.out.println(text + " = " + replace);
            }
        }
    }

    private String getReplaceText(EObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof StringLiteral) {
            return this.getReplaceText((StringLiteral)object);
        }
        if (object instanceof Parameter) {
            return this.getReplaceText((Parameter)object);
        }
        if (object instanceof Ident) {
            return this.getReplaceText((Ident)object);
        }
        if (object instanceof ExpressionWithAlias) {
            return this.getReplaceText((ExpressionWithAlias)object);
        }
        if (object instanceof Name) {
            return this.getReplaceText((Name)object);
        }
        if (object instanceof Keyword) {
            return this.getReplaceText((Keyword)object);
        }
        if (ExprPlugin.getDefault().isDebugging()) {
            System.err.println("DcsExprTextProcessor: unknown replace text type: " + object.getClass().toString());
        }
        return null;
    }

    private String getReplaceText(Keyword keyword) {
        if (!this.translationProvider.getProject().isChangeScriptVariant()) {
            return null;
        }
        boolean isRussian = this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        return this.internalizeTokenProvider.getInternalizeKeyword(keyword, isRussian);
    }

    private TranslateLanguage getDefaultLanguage() {
        if (this.defaultLanguage == null) {
            this.defaultLanguage = this.translationProvider.getProject().getDefaultLanguage();
        }
        return this.defaultLanguage;
    }

    protected String getTranslation(EObject source, EFeatureSettings featureSettings) {
        return this.getTranslation(source, featureSettings, (object, feature) -> (String)object.eGet(feature.getEFeature()));
    }

    protected String getTranslation(StringLiteral literal) {
        return this.getTranslation(literal, DcsExprFeatureSettings.Literals.STRING_LITERAL__VALUE, (source, unused) -> DcsExprUtils.getStringLiteralValue(source));
    }

    private <T extends EObject> String getTranslation(T source, EFeatureSettings featureSettings, BiFunction<T, EFeatureSettings, String> stringGetter) {
        String stringValue = stringGetter.apply(source, featureSettings);
        FeatureKey featureKey = this.translationKeyProvider.getFeatureKey(source, (FeatureSettings)featureSettings);
        ContextTranslationKeyImpl key = new ContextTranslationKeyImpl(this.getResourceFile(), featureKey, (FeatureSettings)featureSettings, stringValue);
        return this.translationProvider.getTranslation(source, (ContextTranslationKey)key, this.getDefaultLanguage());
    }

    private String getReplaceText(StringLiteral object) {
        if (object == null) {
            return null;
        }
        if (DcsExprUtils.isNls((EObject)object)) {
            return this.getReplaceStringLiteralNstr(object);
        }
        return this.getReplaceStringLiteralText(object);
    }

    private String getReplaceStringLiteralText(StringLiteral object) {
        if (!this.isChangeDefaultLanguage() && !this.translationProvider.getProject().isChangeScriptVariant()) {
            return null;
        }
        String translation = null;
        if (object.eContainer() instanceof Function) {
            boolean isRussian = this.translationProvider.getProject().isChangeScriptVariant() ? this.translationProvider.getProject().getScriptVariant() == ScriptVariant.RUSSIAN : this.translationProvider.getProject().getScriptVariant() == ScriptVariant.ENGLISH;
            Function function = (Function)object.eContainer();
            translation = this.stringLiteralProvider.getLiteralEnumValue(function, object, isRussian);
            if (StringUtils.isNotEmpty((String)translation)) {
                return this.translationProvider.getProject().isChangeScriptVariant() ? DcsExprUtils.formatStringLiteralValue(translation) : object.getValue();
            }
        }
        if (StringUtils.isNotEmpty((String)(translation = this.getTranslation(object)))) {
            return DcsExprUtils.formatStringLiteralValue(translation);
        }
        return this.getReplaceStringLiteralParam(object);
    }

    private String getReplaceStringLiteralNstr(StringLiteral literal) {
        IConverterManager manager;
        TranslateLanguage language;
        Map params;
        Map<String, String> nls = DcsExprUtils.getNlsLocalStrings((EObject)literal);
        ITranslatingProject sourceProject = this.translationProvider.getProject().getSourceProject();
        String sourceLanguageCode = sourceProject.getDefaultLanguage().getLanguageCode();
        String sourceString = nls.get(sourceLanguageCode);
        if (nls.isEmpty() || StringUtils.isNullOrEmpty((String)sourceString)) {
            return null;
        }
        List<String> languageCodes = this.getLanguageCodes();
        String[] sourceLanguageCodes = nls.keySet().toArray(new String[0]);
        int i = 0;
        while (i < sourceLanguageCodes.length) {
            String languageCode = sourceLanguageCodes[i];
            if (!languageCodes.contains(languageCode)) {
                nls.remove(languageCode);
            }
            ++i;
        }
        FeatureKey featureKey = this.translationKeyProvider.getFeatureKey((EObject)literal, (FeatureSettings)DcsExprFeatureSettings.Literals.NSTR_STRING_LITERAL__VALUE);
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.getResourceFile(), featureKey, (FeatureSettings)DcsExprFeatureSettings.Literals.NSTR_STRING_LITERAL__VALUE, sourceString);
        for (TranslateLanguage language2 : this.translationProvider.getProject().getInterfaceLanguages()) {
            String translation = this.translationProvider.getTranslation((EObject)literal, (ContextTranslationKey)contextKey, language2);
            if (StringUtils.isNullOrEmpty((String)translation)) {
                translation = sourceString;
            }
            nls.put(language2.getLanguageCode(), translation);
        }
        if (this.isChangeDefaultLanguage() && !(params = Utils.getParamsMapFromNls((String)sourceString)).isEmpty()) {
            FeatureKey featureKeyPreffix = featureKey.skipLast(2);
            HashMap paramTranslations = Maps.newHashMap();
            for (Map.Entry entry : params.entrySet()) {
                ContextTranslationKeyImpl paramValue;
                String translation;
                String param = (String)entry.getKey();
                if (StringUtils.isNullOrEmpty((String)param) || !StringUtils.isNotEmpty((String)(translation = this.translationProvider.getTranslation((EObject)literal, (ContextTranslationKey)(paramValue = new ContextTranslationKeyImpl(this.getResourceFile(), featureKeyPreffix.append(param).append("Param"), DcsExprFeatureSettings.Literals.STRING_LITERAL__PARAM, param)), this.getDefaultLanguage())))) continue;
                paramTranslations.put(param, ((String)entry.getValue()).replace((CharSequence)entry.getKey(), translation));
            }
            this.replaceParamsInNlsStrings(nls, params, paramTranslations);
        }
        String formattedNstr = this.formatNStr(nls);
        IProject project = sourceProject.getProject();
        if (this.preferences.getTranslationProperties(project).isEnablePersistentKeyMappingCache() && (language = (manager = this.converterService.getManager(project)).getLanguage()).getLanguageCode().equals(this.getDefaultLanguage().getLanguageCode())) {
            FeatureKey convertedFeatureKey = this.translationKeyProvider.getConvertedFeatureKey((EObject)literal, (FeatureSettings)DcsExprFeatureSettings.Literals.NSTR_STRING_LITERAL__VALUE, nls.get(this.defaultLanguage.getLanguageCode()), (ITranslateProject)this.translationProvider.getProject());
            Path path = new Path(EcoreUtil.getURI((EObject)literal).trimFragment().toPlatformString(true));
            manager.updateConvertedValues(path.makeRelativeTo(project.getFullPath()), featureKey, convertedFeatureKey);
        }
        return DcsExprUtils.formatStringLiteralValue(formattedNstr);
    }

    private void replaceParamsInNlsStrings(Map<String, String> localStringsMap, Map<String, String> params, Map<String, String> paramTranslations) {
        if (paramTranslations.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : localStringsMap.entrySet()) {
            for (Map.Entry<String, String> translationEntry : paramTranslations.entrySet()) {
                String source = params.get(translationEntry.getKey());
                entry.setValue(entry.getValue().replace(source, translationEntry.getValue()));
            }
        }
    }

    private String getReplaceStringLiteralParam(StringLiteral literal) {
        String literalContent = DcsExprUtils.getStringLiteralValue(literal);
        Map params = Utils.getParamsMapFromNls((String)literalContent);
        if (params.size() == 1 && params.containsValue(literalContent.trim())) {
            String param = (String)params.entrySet().iterator().next().getKey();
            if (StringUtils.isNullOrEmpty((String)param)) {
                return null;
            }
            FeatureKey featureKey = this.translationKeyProvider.getFeatureKey((EObject)literal, (FeatureSettings)DcsExprFeatureSettings.Literals.STRING_LITERAL__VALUE);
            if (featureKey.getSegmentCount() <= 2) {
                return null;
            }
            FeatureKey featureKeyPreffix = featureKey.skipLast(2);
            String fullPath = this.getResourceFile().getFullPath().toString();
            ContextTranslationKeyImpl paramValue = new ContextTranslationKeyImpl(fullPath, featureKeyPreffix.append(param).append("Param"), DcsExprFeatureSettings.Literals.STRING_LITERAL__PARAM, param);
            String translation = this.translationProvider.getTranslation((EObject)literal, (ContextTranslationKey)paramValue, this.getDefaultLanguage());
            if (StringUtils.isNotEmpty((String)translation)) {
                return DcsExprUtils.formatStringLiteralValue(literalContent.replace(param, translation));
            }
        }
        return null;
    }

    private String getReplaceText(Parameter object) {
        if (object == null || !this.isChangeDefaultLanguage()) {
            return null;
        }
        return this.getTranslation((EObject)object, DcsExprFeatureSettings.Literals.PARAMETER__VALUE);
    }

    private String getReplaceText(Ident object) {
        if (object == null || !this.isChangeDefaultLanguage()) {
            return null;
        }
        return this.getTranslation((EObject)object, DcsExprFeatureSettings.Literals.IDENT__VALUE);
    }

    private String getReplaceText(ExpressionWithAlias object) {
        if (object == null || !this.isChangeDefaultLanguage()) {
            return null;
        }
        return this.getTranslation((EObject)object, DcsExprFeatureSettings.Literals.EXPRESSION_WITH_ALIAS__ALIAS);
    }

    private String getReplaceText(Name object) {
        if (object == null) {
            return null;
        }
        String translation = null;
        if (object.eContainer() instanceof Function) {
            ScriptVariant source;
            String name = object.getFullContent();
            ExpressionsFunctionsFunction function = this.getFunctionProvider().getBuiltinFunctions().getFunctionByName(name);
            if (function != null) {
                translation = function.getName(this.translationProvider.getProject().getScriptVariant());
            } else if (StringUtils.isNotEmpty((String)name) && name.equals(ExpressionsTerms.kDCSExprTerm_RecordsPosition_BoundaryValue[(source = ((ITranslateV8Project)this.translationProvider.getProject().getSourceProject()).getScriptVariant()).getValue()])) {
                ScriptVariant target = this.translationProvider.getProject().getScriptVariant();
                translation = ExpressionsTerms.kDCSExprTerm_RecordsPosition_BoundaryValue[target.getValue()];
            }
        } else {
            Pair translationContent;
            Field field = (Field)EcoreUtil2.getContainerOfType((EObject)object, Field.class);
            if (field != null && (translationContent = this.namedEObjectNameProvider.getTranslatedName((EObject)object, this.translationProvider)) != null && object.getContent().equalsIgnoreCase((String)translationContent.getKey())) {
                translation = (String)translationContent.getValue();
            }
        }
        if (StringUtils.isNullOrEmpty(translation)) {
            translation = this.getTranslation((EObject)object, DcsExprFeatureSettings.Literals.NAME__CONTENT);
        }
        return translation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IExpressionsFunctionsProvider getFunctionProvider() {
        if (this.functionProvider == null) {
            FunctionProviderCache cache;
            FunctionProviderCache functionProviderCache = cache = (FunctionProviderCache)this.translationProvider.getCache(FunctionProviderCache.class);
            synchronized (functionProviderCache) {
                IExpressionsFunctionsProvider provider = cache.getFunctionProvider();
                if (provider == null) {
                    this.functionProviderManager.init(this.expressions.eResource());
                    provider = this.functionProviderManager.get();
                    cache.setFunctionProvider(provider);
                }
                this.functionProvider = provider;
            }
        }
        return this.functionProvider;
    }

    private boolean isChangeDefaultLanguage() {
        return this.translationProvider.getProject().isChangeDefaultLanguage();
    }

    private List<String> getLanguageCodes() {
        ArrayList languageCodes = Lists.newArrayList();
        for (Language language : this.translationProvider.getProject().getLanguages()) {
            String languageCode = language.getLanguageCode();
            if (StringUtils.isNullOrEmpty((String)languageCode)) continue;
            languageCodes.add(language.getLanguageCode());
        }
        return languageCodes;
    }

    private IFile getResourceFile() {
        if (this.resourceFile == null) {
            Expressions root = this.expressions;
            while (root != null && root.eResource() != null && !root.eResource().getContents().isEmpty()) {
                EObject parent = this.dependentModelProvider.getParent((EObject)(root = (EObject)root.eResource().getContents().get(0)));
                if (parent == null) break;
                root = parent;
            }
            this.resourceFile = this.resourceLookup.getPlatformResource((EObject)root);
        }
        return this.resourceFile;
    }

    private String formatNStr(Map<String, String> strings) {
        return strings.entrySet().stream().map(entry -> String.format(SINGLE_ENTRY_NSTR_TEMPLATE, entry.getKey(), ((String)entry.getValue()).replace("'", "''"))).collect(Collectors.joining("; "));
    }
}

