/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.expressions.translator;

import com._1c.g5.v8.dt.bm.xtext.IDependentModelProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.dcs.expressions.model.ExpressionsPackage;
import com._1c.g5.v8.dt.dcs.expressions.model.Function;
import com._1c.g5.v8.dt.dcs.expressions.model.StringLiteral;
import com.e1c.langtool.v8.dt.dcs.expressions.DcsExprUtils;
import com.e1c.langtool.v8.dt.dcs.expressions.StringLiteralInternalizeTokenProvider;
import com.e1c.langtool.v8.dt.translator.DelegatingObjectFeature;
import com.e1c.langtool.v8.dt.translator.V8ObjectIdObjectResolver;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.util.CancelIndicator;

public class V8ObjectIdStringLiteralExpressionsResolver
implements V8ObjectIdObjectResolver {
    private static final List<EClass> CLASSES = List.of(ExpressionsPackage.Literals.STRING_LITERAL);
    private final IResourceLookup resourceLookup;
    private final IDependentModelProvider dependentModelProvider;
    private final StringLiteralInternalizeTokenProvider stringLiteralInternalizeTokenProvider;

    @Inject
    public V8ObjectIdStringLiteralExpressionsResolver(IResourceLookup resourceLookup, IDependentModelProvider dependentModelProvider, StringLiteralInternalizeTokenProvider stringLiteralInternalizeTokenProvider) {
        this.resourceLookup = resourceLookup;
        this.dependentModelProvider = dependentModelProvider;
        this.stringLiteralInternalizeTokenProvider = stringLiteralInternalizeTokenProvider;
    }

    public Collection<EClass> getSourceObjects() {
        return CLASSES;
    }

    public EClass getTargetObject() {
        return ExpressionsPackage.Literals.EXPRESSIONS;
    }

    public Object resolveObject(EObject parent, DelegatingObjectFeature objectFeature) {
        StringLiteral literal;
        IFile file = this.resourceLookup.getPlatformResource(parent);
        if (file == null || !(parent instanceof StringLiteral) || !(parent.eContainer() instanceof Function)) {
            return null;
        }
        Function function = (Function)parent.eContainer();
        if (this.stringLiteralInternalizeTokenProvider.isExpressionListLiteral(function, literal = (StringLiteral)parent)) {
            String[] parts = DcsExprUtils.getStringLiteralListExpressionParts(literal);
            if (parts.length > objectFeature.getIndex()) {
                IPath basePath = file.getProjectRelativePath().removeFileExtension().addFileExtension("dcsexpr");
                return this.dependentModelProvider.getDependentModel(parent, objectFeature.getFeature(), basePath, (s, f) -> parts[objectFeature.getIndex()], CancelIndicator.NullImpl);
            }
        } else if (this.stringLiteralInternalizeTokenProvider.isExpressionLiteral(function, literal)) {
            IPath basePath = file.getProjectRelativePath().removeFileExtension().addFileExtension("dcsexpr");
            return this.dependentModelProvider.getDependentModel(parent, objectFeature.getFeature(), basePath, (s, f) -> DcsExprUtils.getStringLiteralValue((StringLiteral)s), CancelIndicator.NullImpl);
        }
        return null;
    }
}

