/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.dcs.expressions.languageprocessor;

import com._1c.g5.v8.dt.dcs.expressions.model.Expressions;
import com._1c.g5.v8.dt.dcs.expressions.model.StringLiteral;
import com.e1c.langtool.IBasicProcessor;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.dcs.expressions.DcsExprUtils;
import com.e1c.langtool.v8.dt.internal.dcs.expressions.ExprPlugin;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class DcsExprNStrCleanupProcessor
implements IBasicProcessor {
    private static final String SKIP_SYMBOLS_REGEX = "^[(\\)\\\"+-\\/\\\\=\\[\\]*\\%&\\.,\\:]$";
    private static final Pattern SKIP_SYMBOLS_PATTERN = Pattern.compile("^[(\\)\\\"+-\\/\\\\=\\[\\]*\\%&\\.,\\:]$");
    private static final String NSTR_TEMPLATE = "{0} = ''{1}'';";
    private static final String SINGLE_ENTRY_NSTR_TEMPLATE = "%s = '%s'";
    private final Expressions expressions;
    private final String defaultLanguageCode;
    private final List<String> languageCodes;
    private String expressionsText;
    private IProgressMonitor monitor;
    private MultiTextEdit edit;
    private IDocument document;
    private boolean keepLanguages;

    public DcsExprNStrCleanupProcessor(Expressions expressions, String defaultLanguageCode, List<String> languagesCodes, boolean keepLanguages) {
        this.expressions = expressions;
        this.defaultLanguageCode = defaultLanguageCode;
        this.languageCodes = languagesCodes;
        this.keepLanguages = keepLanguages;
    }

    public boolean isCanceled() {
        return this.monitor != null && this.monitor.isCanceled();
    }

    public void process(IProgressMonitor monitor) {
        if (this.expressions == null) {
            return;
        }
        this.monitor = monitor;
        ICompositeNode tree = NodeModelUtils.getNode((EObject)this.expressions);
        if (tree == null) {
            return;
        }
        this.expressionsText = tree.getText();
        this.document = new Document(this.expressionsText);
        this.edit = new MultiTextEdit();
        this.visit(tree);
        if (this.isCanceled()) {
            return;
        }
        try {
            this.edit.apply(this.document);
        }
        catch (BadLocationException | MalformedTreeException e) {
            ExprPlugin.logError(e);
        }
    }

    public String getText() {
        if (this.document != null) {
            return this.document.get();
        }
        return this.expressionsText;
    }

    private void visit(ICompositeNode tree) {
        for (INode child : tree.getChildren()) {
            if (this.isCanceled()) {
                return;
            }
            this.visit(child);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void visit(INode node) {
        if (this.isCanceled()) {
            return;
        }
        INode iNode = node;
        if (iNode instanceof ICompositeNode) {
            void compositeNode;
            ICompositeNode iCompositeNode = (ICompositeNode)iNode;
            ICompositeNode cfr_ignored_0 = (ICompositeNode)iNode;
            this.visit((ICompositeNode)compositeNode);
        } else {
            INode iNode2 = node;
            if (iNode2 instanceof ILeafNode) {
                void leafNode;
                ILeafNode iLeafNode = (ILeafNode)iNode2;
                ILeafNode cfr_ignored_1 = (ILeafNode)iNode2;
                this.visit((ILeafNode)leafNode);
            }
        }
    }

    private void visit(ILeafNode node) {
        if (node.isHidden()) {
            return;
        }
        String text = node.getText();
        if (this.isSkipSymbols(text)) {
            return;
        }
        String replace = null;
        EObject semanticElement = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        replace = this.getReplaceText(semanticElement);
        if (replace != null) {
            this.addReplace(node, replace);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getReplaceText(EObject object) {
        if (object == null) {
            return null;
        }
        EObject eObject = object;
        if (eObject instanceof StringLiteral) {
            void literal;
            StringLiteral stringLiteral = (StringLiteral)eObject;
            StringLiteral cfr_ignored_0 = (StringLiteral)eObject;
            return this.getReplaceText((StringLiteral)literal);
        }
        return null;
    }

    private String getReplaceText(StringLiteral object) {
        if (object == null) {
            return null;
        }
        if (DcsExprUtils.isNls((EObject)object)) {
            return this.getReplaceStringLiteralNstr(object);
        }
        return null;
    }

    private String getReplaceStringLiteralNstr(StringLiteral literal) {
        Map<String, String> nls = DcsExprUtils.getNlsLocalStrings((EObject)literal);
        String sourceString = nls.get(this.defaultLanguageCode);
        if (nls.isEmpty() || StringUtils.isNullOrEmpty((String)sourceString)) {
            return null;
        }
        Iterator<Map.Entry<String, String>> iterator = nls.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String languageCode = entry.getKey();
            if (languageCode.equalsIgnoreCase(this.defaultLanguageCode)) continue;
            boolean isRemove = false;
            isRemove = this.keepLanguages ? !this.languageCodes.contains(languageCode) : this.languageCodes.contains(languageCode);
            if (!isRemove) continue;
            iterator.remove();
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : nls.entrySet()) {
            sb.append(MessageFormat.format(NSTR_TEMPLATE, entry.getKey(), entry.getValue()));
        }
        String formattedNstr = this.formatNStr(nls);
        return DcsExprUtils.formatStringLiteralValue(formattedNstr);
    }

    private void addReplace(ILeafNode node, String replace) {
        int offset = node.getOffset();
        int length = node.getLength();
        String text = node.getText();
        if (StringUtils.isNotEmpty((String)replace) && !text.equals(replace)) {
            this.edit.addChild((TextEdit)new ReplaceEdit(offset, length, replace));
        }
    }

    private boolean isSkipSymbols(String text) {
        return SKIP_SYMBOLS_PATTERN.matcher(text).matches();
    }

    private String formatNStr(Map<String, String> strings) {
        return strings.entrySet().stream().map(entry -> String.format(SINGLE_ENTRY_NSTR_TEMPLATE, entry.getKey(), ((String)entry.getValue()).replace("'", "''"))).collect(Collectors.joining("; "));
    }
}

